/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeSubnets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSubnetsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeSubnetsRequest.Builder, DescribeSubnetsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSubnetsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSubnetsRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("SubnetId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SubnetId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SubnetId").unmarshallLocationName("SubnetId").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            SUBNET_IDS_FIELD));

    private final List<Filter> filters;

    private final List<String> subnetIds;

    private DescribeSubnetsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.subnetIds = builder.subnetIds;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>availabilityZone</code> - The Availability Zone for the subnet. You can also use
     * <code>availability-zone</code> as the filter name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cidrBlock</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly match the
     * subnet's CIDR block for information to be returned for the subnet. You can also use <code>cidr</code> or
     * <code>cidr-block</code> as the filter names.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>defaultForAz</code> - Indicates whether this is the default subnet for the Availability Zone. You can also
     * use <code>default-for-az</code> as the filter name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the subnet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block associated
     * with the subnet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the subnet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>subnet-id</code> - The ID of the subnet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in
     * the filter name and the tag value as the filter value. For example, to find all resources that have a tag with
     * the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     * and <code>TeamA</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-id</code> - The ID of the VPC for the subnet.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>availabilityZone</code> - The Availability Zone for the subnet. You can also use
     *         <code>availability-zone</code> as the filter name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cidrBlock</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly match
     *         the subnet's CIDR block for information to be returned for the subnet. You can also use <code>cidr</code>
     *         or <code>cidr-block</code> as the filter names.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>defaultForAz</code> - Indicates whether this is the default subnet for the Availability Zone. You
     *         can also use <code>default-for-az</code> as the filter name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the subnet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block
     *         associated with the subnet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the
     *         subnet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>subnet-id</code> - The ID of the subnet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
     *         key in the filter name and the tag value as the filter value. For example, to find all resources that
     *         have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
     *         <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         assigned a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-id</code> - The ID of the VPC for the subnet.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more subnet IDs.
     * </p>
     * <p>
     * Default: Describes all your subnets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more subnet IDs.</p>
     *         <p>
     *         Default: Describes all your subnets.
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(subnetIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubnetsRequest)) {
            return false;
        }
        DescribeSubnetsRequest other = (DescribeSubnetsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(subnetIds(), other.subnetIds());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeSubnetsRequest").add("Filters", filters()).add("SubnetIds", subnetIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSubnetsRequest, T> g) {
        return obj -> g.apply((DescribeSubnetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSubnetsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availabilityZone</code> - The Availability Zone for the subnet. You can also use
         * <code>availability-zone</code> as the filter name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cidrBlock</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly match the
         * subnet's CIDR block for information to be returned for the subnet. You can also use <code>cidr</code> or
         * <code>cidr-block</code> as the filter names.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>defaultForAz</code> - Indicates whether this is the default subnet for the Availability Zone. You can
         * also use <code>default-for-az</code> as the filter name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block associated
         * with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the subnet.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availabilityZone</code> - The Availability Zone for the subnet. You can also use
         *        <code>availability-zone</code> as the filter name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are
         *        available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cidrBlock</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly
         *        match the subnet's CIDR block for information to be returned for the subnet. You can also use
         *        <code>cidr</code> or <code>cidr-block</code> as the filter names.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>defaultForAz</code> - Indicates whether this is the default subnet for the Availability Zone.
         *        You can also use <code>default-for-az</code> as the filter name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the
         *        subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block
         *        associated with the subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the
         *        subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-id</code> - The ID of the subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC for the subnet.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availabilityZone</code> - The Availability Zone for the subnet. You can also use
         * <code>availability-zone</code> as the filter name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cidrBlock</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly match the
         * subnet's CIDR block for information to be returned for the subnet. You can also use <code>cidr</code> or
         * <code>cidr-block</code> as the filter names.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>defaultForAz</code> - Indicates whether this is the default subnet for the Availability Zone. You can
         * also use <code>default-for-az</code> as the filter name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block associated
         * with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the subnet.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availabilityZone</code> - The Availability Zone for the subnet. You can also use
         *        <code>availability-zone</code> as the filter name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are
         *        available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cidrBlock</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly
         *        match the subnet's CIDR block for information to be returned for the subnet. You can also use
         *        <code>cidr</code> or <code>cidr-block</code> as the filter names.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>defaultForAz</code> - Indicates whether this is the default subnet for the Availability Zone.
         *        You can also use <code>default-for-az</code> as the filter name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the
         *        subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block
         *        associated with the subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the
         *        subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-id</code> - The ID of the subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC for the subnet.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availabilityZone</code> - The Availability Zone for the subnet. You can also use
         * <code>availability-zone</code> as the filter name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cidrBlock</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly match the
         * subnet's CIDR block for information to be returned for the subnet. You can also use <code>cidr</code> or
         * <code>cidr-block</code> as the filter names.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>defaultForAz</code> - Indicates whether this is the default subnet for the Availability Zone. You can
         * also use <code>default-for-az</code> as the filter name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block associated
         * with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the subnet.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * One or more subnet IDs.
         * </p>
         * <p>
         * Default: Describes all your subnets.
         * </p>
         * 
         * @param subnetIds
         *        One or more subnet IDs.</p>
         *        <p>
         *        Default: Describes all your subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * One or more subnet IDs.
         * </p>
         * <p>
         * Default: Describes all your subnets.
         * </p>
         * 
         * @param subnetIds
         *        One or more subnet IDs.</p>
         *        <p>
         *        Default: Describes all your subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubnetsRequest model) {
            super(model);
            filters(model.filters);
            subnetIds(model.subnetIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getSubnetIds() {
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdStringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdStringListCopier.copy(subnetIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSubnetsRequest build() {
            return new DescribeSubnetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
