/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a DHCP configuration option.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DhcpConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DhcpConfiguration.Builder, DhcpConfiguration> {
    private static final SdkField<String> KEY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DhcpConfiguration::key))
            .setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").unmarshallLocationName("key")
                    .build()).build();

    private static final SdkField<List<AttributeValue>> VALUES_FIELD = SdkField
            .<List<AttributeValue>> builder(MarshallingType.LIST)
            .getter(getter(DhcpConfiguration::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueSet")
                    .unmarshallLocationName("valueSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final List<AttributeValue> values;

    private DhcpConfiguration(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
    }

    /**
     * <p>
     * The name of a DHCP option.
     * </p>
     * 
     * @return The name of a DHCP option.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * One or more values for the DHCP option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more values for the DHCP option.
     */
    public List<AttributeValue> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DhcpConfiguration)) {
            return false;
        }
        DhcpConfiguration other = (DhcpConfiguration) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(values(), other.values());
    }

    @Override
    public String toString() {
        return ToString.builder("DhcpConfiguration").add("Key", key()).add("Values", values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DhcpConfiguration, T> g) {
        return obj -> g.apply((DhcpConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DhcpConfiguration> {
        /**
         * <p>
         * The name of a DHCP option.
         * </p>
         * 
         * @param key
         *        The name of a DHCP option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * One or more values for the DHCP option.
         * </p>
         * 
         * @param values
         *        One or more values for the DHCP option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<AttributeValue> values);

        /**
         * <p>
         * One or more values for the DHCP option.
         * </p>
         * 
         * @param values
         *        One or more values for the DHCP option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(AttributeValue... values);

        /**
         * <p>
         * One or more values for the DHCP option.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttributeValue>.Builder} avoiding the need
         * to create one manually via {@link List<AttributeValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeValue>.Builder#build()} is called immediately and
         * its result is passed to {@link #values(List<AttributeValue>)}.
         * 
         * @param values
         *        a consumer that will call methods on {@link List<AttributeValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(List<AttributeValue>)
         */
        Builder values(Consumer<AttributeValue.Builder>... values);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private List<AttributeValue> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DhcpConfiguration model) {
            key(model.key);
            values(model.values);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<AttributeValue.Builder> getValues() {
            return values != null ? values.stream().map(AttributeValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder values(Collection<AttributeValue> values) {
            this.values = DhcpConfigurationValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(AttributeValue... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<AttributeValue.Builder>... values) {
            values(Stream.of(values).map(c -> AttributeValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValues(Collection<AttributeValue.BuilderImpl> values) {
            this.values = DhcpConfigurationValueListCopier.copyFromBuilder(values);
        }

        @Override
        public DhcpConfiguration build() {
            return new DhcpConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
