/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes overrides for a launch template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetLaunchTemplateOverridesRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<FleetLaunchTemplateOverridesRequest.Builder, FleetLaunchTemplateOverridesRequest> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FleetLaunchTemplateOverridesRequest::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("InstanceType").build()).build();

    private static final SdkField<String> MAX_PRICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FleetLaunchTemplateOverridesRequest::maxPrice))
            .setter(setter(Builder::maxPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPrice")
                    .unmarshallLocationName("MaxPrice").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FleetLaunchTemplateOverridesRequest::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("SubnetId").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FleetLaunchTemplateOverridesRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("AvailabilityZone").build()).build();

    private static final SdkField<Double> WEIGHTED_CAPACITY_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(FleetLaunchTemplateOverridesRequest::weightedCapacity))
            .setter(setter(Builder::weightedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightedCapacity")
                    .unmarshallLocationName("WeightedCapacity").build()).build();

    private static final SdkField<Double> PRIORITY_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(FleetLaunchTemplateOverridesRequest::priority))
            .setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority")
                    .unmarshallLocationName("Priority").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD,
            MAX_PRICE_FIELD, SUBNET_ID_FIELD, AVAILABILITY_ZONE_FIELD, WEIGHTED_CAPACITY_FIELD, PRIORITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceType;

    private final String maxPrice;

    private final String subnetId;

    private final String availabilityZone;

    private final Double weightedCapacity;

    private final Double priority;

    private FleetLaunchTemplateOverridesRequest(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.maxPrice = builder.maxPrice;
        this.subnetId = builder.subnetId;
        this.availabilityZone = builder.availabilityZone;
        this.weightedCapacity = builder.weightedCapacity;
        this.priority = builder.priority;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type.
     * @see InstanceType
     */
    public InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type.
     * @see InstanceType
     */
    public String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The maximum price per unit hour that you are willing to pay for a Spot Instance.
     * </p>
     * 
     * @return The maximum price per unit hour that you are willing to pay for a Spot Instance.
     */
    public String maxPrice() {
        return maxPrice;
    }

    /**
     * <p>
     * The ID of the subnet in which to launch the instances.
     * </p>
     * 
     * @return The ID of the subnet in which to launch the instances.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The Availability Zone in which to launch the instances.
     * </p>
     * 
     * @return The Availability Zone in which to launch the instances.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The number of units provided by the specified instance type.
     * </p>
     * 
     * @return The number of units provided by the specified instance type.
     */
    public Double weightedCapacity() {
        return weightedCapacity;
    }

    /**
     * <p>
     * The priority for the launch template override. If <b>AllocationStrategy</b> is set to <code>prioritized</code>,
     * EC2 Fleet uses priority to determine which launch template override to use first in fulfilling On-Demand
     * capacity. The highest priority is launched first. Valid values are whole numbers starting at <code>0</code>. The
     * lower the number, the higher the priority. If no number is set, the launch template override has the lowest
     * priority.
     * </p>
     * 
     * @return The priority for the launch template override. If <b>AllocationStrategy</b> is set to
     *         <code>prioritized</code>, EC2 Fleet uses priority to determine which launch template override to use
     *         first in fulfilling On-Demand capacity. The highest priority is launched first. Valid values are whole
     *         numbers starting at <code>0</code>. The lower the number, the higher the priority. If no number is set,
     *         the launch template override has the lowest priority.
     */
    public Double priority() {
        return priority;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxPrice());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(weightedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetLaunchTemplateOverridesRequest)) {
            return false;
        }
        FleetLaunchTemplateOverridesRequest other = (FleetLaunchTemplateOverridesRequest) obj;
        return Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(maxPrice(), other.maxPrice()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(weightedCapacity(), other.weightedCapacity()) && Objects.equals(priority(), other.priority());
    }

    @Override
    public String toString() {
        return ToString.builder("FleetLaunchTemplateOverridesRequest").add("InstanceType", instanceTypeAsString())
                .add("MaxPrice", maxPrice()).add("SubnetId", subnetId()).add("AvailabilityZone", availabilityZone())
                .add("WeightedCapacity", weightedCapacity()).add("Priority", priority()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "MaxPrice":
            return Optional.ofNullable(clazz.cast(maxPrice()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "WeightedCapacity":
            return Optional.ofNullable(clazz.cast(weightedCapacity()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetLaunchTemplateOverridesRequest, T> g) {
        return obj -> g.apply((FleetLaunchTemplateOverridesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetLaunchTemplateOverridesRequest> {
        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The maximum price per unit hour that you are willing to pay for a Spot Instance.
         * </p>
         * 
         * @param maxPrice
         *        The maximum price per unit hour that you are willing to pay for a Spot Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPrice(String maxPrice);

        /**
         * <p>
         * The ID of the subnet in which to launch the instances.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet in which to launch the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The Availability Zone in which to launch the instances.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which to launch the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The number of units provided by the specified instance type.
         * </p>
         * 
         * @param weightedCapacity
         *        The number of units provided by the specified instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weightedCapacity(Double weightedCapacity);

        /**
         * <p>
         * The priority for the launch template override. If <b>AllocationStrategy</b> is set to
         * <code>prioritized</code>, EC2 Fleet uses priority to determine which launch template override to use first in
         * fulfilling On-Demand capacity. The highest priority is launched first. Valid values are whole numbers
         * starting at <code>0</code>. The lower the number, the higher the priority. If no number is set, the launch
         * template override has the lowest priority.
         * </p>
         * 
         * @param priority
         *        The priority for the launch template override. If <b>AllocationStrategy</b> is set to
         *        <code>prioritized</code>, EC2 Fleet uses priority to determine which launch template override to use
         *        first in fulfilling On-Demand capacity. The highest priority is launched first. Valid values are whole
         *        numbers starting at <code>0</code>. The lower the number, the higher the priority. If no number is
         *        set, the launch template override has the lowest priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Double priority);
    }

    static final class BuilderImpl implements Builder {
        private String instanceType;

        private String maxPrice;

        private String subnetId;

        private String availabilityZone;

        private Double weightedCapacity;

        private Double priority;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetLaunchTemplateOverridesRequest model) {
            instanceType(model.instanceType);
            maxPrice(model.maxPrice);
            subnetId(model.subnetId);
            availabilityZone(model.availabilityZone);
            weightedCapacity(model.weightedCapacity);
            priority(model.priority);
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getMaxPrice() {
            return maxPrice;
        }

        @Override
        public final Builder maxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
            return this;
        }

        public final void setMaxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Double getWeightedCapacity() {
            return weightedCapacity;
        }

        @Override
        public final Builder weightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public final void setWeightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        public final Double getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Double priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Double priority) {
            this.priority = priority;
        }

        @Override
        public FleetLaunchTemplateOverridesRequest build() {
            return new FleetLaunchTemplateOverridesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
