/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Amazon FPGA image (AFI).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FpgaImage implements SdkPojo, Serializable, ToCopyableBuilder<FpgaImage.Builder, FpgaImage> {
    private static final SdkField<String> FPGA_IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FpgaImage::fpgaImageId))
            .setter(setter(Builder::fpgaImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FpgaImageId")
                    .unmarshallLocationName("fpgaImageId").build()).build();

    private static final SdkField<String> FPGA_IMAGE_GLOBAL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FpgaImage::fpgaImageGlobalId))
            .setter(setter(Builder::fpgaImageGlobalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FpgaImageGlobalId")
                    .unmarshallLocationName("fpgaImageGlobalId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FpgaImage::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FpgaImage::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<String> SHELL_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FpgaImage::shellVersion))
            .setter(setter(Builder::shellVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShellVersion")
                    .unmarshallLocationName("shellVersion").build()).build();

    private static final SdkField<PciId> PCI_ID_FIELD = SdkField
            .<PciId> builder(MarshallingType.SDK_POJO)
            .getter(getter(FpgaImage::pciId))
            .setter(setter(Builder::pciId))
            .constructor(PciId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PciId")
                    .unmarshallLocationName("pciId").build()).build();

    private static final SdkField<FpgaImageState> STATE_FIELD = SdkField
            .<FpgaImageState> builder(MarshallingType.SDK_POJO)
            .getter(getter(FpgaImage::state))
            .setter(setter(Builder::state))
            .constructor(FpgaImageState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(FpgaImage::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime")
                    .unmarshallLocationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(FpgaImage::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime")
                    .unmarshallLocationName("updateTime").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FpgaImage::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> OWNER_ALIAS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FpgaImage::ownerAlias))
            .setter(setter(Builder::ownerAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAlias")
                    .unmarshallLocationName("ownerAlias").build()).build();

    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField
            .<List<ProductCode>> builder(MarshallingType.LIST)
            .getter(getter(FpgaImage::productCodes))
            .setter(setter(Builder::productCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes")
                    .unmarshallLocationName("productCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ProductCode> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductCode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(FpgaImage::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags")
                    .unmarshallLocationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> IS_PUBLIC_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(FpgaImage::isPublic))
            .setter(setter(Builder::isPublic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Public")
                    .unmarshallLocationName("public").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FPGA_IMAGE_ID_FIELD,
            FPGA_IMAGE_GLOBAL_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, SHELL_VERSION_FIELD, PCI_ID_FIELD, STATE_FIELD,
            CREATE_TIME_FIELD, UPDATE_TIME_FIELD, OWNER_ID_FIELD, OWNER_ALIAS_FIELD, PRODUCT_CODES_FIELD, TAGS_FIELD,
            IS_PUBLIC_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fpgaImageId;

    private final String fpgaImageGlobalId;

    private final String name;

    private final String description;

    private final String shellVersion;

    private final PciId pciId;

    private final FpgaImageState state;

    private final Instant createTime;

    private final Instant updateTime;

    private final String ownerId;

    private final String ownerAlias;

    private final List<ProductCode> productCodes;

    private final List<Tag> tags;

    private final Boolean isPublic;

    private FpgaImage(BuilderImpl builder) {
        this.fpgaImageId = builder.fpgaImageId;
        this.fpgaImageGlobalId = builder.fpgaImageGlobalId;
        this.name = builder.name;
        this.description = builder.description;
        this.shellVersion = builder.shellVersion;
        this.pciId = builder.pciId;
        this.state = builder.state;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.ownerId = builder.ownerId;
        this.ownerAlias = builder.ownerAlias;
        this.productCodes = builder.productCodes;
        this.tags = builder.tags;
        this.isPublic = builder.isPublic;
    }

    /**
     * <p>
     * The FPGA image identifier (AFI ID).
     * </p>
     * 
     * @return The FPGA image identifier (AFI ID).
     */
    public String fpgaImageId() {
        return fpgaImageId;
    }

    /**
     * <p>
     * The global FPGA image identifier (AGFI ID).
     * </p>
     * 
     * @return The global FPGA image identifier (AGFI ID).
     */
    public String fpgaImageGlobalId() {
        return fpgaImageGlobalId;
    }

    /**
     * <p>
     * The name of the AFI.
     * </p>
     * 
     * @return The name of the AFI.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the AFI.
     * </p>
     * 
     * @return The description of the AFI.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The version of the AWS Shell that was used to create the bitstream.
     * </p>
     * 
     * @return The version of the AWS Shell that was used to create the bitstream.
     */
    public String shellVersion() {
        return shellVersion;
    }

    /**
     * <p>
     * Information about the PCI bus.
     * </p>
     * 
     * @return Information about the PCI bus.
     */
    public PciId pciId() {
        return pciId;
    }

    /**
     * <p>
     * Information about the state of the AFI.
     * </p>
     * 
     * @return Information about the state of the AFI.
     */
    public FpgaImageState state() {
        return state;
    }

    /**
     * <p>
     * The date and time the AFI was created.
     * </p>
     * 
     * @return The date and time the AFI was created.
     */
    public Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The time of the most recent update to the AFI.
     * </p>
     * 
     * @return The time of the most recent update to the AFI.
     */
    public Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The AWS account ID of the AFI owner.
     * </p>
     * 
     * @return The AWS account ID of the AFI owner.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The alias of the AFI owner. Possible values include <code>self</code>, <code>amazon</code>, and
     * <code>aws-marketplace</code>.
     * </p>
     * 
     * @return The alias of the AFI owner. Possible values include <code>self</code>, <code>amazon</code>, and
     *         <code>aws-marketplace</code>.
     */
    public String ownerAlias() {
        return ownerAlias;
    }

    /**
     * <p>
     * The product codes for the AFI.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The product codes for the AFI.
     */
    public List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * Any tags assigned to the AFI.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the AFI.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Indicates whether the AFI is public.
     * </p>
     * 
     * @return Indicates whether the AFI is public.
     */
    public Boolean isPublic() {
        return isPublic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(fpgaImageGlobalId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(shellVersion());
        hashCode = 31 * hashCode + Objects.hashCode(pciId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAlias());
        hashCode = 31 * hashCode + Objects.hashCode(productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(isPublic());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FpgaImage)) {
            return false;
        }
        FpgaImage other = (FpgaImage) obj;
        return Objects.equals(fpgaImageId(), other.fpgaImageId())
                && Objects.equals(fpgaImageGlobalId(), other.fpgaImageGlobalId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(shellVersion(), other.shellVersion())
                && Objects.equals(pciId(), other.pciId()) && Objects.equals(state(), other.state())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(ownerAlias(), other.ownerAlias())
                && Objects.equals(productCodes(), other.productCodes()) && Objects.equals(tags(), other.tags())
                && Objects.equals(isPublic(), other.isPublic());
    }

    @Override
    public String toString() {
        return ToString.builder("FpgaImage").add("FpgaImageId", fpgaImageId()).add("FpgaImageGlobalId", fpgaImageGlobalId())
                .add("Name", name()).add("Description", description()).add("ShellVersion", shellVersion()).add("PciId", pciId())
                .add("State", state()).add("CreateTime", createTime()).add("UpdateTime", updateTime()).add("OwnerId", ownerId())
                .add("OwnerAlias", ownerAlias()).add("ProductCodes", productCodes()).add("Tags", tags())
                .add("IsPublic", isPublic()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FpgaImageId":
            return Optional.ofNullable(clazz.cast(fpgaImageId()));
        case "FpgaImageGlobalId":
            return Optional.ofNullable(clazz.cast(fpgaImageGlobalId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ShellVersion":
            return Optional.ofNullable(clazz.cast(shellVersion()));
        case "PciId":
            return Optional.ofNullable(clazz.cast(pciId()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "UpdateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "OwnerAlias":
            return Optional.ofNullable(clazz.cast(ownerAlias()));
        case "ProductCodes":
            return Optional.ofNullable(clazz.cast(productCodes()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "isPublic":
            return Optional.ofNullable(clazz.cast(isPublic()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FpgaImage, T> g) {
        return obj -> g.apply((FpgaImage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FpgaImage> {
        /**
         * <p>
         * The FPGA image identifier (AFI ID).
         * </p>
         * 
         * @param fpgaImageId
         *        The FPGA image identifier (AFI ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageId(String fpgaImageId);

        /**
         * <p>
         * The global FPGA image identifier (AGFI ID).
         * </p>
         * 
         * @param fpgaImageGlobalId
         *        The global FPGA image identifier (AGFI ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageGlobalId(String fpgaImageGlobalId);

        /**
         * <p>
         * The name of the AFI.
         * </p>
         * 
         * @param name
         *        The name of the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the AFI.
         * </p>
         * 
         * @param description
         *        The description of the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The version of the AWS Shell that was used to create the bitstream.
         * </p>
         * 
         * @param shellVersion
         *        The version of the AWS Shell that was used to create the bitstream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shellVersion(String shellVersion);

        /**
         * <p>
         * Information about the PCI bus.
         * </p>
         * 
         * @param pciId
         *        Information about the PCI bus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pciId(PciId pciId);

        /**
         * <p>
         * Information about the PCI bus.
         * </p>
         * This is a convenience that creates an instance of the {@link PciId.Builder} avoiding the need to create one
         * manually via {@link PciId#builder()}.
         *
         * When the {@link Consumer} completes, {@link PciId.Builder#build()} is called immediately and its result is
         * passed to {@link #pciId(PciId)}.
         * 
         * @param pciId
         *        a consumer that will call methods on {@link PciId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pciId(PciId)
         */
        default Builder pciId(Consumer<PciId.Builder> pciId) {
            return pciId(PciId.builder().applyMutation(pciId).build());
        }

        /**
         * <p>
         * Information about the state of the AFI.
         * </p>
         * 
         * @param state
         *        Information about the state of the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(FpgaImageState state);

        /**
         * <p>
         * Information about the state of the AFI.
         * </p>
         * This is a convenience that creates an instance of the {@link FpgaImageState.Builder} avoiding the need to
         * create one manually via {@link FpgaImageState#builder()}.
         *
         * When the {@link Consumer} completes, {@link FpgaImageState.Builder#build()} is called immediately and its
         * result is passed to {@link #state(FpgaImageState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link FpgaImageState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(FpgaImageState)
         */
        default Builder state(Consumer<FpgaImageState.Builder> state) {
            return state(FpgaImageState.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * The date and time the AFI was created.
         * </p>
         * 
         * @param createTime
         *        The date and time the AFI was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The time of the most recent update to the AFI.
         * </p>
         * 
         * @param updateTime
         *        The time of the most recent update to the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The AWS account ID of the AFI owner.
         * </p>
         * 
         * @param ownerId
         *        The AWS account ID of the AFI owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The alias of the AFI owner. Possible values include <code>self</code>, <code>amazon</code>, and
         * <code>aws-marketplace</code>.
         * </p>
         * 
         * @param ownerAlias
         *        The alias of the AFI owner. Possible values include <code>self</code>, <code>amazon</code>, and
         *        <code>aws-marketplace</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAlias(String ownerAlias);

        /**
         * <p>
         * The product codes for the AFI.
         * </p>
         * 
         * @param productCodes
         *        The product codes for the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * The product codes for the AFI.
         * </p>
         * 
         * @param productCodes
         *        The product codes for the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * The product codes for the AFI.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProductCode>.Builder} avoiding the need to
         * create one manually via {@link List<ProductCode>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProductCode>.Builder#build()} is called immediately and its
         * result is passed to {@link #productCodes(List<ProductCode>)}.
         * 
         * @param productCodes
         *        a consumer that will call methods on {@link List<ProductCode>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productCodes(List<ProductCode>)
         */
        Builder productCodes(Consumer<ProductCode.Builder>... productCodes);

        /**
         * <p>
         * Any tags assigned to the AFI.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the AFI.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the AFI.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Indicates whether the AFI is public.
         * </p>
         * 
         * @param isPublic
         *        Indicates whether the AFI is public.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPublic(Boolean isPublic);
    }

    static final class BuilderImpl implements Builder {
        private String fpgaImageId;

        private String fpgaImageGlobalId;

        private String name;

        private String description;

        private String shellVersion;

        private PciId pciId;

        private FpgaImageState state;

        private Instant createTime;

        private Instant updateTime;

        private String ownerId;

        private String ownerAlias;

        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean isPublic;

        private BuilderImpl() {
        }

        private BuilderImpl(FpgaImage model) {
            fpgaImageId(model.fpgaImageId);
            fpgaImageGlobalId(model.fpgaImageGlobalId);
            name(model.name);
            description(model.description);
            shellVersion(model.shellVersion);
            pciId(model.pciId);
            state(model.state);
            createTime(model.createTime);
            updateTime(model.updateTime);
            ownerId(model.ownerId);
            ownerAlias(model.ownerAlias);
            productCodes(model.productCodes);
            tags(model.tags);
            isPublic(model.isPublic);
        }

        public final String getFpgaImageId() {
            return fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        public final String getFpgaImageGlobalId() {
            return fpgaImageGlobalId;
        }

        @Override
        public final Builder fpgaImageGlobalId(String fpgaImageGlobalId) {
            this.fpgaImageGlobalId = fpgaImageGlobalId;
            return this;
        }

        public final void setFpgaImageGlobalId(String fpgaImageGlobalId) {
            this.fpgaImageGlobalId = fpgaImageGlobalId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getShellVersion() {
            return shellVersion;
        }

        @Override
        public final Builder shellVersion(String shellVersion) {
            this.shellVersion = shellVersion;
            return this;
        }

        public final void setShellVersion(String shellVersion) {
            this.shellVersion = shellVersion;
        }

        public final PciId.Builder getPciId() {
            return pciId != null ? pciId.toBuilder() : null;
        }

        @Override
        public final Builder pciId(PciId pciId) {
            this.pciId = pciId;
            return this;
        }

        public final void setPciId(PciId.BuilderImpl pciId) {
            this.pciId = pciId != null ? pciId.build() : null;
        }

        public final FpgaImageState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        @Override
        public final Builder state(FpgaImageState state) {
            this.state = state;
            return this;
        }

        public final void setState(FpgaImageState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getOwnerAlias() {
            return ownerAlias;
        }

        @Override
        public final Builder ownerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
            return this;
        }

        public final void setOwnerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return productCodes != null ? productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder>... productCodes) {
            productCodes(Stream.of(productCodes).map(c -> ProductCode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Boolean getIsPublic() {
            return isPublic;
        }

        @Override
        public final Builder isPublic(Boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public final void setIsPublic(Boolean isPublic) {
            this.isPublic = isPublic;
        }

        @Override
        public FpgaImage build() {
            return new FpgaImage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
