/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the Dedicated Host Reservation offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HostOffering implements SdkPojo, Serializable, ToCopyableBuilder<HostOffering.Builder, HostOffering> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(HostOffering::currencyCodeAsString))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode")
                    .unmarshallLocationName("currencyCode").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HostOffering::duration))
            .setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration")
                    .unmarshallLocationName("duration").build()).build();

    private static final SdkField<String> HOURLY_PRICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(HostOffering::hourlyPrice))
            .setter(setter(Builder::hourlyPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourlyPrice")
                    .unmarshallLocationName("hourlyPrice").build()).build();

    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(HostOffering::instanceFamily))
            .setter(setter(Builder::instanceFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily")
                    .unmarshallLocationName("instanceFamily").build()).build();

    private static final SdkField<String> OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(HostOffering::offeringId))
            .setter(setter(Builder::offeringId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingId")
                    .unmarshallLocationName("offeringId").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(HostOffering::paymentOptionAsString))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption")
                    .unmarshallLocationName("paymentOption").build()).build();

    private static final SdkField<String> UPFRONT_PRICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(HostOffering::upfrontPrice))
            .setter(setter(Builder::upfrontPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontPrice")
                    .unmarshallLocationName("upfrontPrice").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD,
            DURATION_FIELD, HOURLY_PRICE_FIELD, INSTANCE_FAMILY_FIELD, OFFERING_ID_FIELD, PAYMENT_OPTION_FIELD,
            UPFRONT_PRICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String currencyCode;

    private final Integer duration;

    private final String hourlyPrice;

    private final String instanceFamily;

    private final String offeringId;

    private final String paymentOption;

    private final String upfrontPrice;

    private HostOffering(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceFamily = builder.instanceFamily;
        this.offeringId = builder.offeringId;
        this.paymentOption = builder.paymentOption;
        this.upfrontPrice = builder.upfrontPrice;
    }

    /**
     * <p>
     * The currency of the offering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency of the offering.
     * @see CurrencyCodeValues
     */
    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(currencyCode);
    }

    /**
     * <p>
     * The currency of the offering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency of the offering.
     * @see CurrencyCodeValues
     */
    public String currencyCodeAsString() {
        return currencyCode;
    }

    /**
     * <p>
     * The duration of the offering (in seconds).
     * </p>
     * 
     * @return The duration of the offering (in seconds).
     */
    public Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The hourly price of the offering.
     * </p>
     * 
     * @return The hourly price of the offering.
     */
    public String hourlyPrice() {
        return hourlyPrice;
    }

    /**
     * <p>
     * The instance family of the offering.
     * </p>
     * 
     * @return The instance family of the offering.
     */
    public String instanceFamily() {
        return instanceFamily;
    }

    /**
     * <p>
     * The ID of the offering.
     * </p>
     * 
     * @return The ID of the offering.
     */
    public String offeringId() {
        return offeringId;
    }

    /**
     * <p>
     * The available payment option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The available payment option.
     * @see PaymentOption
     */
    public PaymentOption paymentOption() {
        return PaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * The available payment option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The available payment option.
     * @see PaymentOption
     */
    public String paymentOptionAsString() {
        return paymentOption;
    }

    /**
     * <p>
     * The upfront price of the offering. Does not apply to No Upfront offerings.
     * </p>
     * 
     * @return The upfront price of the offering. Does not apply to No Upfront offerings.
     */
    public String upfrontPrice() {
        return upfrontPrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(hourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(instanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontPrice());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostOffering)) {
            return false;
        }
        HostOffering other = (HostOffering) obj;
        return Objects.equals(currencyCodeAsString(), other.currencyCodeAsString())
                && Objects.equals(duration(), other.duration()) && Objects.equals(hourlyPrice(), other.hourlyPrice())
                && Objects.equals(instanceFamily(), other.instanceFamily()) && Objects.equals(offeringId(), other.offeringId())
                && Objects.equals(paymentOptionAsString(), other.paymentOptionAsString())
                && Objects.equals(upfrontPrice(), other.upfrontPrice());
    }

    @Override
    public String toString() {
        return ToString.builder("HostOffering").add("CurrencyCode", currencyCodeAsString()).add("Duration", duration())
                .add("HourlyPrice", hourlyPrice()).add("InstanceFamily", instanceFamily()).add("OfferingId", offeringId())
                .add("PaymentOption", paymentOptionAsString()).add("UpfrontPrice", upfrontPrice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCodeAsString()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "HourlyPrice":
            return Optional.ofNullable(clazz.cast(hourlyPrice()));
        case "InstanceFamily":
            return Optional.ofNullable(clazz.cast(instanceFamily()));
        case "OfferingId":
            return Optional.ofNullable(clazz.cast(offeringId()));
        case "PaymentOption":
            return Optional.ofNullable(clazz.cast(paymentOptionAsString()));
        case "UpfrontPrice":
            return Optional.ofNullable(clazz.cast(upfrontPrice()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HostOffering, T> g) {
        return obj -> g.apply((HostOffering) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HostOffering> {
        /**
         * <p>
         * The currency of the offering.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the offering.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency of the offering.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the offering.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * The duration of the offering (in seconds).
         * </p>
         * 
         * @param duration
         *        The duration of the offering (in seconds).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The hourly price of the offering.
         * </p>
         * 
         * @param hourlyPrice
         *        The hourly price of the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyPrice(String hourlyPrice);

        /**
         * <p>
         * The instance family of the offering.
         * </p>
         * 
         * @param instanceFamily
         *        The instance family of the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFamily(String instanceFamily);

        /**
         * <p>
         * The ID of the offering.
         * </p>
         * 
         * @param offeringId
         *        The ID of the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        /**
         * <p>
         * The available payment option.
         * </p>
         * 
         * @param paymentOption
         *        The available payment option.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The available payment option.
         * </p>
         * 
         * @param paymentOption
         *        The available payment option.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(PaymentOption paymentOption);

        /**
         * <p>
         * The upfront price of the offering. Does not apply to No Upfront offerings.
         * </p>
         * 
         * @param upfrontPrice
         *        The upfront price of the offering. Does not apply to No Upfront offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontPrice(String upfrontPrice);
    }

    static final class BuilderImpl implements Builder {
        private String currencyCode;

        private Integer duration;

        private String hourlyPrice;

        private String instanceFamily;

        private String offeringId;

        private String paymentOption;

        private String upfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(HostOffering model) {
            currencyCode(model.currencyCode);
            duration(model.duration);
            hourlyPrice(model.hourlyPrice);
            instanceFamily(model.instanceFamily);
            offeringId(model.offeringId);
            paymentOption(model.paymentOption);
            upfrontPrice(model.upfrontPrice);
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final String getHourlyPrice() {
            return hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        public final String getInstanceFamily() {
            return instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final String getUpfrontPrice() {
            return upfrontPrice;
        }

        @Override
        public final Builder upfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
            return this;
        }

        public final void setUpfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
        }

        @Override
        public HostOffering build() {
            return new HostOffering(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
