/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ImportSnapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportSnapshotRequest extends Ec2Request implements
        ToCopyableBuilder<ImportSnapshotRequest.Builder, ImportSnapshotRequest> {
    private static final SdkField<ClientData> CLIENT_DATA_FIELD = SdkField
            .<ClientData> builder(MarshallingType.SDK_POJO)
            .getter(getter(ImportSnapshotRequest::clientData))
            .setter(setter(Builder::clientData))
            .constructor(ClientData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientData")
                    .unmarshallLocationName("ClientData").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ImportSnapshotRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ImportSnapshotRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<SnapshotDiskContainer> DISK_CONTAINER_FIELD = SdkField
            .<SnapshotDiskContainer> builder(MarshallingType.SDK_POJO)
            .getter(getter(ImportSnapshotRequest::diskContainer))
            .setter(setter(Builder::diskContainer))
            .constructor(SnapshotDiskContainer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskContainer")
                    .unmarshallLocationName("DiskContainer").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ImportSnapshotRequest::roleName))
            .setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName")
                    .unmarshallLocationName("RoleName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_DATA_FIELD,
            CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, DISK_CONTAINER_FIELD, ROLE_NAME_FIELD));

    private final ClientData clientData;

    private final String clientToken;

    private final String description;

    private final SnapshotDiskContainer diskContainer;

    private final String roleName;

    private ImportSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.clientData = builder.clientData;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.diskContainer = builder.diskContainer;
        this.roleName = builder.roleName;
    }

    /**
     * <p>
     * The client-specific data.
     * </p>
     * 
     * @return The client-specific data.
     */
    public ClientData clientData() {
        return clientData;
    }

    /**
     * <p>
     * Token to enable idempotency for VM import requests.
     * </p>
     * 
     * @return Token to enable idempotency for VM import requests.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The description string for the import snapshot task.
     * </p>
     * 
     * @return The description string for the import snapshot task.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Information about the disk container.
     * </p>
     * 
     * @return Information about the disk container.
     */
    public SnapshotDiskContainer diskContainer() {
        return diskContainer;
    }

    /**
     * <p>
     * The name of the role to use when not using the default role, 'vmimport'.
     * </p>
     * 
     * @return The name of the role to use when not using the default role, 'vmimport'.
     */
    public String roleName() {
        return roleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientData());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(diskContainer());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSnapshotRequest)) {
            return false;
        }
        ImportSnapshotRequest other = (ImportSnapshotRequest) obj;
        return Objects.equals(clientData(), other.clientData()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(description(), other.description()) && Objects.equals(diskContainer(), other.diskContainer())
                && Objects.equals(roleName(), other.roleName());
    }

    @Override
    public String toString() {
        return ToString.builder("ImportSnapshotRequest").add("ClientData", clientData()).add("ClientToken", clientToken())
                .add("Description", description()).add("DiskContainer", diskContainer()).add("RoleName", roleName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientData":
            return Optional.ofNullable(clazz.cast(clientData()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DiskContainer":
            return Optional.ofNullable(clazz.cast(diskContainer()));
        case "RoleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportSnapshotRequest, T> g) {
        return obj -> g.apply((ImportSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ImportSnapshotRequest> {
        /**
         * <p>
         * The client-specific data.
         * </p>
         * 
         * @param clientData
         *        The client-specific data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientData(ClientData clientData);

        /**
         * <p>
         * The client-specific data.
         * </p>
         * This is a convenience that creates an instance of the {@link ClientData.Builder} avoiding the need to create
         * one manually via {@link ClientData#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClientData.Builder#build()} is called immediately and its result
         * is passed to {@link #clientData(ClientData)}.
         * 
         * @param clientData
         *        a consumer that will call methods on {@link ClientData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientData(ClientData)
         */
        default Builder clientData(Consumer<ClientData.Builder> clientData) {
            return clientData(ClientData.builder().applyMutation(clientData).build());
        }

        /**
         * <p>
         * Token to enable idempotency for VM import requests.
         * </p>
         * 
         * @param clientToken
         *        Token to enable idempotency for VM import requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The description string for the import snapshot task.
         * </p>
         * 
         * @param description
         *        The description string for the import snapshot task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the disk container.
         * </p>
         * 
         * @param diskContainer
         *        Information about the disk container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskContainer(SnapshotDiskContainer diskContainer);

        /**
         * <p>
         * Information about the disk container.
         * </p>
         * This is a convenience that creates an instance of the {@link SnapshotDiskContainer.Builder} avoiding the need
         * to create one manually via {@link SnapshotDiskContainer#builder()}.
         *
         * When the {@link Consumer} completes, {@link SnapshotDiskContainer.Builder#build()} is called immediately and
         * its result is passed to {@link #diskContainer(SnapshotDiskContainer)}.
         * 
         * @param diskContainer
         *        a consumer that will call methods on {@link SnapshotDiskContainer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #diskContainer(SnapshotDiskContainer)
         */
        default Builder diskContainer(Consumer<SnapshotDiskContainer.Builder> diskContainer) {
            return diskContainer(SnapshotDiskContainer.builder().applyMutation(diskContainer).build());
        }

        /**
         * <p>
         * The name of the role to use when not using the default role, 'vmimport'.
         * </p>
         * 
         * @param roleName
         *        The name of the role to use when not using the default role, 'vmimport'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private ClientData clientData;

        private String clientToken;

        private String description;

        private SnapshotDiskContainer diskContainer;

        private String roleName;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSnapshotRequest model) {
            super(model);
            clientData(model.clientData);
            clientToken(model.clientToken);
            description(model.description);
            diskContainer(model.diskContainer);
            roleName(model.roleName);
        }

        public final ClientData.Builder getClientData() {
            return clientData != null ? clientData.toBuilder() : null;
        }

        @Override
        public final Builder clientData(ClientData clientData) {
            this.clientData = clientData;
            return this;
        }

        public final void setClientData(ClientData.BuilderImpl clientData) {
            this.clientData = clientData != null ? clientData.build() : null;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final SnapshotDiskContainer.Builder getDiskContainer() {
            return diskContainer != null ? diskContainer.toBuilder() : null;
        }

        @Override
        public final Builder diskContainer(SnapshotDiskContainer diskContainer) {
            this.diskContainer = diskContainer;
            return this;
        }

        public final void setDiskContainer(SnapshotDiskContainer.BuilderImpl diskContainer) {
            this.diskContainer = diskContainer != null ? diskContainer.build() : null;
        }

        public final String getRoleName() {
            return roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportSnapshotRequest build() {
            return new ImportSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
