/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the IP addresses and network interface associated with a NAT gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NatGatewayAddress implements SdkPojo, Serializable,
        ToCopyableBuilder<NatGatewayAddress.Builder, NatGatewayAddress> {
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(NatGatewayAddress::allocationId))
            .setter(setter(Builder::allocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId")
                    .unmarshallLocationName("allocationId").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(NatGatewayAddress::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<String> PRIVATE_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(NatGatewayAddress::privateIp))
            .setter(setter(Builder::privateIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIp")
                    .unmarshallLocationName("privateIp").build()).build();

    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(NatGatewayAddress::publicIp))
            .setter(setter(Builder::publicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp")
                    .unmarshallLocationName("publicIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_ID_FIELD,
            NETWORK_INTERFACE_ID_FIELD, PRIVATE_IP_FIELD, PUBLIC_IP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String allocationId;

    private final String networkInterfaceId;

    private final String privateIp;

    private final String publicIp;

    private NatGatewayAddress(BuilderImpl builder) {
        this.allocationId = builder.allocationId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIp = builder.privateIp;
        this.publicIp = builder.publicIp;
    }

    /**
     * <p>
     * The allocation ID of the Elastic IP address that's associated with the NAT gateway.
     * </p>
     * 
     * @return The allocation ID of the Elastic IP address that's associated with the NAT gateway.
     */
    public String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * The ID of the network interface associated with the NAT gateway.
     * </p>
     * 
     * @return The ID of the network interface associated with the NAT gateway.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The private IP address associated with the Elastic IP address.
     * </p>
     * 
     * @return The private IP address associated with the Elastic IP address.
     */
    public String privateIp() {
        return privateIp;
    }

    /**
     * <p>
     * The Elastic IP address associated with the NAT gateway.
     * </p>
     * 
     * @return The Elastic IP address associated with the NAT gateway.
     */
    public String publicIp() {
        return publicIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(privateIp());
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NatGatewayAddress)) {
            return false;
        }
        NatGatewayAddress other = (NatGatewayAddress) obj;
        return Objects.equals(allocationId(), other.allocationId())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(privateIp(), other.privateIp()) && Objects.equals(publicIp(), other.publicIp());
    }

    @Override
    public String toString() {
        return ToString.builder("NatGatewayAddress").add("AllocationId", allocationId())
                .add("NetworkInterfaceId", networkInterfaceId()).add("PrivateIp", privateIp()).add("PublicIp", publicIp())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocationId":
            return Optional.ofNullable(clazz.cast(allocationId()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "PrivateIp":
            return Optional.ofNullable(clazz.cast(privateIp()));
        case "PublicIp":
            return Optional.ofNullable(clazz.cast(publicIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NatGatewayAddress, T> g) {
        return obj -> g.apply((NatGatewayAddress) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NatGatewayAddress> {
        /**
         * <p>
         * The allocation ID of the Elastic IP address that's associated with the NAT gateway.
         * </p>
         * 
         * @param allocationId
         *        The allocation ID of the Elastic IP address that's associated with the NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * The ID of the network interface associated with the NAT gateway.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface associated with the NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The private IP address associated with the Elastic IP address.
         * </p>
         * 
         * @param privateIp
         *        The private IP address associated with the Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIp(String privateIp);

        /**
         * <p>
         * The Elastic IP address associated with the NAT gateway.
         * </p>
         * 
         * @param publicIp
         *        The Elastic IP address associated with the NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);
    }

    static final class BuilderImpl implements Builder {
        private String allocationId;

        private String networkInterfaceId;

        private String privateIp;

        private String publicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(NatGatewayAddress model) {
            allocationId(model.allocationId);
            networkInterfaceId(model.networkInterfaceId);
            privateIp(model.privateIp);
            publicIp(model.publicIp);
        }

        public final String getAllocationId() {
            return allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getPrivateIp() {
            return privateIp;
        }

        @Override
        public final Builder privateIp(String privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public final void setPrivateIp(String privateIp) {
            this.privateIp = privateIp;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public NatGatewayAddress build() {
            return new NatGatewayAddress(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
