/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The allocation strategy of On-Demand Instances in an EC2 Fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OnDemandOptions implements SdkPojo, Serializable, ToCopyableBuilder<OnDemandOptions.Builder, OnDemandOptions> {
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(OnDemandOptions::allocationStrategyAsString))
            .setter(setter(Builder::allocationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationStrategy")
                    .unmarshallLocationName("allocationStrategy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_STRATEGY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String allocationStrategy;

    private OnDemandOptions(BuilderImpl builder) {
        this.allocationStrategy = builder.allocationStrategy;
    }

    /**
     * <p>
     * The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
     * <code>lowest-price</code>, EC2 Fleet uses price to determine the order, launching the lowest price first. If you
     * specify <code>prioritized</code>, EC2 Fleet uses the priority that you assigned to each launch template override,
     * launching the highest priority first. If you do not specify a value, EC2 Fleet defaults to
     * <code>lowest-price</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link FleetOnDemandAllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #allocationStrategyAsString}.
     * </p>
     * 
     * @return The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
     *         <code>lowest-price</code>, EC2 Fleet uses price to determine the order, launching the lowest price first.
     *         If you specify <code>prioritized</code>, EC2 Fleet uses the priority that you assigned to each launch
     *         template override, launching the highest priority first. If you do not specify a value, EC2 Fleet
     *         defaults to <code>lowest-price</code>.
     * @see FleetOnDemandAllocationStrategy
     */
    public FleetOnDemandAllocationStrategy allocationStrategy() {
        return FleetOnDemandAllocationStrategy.fromValue(allocationStrategy);
    }

    /**
     * <p>
     * The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
     * <code>lowest-price</code>, EC2 Fleet uses price to determine the order, launching the lowest price first. If you
     * specify <code>prioritized</code>, EC2 Fleet uses the priority that you assigned to each launch template override,
     * launching the highest priority first. If you do not specify a value, EC2 Fleet defaults to
     * <code>lowest-price</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link FleetOnDemandAllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #allocationStrategyAsString}.
     * </p>
     * 
     * @return The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
     *         <code>lowest-price</code>, EC2 Fleet uses price to determine the order, launching the lowest price first.
     *         If you specify <code>prioritized</code>, EC2 Fleet uses the priority that you assigned to each launch
     *         template override, launching the highest priority first. If you do not specify a value, EC2 Fleet
     *         defaults to <code>lowest-price</code>.
     * @see FleetOnDemandAllocationStrategy
     */
    public String allocationStrategyAsString() {
        return allocationStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allocationStrategyAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnDemandOptions)) {
            return false;
        }
        OnDemandOptions other = (OnDemandOptions) obj;
        return Objects.equals(allocationStrategyAsString(), other.allocationStrategyAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("OnDemandOptions").add("AllocationStrategy", allocationStrategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocationStrategy":
            return Optional.ofNullable(clazz.cast(allocationStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OnDemandOptions, T> g) {
        return obj -> g.apply((OnDemandOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OnDemandOptions> {
        /**
         * <p>
         * The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
         * <code>lowest-price</code>, EC2 Fleet uses price to determine the order, launching the lowest price first. If
         * you specify <code>prioritized</code>, EC2 Fleet uses the priority that you assigned to each launch template
         * override, launching the highest priority first. If you do not specify a value, EC2 Fleet defaults to
         * <code>lowest-price</code>.
         * </p>
         * 
         * @param allocationStrategy
         *        The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
         *        <code>lowest-price</code>, EC2 Fleet uses price to determine the order, launching the lowest price
         *        first. If you specify <code>prioritized</code>, EC2 Fleet uses the priority that you assigned to each
         *        launch template override, launching the highest priority first. If you do not specify a value, EC2
         *        Fleet defaults to <code>lowest-price</code>.
         * @see FleetOnDemandAllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetOnDemandAllocationStrategy
         */
        Builder allocationStrategy(String allocationStrategy);

        /**
         * <p>
         * The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
         * <code>lowest-price</code>, EC2 Fleet uses price to determine the order, launching the lowest price first. If
         * you specify <code>prioritized</code>, EC2 Fleet uses the priority that you assigned to each launch template
         * override, launching the highest priority first. If you do not specify a value, EC2 Fleet defaults to
         * <code>lowest-price</code>.
         * </p>
         * 
         * @param allocationStrategy
         *        The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
         *        <code>lowest-price</code>, EC2 Fleet uses price to determine the order, launching the lowest price
         *        first. If you specify <code>prioritized</code>, EC2 Fleet uses the priority that you assigned to each
         *        launch template override, launching the highest priority first. If you do not specify a value, EC2
         *        Fleet defaults to <code>lowest-price</code>.
         * @see FleetOnDemandAllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetOnDemandAllocationStrategy
         */
        Builder allocationStrategy(FleetOnDemandAllocationStrategy allocationStrategy);
    }

    static final class BuilderImpl implements Builder {
        private String allocationStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(OnDemandOptions model) {
            allocationStrategy(model.allocationStrategy);
        }

        public final String getAllocationStrategy() {
            return allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(FleetOnDemandAllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy.toString());
            return this;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        @Override
        public OnDemandOptions build() {
            return new OnDemandOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
