/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for RequestSpotFleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestSpotFleetRequest extends Ec2Request implements
        ToCopyableBuilder<RequestSpotFleetRequest.Builder, RequestSpotFleetRequest> {
    private static final SdkField<SpotFleetRequestConfigData> SPOT_FLEET_REQUEST_CONFIG_FIELD = SdkField
            .<SpotFleetRequestConfigData> builder(MarshallingType.SDK_POJO)
            .getter(getter(RequestSpotFleetRequest::spotFleetRequestConfig))
            .setter(setter(Builder::spotFleetRequestConfig))
            .constructor(SpotFleetRequestConfigData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestConfig")
                    .unmarshallLocationName("spotFleetRequestConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SPOT_FLEET_REQUEST_CONFIG_FIELD));

    private final SpotFleetRequestConfigData spotFleetRequestConfig;

    private RequestSpotFleetRequest(BuilderImpl builder) {
        super(builder);
        this.spotFleetRequestConfig = builder.spotFleetRequestConfig;
    }

    /**
     * <p>
     * The configuration for the Spot Fleet request.
     * </p>
     * 
     * @return The configuration for the Spot Fleet request.
     */
    public SpotFleetRequestConfigData spotFleetRequestConfig() {
        return spotFleetRequestConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(spotFleetRequestConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestSpotFleetRequest)) {
            return false;
        }
        RequestSpotFleetRequest other = (RequestSpotFleetRequest) obj;
        return Objects.equals(spotFleetRequestConfig(), other.spotFleetRequestConfig());
    }

    @Override
    public String toString() {
        return ToString.builder("RequestSpotFleetRequest").add("SpotFleetRequestConfig", spotFleetRequestConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpotFleetRequestConfig":
            return Optional.ofNullable(clazz.cast(spotFleetRequestConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestSpotFleetRequest, T> g) {
        return obj -> g.apply((RequestSpotFleetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, RequestSpotFleetRequest> {
        /**
         * <p>
         * The configuration for the Spot Fleet request.
         * </p>
         * 
         * @param spotFleetRequestConfig
         *        The configuration for the Spot Fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig);

        /**
         * <p>
         * The configuration for the Spot Fleet request.
         * </p>
         * This is a convenience that creates an instance of the {@link SpotFleetRequestConfigData.Builder} avoiding the
         * need to create one manually via {@link SpotFleetRequestConfigData#builder()}.
         *
         * When the {@link Consumer} completes, {@link SpotFleetRequestConfigData.Builder#build()} is called immediately
         * and its result is passed to {@link #spotFleetRequestConfig(SpotFleetRequestConfigData)}.
         * 
         * @param spotFleetRequestConfig
         *        a consumer that will call methods on {@link SpotFleetRequestConfigData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotFleetRequestConfig(SpotFleetRequestConfigData)
         */
        default Builder spotFleetRequestConfig(Consumer<SpotFleetRequestConfigData.Builder> spotFleetRequestConfig) {
            return spotFleetRequestConfig(SpotFleetRequestConfigData.builder().applyMutation(spotFleetRequestConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private SpotFleetRequestConfigData spotFleetRequestConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestSpotFleetRequest model) {
            super(model);
            spotFleetRequestConfig(model.spotFleetRequestConfig);
        }

        public final SpotFleetRequestConfigData.Builder getSpotFleetRequestConfig() {
            return spotFleetRequestConfig != null ? spotFleetRequestConfig.toBuilder() : null;
        }

        @Override
        public final Builder spotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig;
            return this;
        }

        public final void setSpotFleetRequestConfig(SpotFleetRequestConfigData.BuilderImpl spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig != null ? spotFleetRequestConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RequestSpotFleetRequest build() {
            return new RequestSpotFleetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
