/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of StopInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopInstancesResponse extends Ec2Response implements
        ToCopyableBuilder<StopInstancesResponse.Builder, StopInstancesResponse> {
    private static final SdkField<List<InstanceStateChange>> STOPPING_INSTANCES_FIELD = SdkField
            .<List<InstanceStateChange>> builder(MarshallingType.LIST)
            .getter(getter(StopInstancesResponse::stoppingInstances))
            .setter(setter(Builder::stoppingInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesSet")
                    .unmarshallLocationName("instancesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceStateChange> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceStateChange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STOPPING_INSTANCES_FIELD));

    private final List<InstanceStateChange> stoppingInstances;

    private StopInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.stoppingInstances = builder.stoppingInstances;
    }

    /**
     * <p>
     * Information about one or more stopped instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more stopped instances.
     */
    public List<InstanceStateChange> stoppingInstances() {
        return stoppingInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stoppingInstances());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopInstancesResponse)) {
            return false;
        }
        StopInstancesResponse other = (StopInstancesResponse) obj;
        return Objects.equals(stoppingInstances(), other.stoppingInstances());
    }

    @Override
    public String toString() {
        return ToString.builder("StopInstancesResponse").add("StoppingInstances", stoppingInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StoppingInstances":
            return Optional.ofNullable(clazz.cast(stoppingInstances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopInstancesResponse, T> g) {
        return obj -> g.apply((StopInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, StopInstancesResponse> {
        /**
         * <p>
         * Information about one or more stopped instances.
         * </p>
         * 
         * @param stoppingInstances
         *        Information about one or more stopped instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingInstances(Collection<InstanceStateChange> stoppingInstances);

        /**
         * <p>
         * Information about one or more stopped instances.
         * </p>
         * 
         * @param stoppingInstances
         *        Information about one or more stopped instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingInstances(InstanceStateChange... stoppingInstances);

        /**
         * <p>
         * Information about one or more stopped instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceStateChange>.Builder} avoiding the
         * need to create one manually via {@link List<InstanceStateChange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceStateChange>.Builder#build()} is called immediately
         * and its result is passed to {@link #stoppingInstances(List<InstanceStateChange>)}.
         * 
         * @param stoppingInstances
         *        a consumer that will call methods on {@link List<InstanceStateChange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingInstances(List<InstanceStateChange>)
         */
        Builder stoppingInstances(Consumer<InstanceStateChange.Builder>... stoppingInstances);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<InstanceStateChange> stoppingInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StopInstancesResponse model) {
            super(model);
            stoppingInstances(model.stoppingInstances);
        }

        public final Collection<InstanceStateChange.Builder> getStoppingInstances() {
            return stoppingInstances != null ? stoppingInstances.stream().map(InstanceStateChange::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stoppingInstances(Collection<InstanceStateChange> stoppingInstances) {
            this.stoppingInstances = InstanceStateChangeListCopier.copy(stoppingInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stoppingInstances(InstanceStateChange... stoppingInstances) {
            stoppingInstances(Arrays.asList(stoppingInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stoppingInstances(Consumer<InstanceStateChange.Builder>... stoppingInstances) {
            stoppingInstances(Stream.of(stoppingInstances).map(c -> InstanceStateChange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStoppingInstances(Collection<InstanceStateChange.BuilderImpl> stoppingInstances) {
            this.stoppingInstances = InstanceStateChangeListCopier.copyFromBuilder(stoppingInstances);
        }

        @Override
        public StopInstancesResponse build() {
            return new StopInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
