/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.PlacementStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePlacementGroupRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreatePlacementGroupRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreatePlacementGroupRequest.getter(CreatePlacementGroupRequest::groupName)).setter(CreatePlacementGroupRequest.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").unmarshallLocationName("groupName").build()}).build();
    private static final SdkField<String> STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreatePlacementGroupRequest.getter(CreatePlacementGroupRequest::strategyAsString)).setter(CreatePlacementGroupRequest.setter(Builder::strategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Strategy").unmarshallLocationName("strategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, STRATEGY_FIELD));
    private final String groupName;
    private final String strategy;

    private CreatePlacementGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.strategy = builder.strategy;
    }

    public String groupName() {
        return this.groupName;
    }

    public PlacementStrategy strategy() {
        return PlacementStrategy.fromValue(this.strategy);
    }

    public String strategyAsString() {
        return this.strategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlacementGroupRequest)) {
            return false;
        }
        CreatePlacementGroupRequest other = (CreatePlacementGroupRequest)((Object)obj);
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.strategyAsString(), other.strategyAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreatePlacementGroupRequest").add("GroupName", (Object)this.groupName()).add("Strategy", (Object)this.strategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "Strategy": {
                return Optional.ofNullable(clazz.cast(this.strategyAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePlacementGroupRequest, T> g) {
        return obj -> g.apply((CreatePlacementGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String groupName;
        private String strategy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlacementGroupRequest model) {
            super(model);
            this.groupName(model.groupName);
            this.strategy(model.strategy);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getStrategy() {
            return this.strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(PlacementStrategy strategy) {
            this.strategy(strategy.toString());
            return this;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePlacementGroupRequest build() {
            return new CreatePlacementGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePlacementGroupRequest> {
        public Builder groupName(String var1);

        public Builder strategy(String var1);

        public Builder strategy(PlacementStrategy var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

