/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.Reservation;
import software.amazon.awssdk.services.ec2.model.ReservationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstancesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeInstancesResponse> {
    private static final SdkField<List<Reservation>> RESERVATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeInstancesResponse.getter(DescribeInstancesResponse::reservations)).setter(DescribeInstancesResponse.setter(Builder::reservations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationSet").unmarshallLocationName("reservationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Reservation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeInstancesResponse.getter(DescribeInstancesResponse::nextToken)).setter(DescribeInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Reservation> reservations;
    private final String nextToken;

    private DescribeInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.reservations = builder.reservations;
        this.nextToken = builder.nextToken;
    }

    public List<Reservation> reservations() {
        return this.reservations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesResponse)) {
            return false;
        }
        DescribeInstancesResponse other = (DescribeInstancesResponse)((Object)obj);
        return Objects.equals(this.reservations(), other.reservations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInstancesResponse").add("Reservations", this.reservations()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Reservations": {
                return Optional.ofNullable(clazz.cast(this.reservations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstancesResponse, T> g) {
        return obj -> g.apply((DescribeInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<Reservation> reservations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancesResponse model) {
            super(model);
            this.reservations(model.reservations);
            this.nextToken(model.nextToken);
        }

        public final Collection<Reservation.Builder> getReservations() {
            return this.reservations != null ? (Collection)this.reservations.stream().map(Reservation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservations(Collection<Reservation> reservations) {
            this.reservations = ReservationListCopier.copy(reservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservations(Reservation ... reservations) {
            this.reservations(Arrays.asList(reservations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservations(Consumer<Reservation.Builder> ... reservations) {
            this.reservations(Stream.of(reservations).map(c -> (Reservation)((Reservation.Builder)Reservation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservations(Collection<Reservation.BuilderImpl> reservations) {
            this.reservations = ReservationListCopier.copyFromBuilder(reservations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstancesResponse build() {
            return new DescribeInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInstancesResponse> {
        public Builder reservations(Collection<Reservation> var1);

        public Builder reservations(Reservation ... var1);

        public Builder reservations(Consumer<Reservation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

