/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a running instance in a Spot fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ActiveInstance implements ToCopyableBuilder<ActiveInstance.Builder, ActiveInstance> {
    private final String instanceId;

    private final String instanceType;

    private final String spotInstanceRequestId;

    private final String instanceHealth;

    private ActiveInstance(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.spotInstanceRequestId = builder.spotInstanceRequestId;
        this.instanceHealth = builder.instanceHealth;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * 
     * @return The instance type.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the Spot instance request.
     * </p>
     * 
     * @return The ID of the Spot instance request.
     */
    public String spotInstanceRequestId() {
        return spotInstanceRequestId;
    }

    /**
     * <p>
     * The health status of the instance. If the status of either the instance status check or the system status check
     * is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>. Otherwise, the health
     * status is <code>healthy</code>.
     * </p>
     * 
     * @return The health status of the instance. If the status of either the instance status check or the system status
     *         check is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>. Otherwise,
     *         the health status is <code>healthy</code>.
     * @see InstanceHealthStatus
     */
    public String instanceHealth() {
        return instanceHealth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((spotInstanceRequestId() == null) ? 0 : spotInstanceRequestId().hashCode());
        hashCode = 31 * hashCode + ((instanceHealth() == null) ? 0 : instanceHealth().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveInstance)) {
            return false;
        }
        ActiveInstance other = (ActiveInstance) obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.spotInstanceRequestId() == null ^ this.spotInstanceRequestId() == null) {
            return false;
        }
        if (other.spotInstanceRequestId() != null && !other.spotInstanceRequestId().equals(this.spotInstanceRequestId())) {
            return false;
        }
        if (other.instanceHealth() == null ^ this.instanceHealth() == null) {
            return false;
        }
        if (other.instanceHealth() != null && !other.instanceHealth().equals(this.instanceHealth())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (spotInstanceRequestId() != null) {
            sb.append("SpotInstanceRequestId: ").append(spotInstanceRequestId()).append(",");
        }
        if (instanceHealth() != null) {
            sb.append("InstanceHealth: ").append(instanceHealth()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ActiveInstance> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The ID of the Spot instance request.
         * </p>
         * 
         * @param spotInstanceRequestId
         *        The ID of the Spot instance request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequestId(String spotInstanceRequestId);

        /**
         * <p>
         * The health status of the instance. If the status of either the instance status check or the system status
         * check is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>. Otherwise, the
         * health status is <code>healthy</code>.
         * </p>
         * 
         * @param instanceHealth
         *        The health status of the instance. If the status of either the instance status check or the system
         *        status check is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>.
         *        Otherwise, the health status is <code>healthy</code>.
         * @see InstanceHealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceHealthStatus
         */
        Builder instanceHealth(String instanceHealth);

        /**
         * <p>
         * The health status of the instance. If the status of either the instance status check or the system status
         * check is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>. Otherwise, the
         * health status is <code>healthy</code>.
         * </p>
         * 
         * @param instanceHealth
         *        The health status of the instance. If the status of either the instance status check or the system
         *        status check is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>.
         *        Otherwise, the health status is <code>healthy</code>.
         * @see InstanceHealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceHealthStatus
         */
        Builder instanceHealth(InstanceHealthStatus instanceHealth);
    }

    private static final class BuilderImpl implements Builder {
        private String instanceId;

        private String instanceType;

        private String spotInstanceRequestId;

        private String instanceHealth;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveInstance model) {
            setInstanceId(model.instanceId);
            setInstanceType(model.instanceType);
            setSpotInstanceRequestId(model.spotInstanceRequestId);
            setInstanceHealth(model.instanceHealth);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getSpotInstanceRequestId() {
            return spotInstanceRequestId;
        }

        @Override
        public final Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public final void setSpotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
        }

        public final String getInstanceHealth() {
            return instanceHealth;
        }

        @Override
        public final Builder instanceHealth(String instanceHealth) {
            this.instanceHealth = instanceHealth;
            return this;
        }

        @Override
        public final Builder instanceHealth(InstanceHealthStatus instanceHealth) {
            this.instanceHealth(instanceHealth.toString());
            return this;
        }

        public final void setInstanceHealth(String instanceHealth) {
            this.instanceHealth = instanceHealth;
        }

        public final void setInstanceHealth(InstanceHealthStatus instanceHealth) {
            this.instanceHealth(instanceHealth.toString());
        }

        @Override
        public ActiveInstance build() {
            return new ActiveInstance(this);
        }
    }
}
