/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of AllocateAddress.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AllocateAddressResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<AllocateAddressResponse.Builder, AllocateAddressResponse> {
    private final String publicIp;

    private final String allocationId;

    private final String domain;

    private AllocateAddressResponse(BuilderImpl builder) {
        this.publicIp = builder.publicIp;
        this.allocationId = builder.allocationId;
        this.domain = builder.domain;
    }

    /**
     * <p>
     * The Elastic IP address.
     * </p>
     * 
     * @return The Elastic IP address.
     */
    public String publicIp() {
        return publicIp;
    }

    /**
     * <p>
     * [EC2-VPC] The ID that AWS assigns to represent the allocation of the Elastic IP address for use with instances in
     * a VPC.
     * </p>
     * 
     * @return [EC2-VPC] The ID that AWS assigns to represent the allocation of the Elastic IP address for use with
     *         instances in a VPC.
     */
    public String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>) or
     * instances in a VPC (<code>vpc</code>).
     * </p>
     * 
     * @return Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>
     *         ) or instances in a VPC (<code>vpc</code>).
     * @see DomainType
     */
    public String domain() {
        return domain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((publicIp() == null) ? 0 : publicIp().hashCode());
        hashCode = 31 * hashCode + ((allocationId() == null) ? 0 : allocationId().hashCode());
        hashCode = 31 * hashCode + ((domain() == null) ? 0 : domain().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateAddressResponse)) {
            return false;
        }
        AllocateAddressResponse other = (AllocateAddressResponse) obj;
        if (other.publicIp() == null ^ this.publicIp() == null) {
            return false;
        }
        if (other.publicIp() != null && !other.publicIp().equals(this.publicIp())) {
            return false;
        }
        if (other.allocationId() == null ^ this.allocationId() == null) {
            return false;
        }
        if (other.allocationId() != null && !other.allocationId().equals(this.allocationId())) {
            return false;
        }
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (publicIp() != null) {
            sb.append("PublicIp: ").append(publicIp()).append(",");
        }
        if (allocationId() != null) {
            sb.append("AllocationId: ").append(allocationId()).append(",");
        }
        if (domain() != null) {
            sb.append("Domain: ").append(domain()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AllocateAddressResponse> {
        /**
         * <p>
         * The Elastic IP address.
         * </p>
         * 
         * @param publicIp
         *        The Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * [EC2-VPC] The ID that AWS assigns to represent the allocation of the Elastic IP address for use with
         * instances in a VPC.
         * </p>
         * 
         * @param allocationId
         *        [EC2-VPC] The ID that AWS assigns to represent the allocation of the Elastic IP address for use with
         *        instances in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>) or
         * instances in a VPC (<code>vpc</code>).
         * </p>
         * 
         * @param domain
         *        Indicates whether this Elastic IP address is for use with instances in EC2-Classic (
         *        <code>standard</code>) or instances in a VPC (<code>vpc</code>).
         * @see DomainType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainType
         */
        Builder domain(String domain);

        /**
         * <p>
         * Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>) or
         * instances in a VPC (<code>vpc</code>).
         * </p>
         * 
         * @param domain
         *        Indicates whether this Elastic IP address is for use with instances in EC2-Classic (
         *        <code>standard</code>) or instances in a VPC (<code>vpc</code>).
         * @see DomainType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainType
         */
        Builder domain(DomainType domain);
    }

    private static final class BuilderImpl implements Builder {
        private String publicIp;

        private String allocationId;

        private String domain;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateAddressResponse model) {
            setPublicIp(model.publicIp);
            setAllocationId(model.allocationId);
            setDomain(model.domain);
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getAllocationId() {
            return allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(DomainType domain) {
            this.domain(domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final void setDomain(DomainType domain) {
            this.domain(domain.toString());
        }

        @Override
        public AllocateAddressResponse build() {
            return new AllocateAddressResponse(this);
        }
    }
}
