/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for AllocateHosts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AllocateHostsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<AllocateHostsRequest.Builder, AllocateHostsRequest> {
    private final String autoPlacement;

    private final String availabilityZone;

    private final String clientToken;

    private final String instanceType;

    private final Integer quantity;

    private AllocateHostsRequest(BuilderImpl builder) {
        this.autoPlacement = builder.autoPlacement;
        this.availabilityZone = builder.availabilityZone;
        this.clientToken = builder.clientToken;
        this.instanceType = builder.instanceType;
        this.quantity = builder.quantity;
    }

    /**
     * <p>
     * This is enabled by default. This property allows instances to be automatically placed onto available Dedicated
     * Hosts, when you are launching instances without specifying a host ID.
     * </p>
     * <p>
     * Default: Enabled
     * </p>
     * 
     * @return This is enabled by default. This property allows instances to be automatically placed onto available
     *         Dedicated Hosts, when you are launching instances without specifying a host ID.</p>
     *         <p>
     *         Default: Enabled
     * @see AutoPlacement
     */
    public String autoPlacement() {
        return autoPlacement;
    }

    /**
     * <p>
     * The Availability Zone for the Dedicated Hosts.
     * </p>
     * 
     * @return The Availability Zone for the Dedicated Hosts.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information,
     *         see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to
     *         Ensure Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Specify the instance type that you want your Dedicated Hosts to be configured for. When you specify the instance
     * type, that is the only instance type that you can launch onto that host.
     * </p>
     * 
     * @return Specify the instance type that you want your Dedicated Hosts to be configured for. When you specify the
     *         instance type, that is the only instance type that you can launch onto that host.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The number of Dedicated Hosts you want to allocate to your account with these parameters.
     * </p>
     * 
     * @return The number of Dedicated Hosts you want to allocate to your account with these parameters.
     */
    public Integer quantity() {
        return quantity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((autoPlacement() == null) ? 0 : autoPlacement().hashCode());
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((clientToken() == null) ? 0 : clientToken().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((quantity() == null) ? 0 : quantity().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateHostsRequest)) {
            return false;
        }
        AllocateHostsRequest other = (AllocateHostsRequest) obj;
        if (other.autoPlacement() == null ^ this.autoPlacement() == null) {
            return false;
        }
        if (other.autoPlacement() != null && !other.autoPlacement().equals(this.autoPlacement())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.quantity() == null ^ this.quantity() == null) {
            return false;
        }
        if (other.quantity() != null && !other.quantity().equals(this.quantity())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (autoPlacement() != null) {
            sb.append("AutoPlacement: ").append(autoPlacement()).append(",");
        }
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (quantity() != null) {
            sb.append("Quantity: ").append(quantity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AllocateHostsRequest> {
        /**
         * <p>
         * This is enabled by default. This property allows instances to be automatically placed onto available
         * Dedicated Hosts, when you are launching instances without specifying a host ID.
         * </p>
         * <p>
         * Default: Enabled
         * </p>
         * 
         * @param autoPlacement
         *        This is enabled by default. This property allows instances to be automatically placed onto available
         *        Dedicated Hosts, when you are launching instances without specifying a host ID.</p>
         *        <p>
         *        Default: Enabled
         * @see AutoPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoPlacement
         */
        Builder autoPlacement(String autoPlacement);

        /**
         * <p>
         * This is enabled by default. This property allows instances to be automatically placed onto available
         * Dedicated Hosts, when you are launching instances without specifying a host ID.
         * </p>
         * <p>
         * Default: Enabled
         * </p>
         * 
         * @param autoPlacement
         *        This is enabled by default. This property allows instances to be automatically placed onto available
         *        Dedicated Hosts, when you are launching instances without specifying a host ID.</p>
         *        <p>
         *        Default: Enabled
         * @see AutoPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoPlacement
         */
        Builder autoPlacement(AutoPlacement autoPlacement);

        /**
         * <p>
         * The Availability Zone for the Dedicated Hosts.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone for the Dedicated Hosts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see
         * <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         *        Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specify the instance type that you want your Dedicated Hosts to be configured for. When you specify the
         * instance type, that is the only instance type that you can launch onto that host.
         * </p>
         * 
         * @param instanceType
         *        Specify the instance type that you want your Dedicated Hosts to be configured for. When you specify
         *        the instance type, that is the only instance type that you can launch onto that host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The number of Dedicated Hosts you want to allocate to your account with these parameters.
         * </p>
         * 
         * @param quantity
         *        The number of Dedicated Hosts you want to allocate to your account with these parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);
    }

    private static final class BuilderImpl implements Builder {
        private String autoPlacement;

        private String availabilityZone;

        private String clientToken;

        private String instanceType;

        private Integer quantity;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateHostsRequest model) {
            setAutoPlacement(model.autoPlacement);
            setAvailabilityZone(model.availabilityZone);
            setClientToken(model.clientToken);
            setInstanceType(model.instanceType);
            setQuantity(model.quantity);
        }

        public final String getAutoPlacement() {
            return autoPlacement;
        }

        @Override
        public final Builder autoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
            return this;
        }

        @Override
        public final Builder autoPlacement(AutoPlacement autoPlacement) {
            this.autoPlacement(autoPlacement.toString());
            return this;
        }

        public final void setAutoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
        }

        public final void setAutoPlacement(AutoPlacement autoPlacement) {
            this.autoPlacement(autoPlacement.toString());
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public AllocateHostsRequest build() {
            return new AllocateHostsRequest(this);
        }
    }
}
