/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CancelConversionTask.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelConversionTaskRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CancelConversionTaskRequest.Builder, CancelConversionTaskRequest> {
    private final String conversionTaskId;

    private final String reasonMessage;

    private CancelConversionTaskRequest(BuilderImpl builder) {
        this.conversionTaskId = builder.conversionTaskId;
        this.reasonMessage = builder.reasonMessage;
    }

    /**
     * <p>
     * The ID of the conversion task.
     * </p>
     * 
     * @return The ID of the conversion task.
     */
    public String conversionTaskId() {
        return conversionTaskId;
    }

    /**
     * <p>
     * The reason for canceling the conversion task.
     * </p>
     * 
     * @return The reason for canceling the conversion task.
     */
    public String reasonMessage() {
        return reasonMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((conversionTaskId() == null) ? 0 : conversionTaskId().hashCode());
        hashCode = 31 * hashCode + ((reasonMessage() == null) ? 0 : reasonMessage().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelConversionTaskRequest)) {
            return false;
        }
        CancelConversionTaskRequest other = (CancelConversionTaskRequest) obj;
        if (other.conversionTaskId() == null ^ this.conversionTaskId() == null) {
            return false;
        }
        if (other.conversionTaskId() != null && !other.conversionTaskId().equals(this.conversionTaskId())) {
            return false;
        }
        if (other.reasonMessage() == null ^ this.reasonMessage() == null) {
            return false;
        }
        if (other.reasonMessage() != null && !other.reasonMessage().equals(this.reasonMessage())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (conversionTaskId() != null) {
            sb.append("ConversionTaskId: ").append(conversionTaskId()).append(",");
        }
        if (reasonMessage() != null) {
            sb.append("ReasonMessage: ").append(reasonMessage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CancelConversionTaskRequest> {
        /**
         * <p>
         * The ID of the conversion task.
         * </p>
         * 
         * @param conversionTaskId
         *        The ID of the conversion task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversionTaskId(String conversionTaskId);

        /**
         * <p>
         * The reason for canceling the conversion task.
         * </p>
         * 
         * @param reasonMessage
         *        The reason for canceling the conversion task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonMessage(String reasonMessage);
    }

    private static final class BuilderImpl implements Builder {
        private String conversionTaskId;

        private String reasonMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelConversionTaskRequest model) {
            setConversionTaskId(model.conversionTaskId);
            setReasonMessage(model.reasonMessage);
        }

        public final String getConversionTaskId() {
            return conversionTaskId;
        }

        @Override
        public final Builder conversionTaskId(String conversionTaskId) {
            this.conversionTaskId = conversionTaskId;
            return this;
        }

        public final void setConversionTaskId(String conversionTaskId) {
            this.conversionTaskId = conversionTaskId;
        }

        public final String getReasonMessage() {
            return reasonMessage;
        }

        @Override
        public final Builder reasonMessage(String reasonMessage) {
            this.reasonMessage = reasonMessage;
            return this;
        }

        public final void setReasonMessage(String reasonMessage) {
            this.reasonMessage = reasonMessage;
        }

        @Override
        public CancelConversionTaskRequest build() {
            return new CancelConversionTaskRequest(this);
        }
    }
}
