/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateDhcpOptions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDhcpOptionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateDhcpOptionsResponse.Builder, CreateDhcpOptionsResponse> {
    private final DhcpOptions dhcpOptions;

    private CreateDhcpOptionsResponse(BuilderImpl builder) {
        this.dhcpOptions = builder.dhcpOptions;
    }

    /**
     * <p>
     * A set of DHCP options.
     * </p>
     * 
     * @return A set of DHCP options.
     */
    public DhcpOptions dhcpOptions() {
        return dhcpOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((dhcpOptions() == null) ? 0 : dhcpOptions().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDhcpOptionsResponse)) {
            return false;
        }
        CreateDhcpOptionsResponse other = (CreateDhcpOptionsResponse) obj;
        if (other.dhcpOptions() == null ^ this.dhcpOptions() == null) {
            return false;
        }
        if (other.dhcpOptions() != null && !other.dhcpOptions().equals(this.dhcpOptions())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (dhcpOptions() != null) {
            sb.append("DhcpOptions: ").append(dhcpOptions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateDhcpOptionsResponse> {
        /**
         * <p>
         * A set of DHCP options.
         * </p>
         * 
         * @param dhcpOptions
         *        A set of DHCP options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptions(DhcpOptions dhcpOptions);
    }

    private static final class BuilderImpl implements Builder {
        private DhcpOptions dhcpOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDhcpOptionsResponse model) {
            setDhcpOptions(model.dhcpOptions);
        }

        public final DhcpOptions getDhcpOptions() {
            return dhcpOptions;
        }

        @Override
        public final Builder dhcpOptions(DhcpOptions dhcpOptions) {
            this.dhcpOptions = dhcpOptions;
            return this;
        }

        public final void setDhcpOptions(DhcpOptions dhcpOptions) {
            this.dhcpOptions = dhcpOptions;
        }

        @Override
        public CreateDhcpOptionsResponse build() {
            return new CreateDhcpOptionsResponse(this);
        }
    }
}
