/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateFpgaImageRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateFpgaImageRequest.Builder, CreateFpgaImageRequest> {
    private final StorageLocation inputStorageLocation;

    private final StorageLocation logsStorageLocation;

    private final String description;

    private final String name;

    private final String clientToken;

    private CreateFpgaImageRequest(BuilderImpl builder) {
        this.inputStorageLocation = builder.inputStorageLocation;
        this.logsStorageLocation = builder.logsStorageLocation;
        this.description = builder.description;
        this.name = builder.name;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.
     * </p>
     * 
     * @return The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.
     */
    public StorageLocation inputStorageLocation() {
        return inputStorageLocation;
    }

    /**
     * <p>
     * The location in Amazon S3 for the output logs.
     * </p>
     * 
     * @return The location in Amazon S3 for the output logs.
     */
    public StorageLocation logsStorageLocation() {
        return logsStorageLocation;
    }

    /**
     * <p>
     * A description for the AFI.
     * </p>
     * 
     * @return A description for the AFI.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A name for the AFI.
     * </p>
     * 
     * @return A name for the AFI.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((inputStorageLocation() == null) ? 0 : inputStorageLocation().hashCode());
        hashCode = 31 * hashCode + ((logsStorageLocation() == null) ? 0 : logsStorageLocation().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((clientToken() == null) ? 0 : clientToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFpgaImageRequest)) {
            return false;
        }
        CreateFpgaImageRequest other = (CreateFpgaImageRequest) obj;
        if (other.inputStorageLocation() == null ^ this.inputStorageLocation() == null) {
            return false;
        }
        if (other.inputStorageLocation() != null && !other.inputStorageLocation().equals(this.inputStorageLocation())) {
            return false;
        }
        if (other.logsStorageLocation() == null ^ this.logsStorageLocation() == null) {
            return false;
        }
        if (other.logsStorageLocation() != null && !other.logsStorageLocation().equals(this.logsStorageLocation())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (inputStorageLocation() != null) {
            sb.append("InputStorageLocation: ").append(inputStorageLocation()).append(",");
        }
        if (logsStorageLocation() != null) {
            sb.append("LogsStorageLocation: ").append(logsStorageLocation()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateFpgaImageRequest> {
        /**
         * <p>
         * The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.
         * </p>
         * 
         * @param inputStorageLocation
         *        The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputStorageLocation(StorageLocation inputStorageLocation);

        /**
         * <p>
         * The location in Amazon S3 for the output logs.
         * </p>
         * 
         * @param logsStorageLocation
         *        The location in Amazon S3 for the output logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logsStorageLocation(StorageLocation logsStorageLocation);

        /**
         * <p>
         * A description for the AFI.
         * </p>
         * 
         * @param description
         *        A description for the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A name for the AFI.
         * </p>
         * 
         * @param name
         *        A name for the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    private static final class BuilderImpl implements Builder {
        private StorageLocation inputStorageLocation;

        private StorageLocation logsStorageLocation;

        private String description;

        private String name;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFpgaImageRequest model) {
            setInputStorageLocation(model.inputStorageLocation);
            setLogsStorageLocation(model.logsStorageLocation);
            setDescription(model.description);
            setName(model.name);
            setClientToken(model.clientToken);
        }

        public final StorageLocation getInputStorageLocation() {
            return inputStorageLocation;
        }

        @Override
        public final Builder inputStorageLocation(StorageLocation inputStorageLocation) {
            this.inputStorageLocation = inputStorageLocation;
            return this;
        }

        public final void setInputStorageLocation(StorageLocation inputStorageLocation) {
            this.inputStorageLocation = inputStorageLocation;
        }

        public final StorageLocation getLogsStorageLocation() {
            return logsStorageLocation;
        }

        @Override
        public final Builder logsStorageLocation(StorageLocation logsStorageLocation) {
            this.logsStorageLocation = logsStorageLocation;
            return this;
        }

        public final void setLogsStorageLocation(StorageLocation logsStorageLocation) {
            this.logsStorageLocation = logsStorageLocation;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public CreateFpgaImageRequest build() {
            return new CreateFpgaImageRequest(this);
        }
    }
}
