/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateSecurityGroup.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateSecurityGroupRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateSecurityGroupRequest.Builder, CreateSecurityGroupRequest> {
    private final String description;

    private final String groupName;

    private final String vpcId;

    private CreateSecurityGroupRequest(BuilderImpl builder) {
        this.description = builder.description;
        this.groupName = builder.groupName;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * A description for the security group. This is informational only.
     * </p>
     * <p>
     * Constraints: Up to 255 characters in length
     * </p>
     * <p>
     * Constraints for EC2-Classic: ASCII characters
     * </p>
     * <p>
     * Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*
     * </p>
     * 
     * @return A description for the security group. This is informational only.</p>
     *         <p>
     *         Constraints: Up to 255 characters in length
     *         </p>
     *         <p>
     *         Constraints for EC2-Classic: ASCII characters
     *         </p>
     *         <p>
     *         Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The name of the security group.
     * </p>
     * <p>
     * Constraints: Up to 255 characters in length
     * </p>
     * <p>
     * Constraints for EC2-Classic: ASCII characters
     * </p>
     * <p>
     * Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*
     * </p>
     * 
     * @return The name of the security group.</p>
     *         <p>
     *         Constraints: Up to 255 characters in length
     *         </p>
     *         <p>
     *         Constraints for EC2-Classic: ASCII characters
     *         </p>
     *         <p>
     *         Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * [EC2-VPC] The ID of the VPC. Required for EC2-VPC.
     * </p>
     * 
     * @return [EC2-VPC] The ID of the VPC. Required for EC2-VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((groupName() == null) ? 0 : groupName().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSecurityGroupRequest)) {
            return false;
        }
        CreateSecurityGroupRequest other = (CreateSecurityGroupRequest) obj;
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (groupName() != null) {
            sb.append("GroupName: ").append(groupName()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateSecurityGroupRequest> {
        /**
         * <p>
         * A description for the security group. This is informational only.
         * </p>
         * <p>
         * Constraints: Up to 255 characters in length
         * </p>
         * <p>
         * Constraints for EC2-Classic: ASCII characters
         * </p>
         * <p>
         * Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*
         * </p>
         * 
         * @param description
         *        A description for the security group. This is informational only.</p>
         *        <p>
         *        Constraints: Up to 255 characters in length
         *        </p>
         *        <p>
         *        Constraints for EC2-Classic: ASCII characters
         *        </p>
         *        <p>
         *        Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the security group.
         * </p>
         * <p>
         * Constraints: Up to 255 characters in length
         * </p>
         * <p>
         * Constraints for EC2-Classic: ASCII characters
         * </p>
         * <p>
         * Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*
         * </p>
         * 
         * @param groupName
         *        The name of the security group.</p>
         *        <p>
         *        Constraints: Up to 255 characters in length
         *        </p>
         *        <p>
         *        Constraints for EC2-Classic: ASCII characters
         *        </p>
         *        <p>
         *        Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * [EC2-VPC] The ID of the VPC. Required for EC2-VPC.
         * </p>
         * 
         * @param vpcId
         *        [EC2-VPC] The ID of the VPC. Required for EC2-VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    private static final class BuilderImpl implements Builder {
        private String description;

        private String groupName;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSecurityGroupRequest model) {
            setDescription(model.description);
            setGroupName(model.groupName);
            setVpcId(model.vpcId);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public CreateSecurityGroupRequest build() {
            return new CreateSecurityGroupRequest(this);
        }
    }
}
