/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A simple result wrapper around the Volume object that was sent over the wire.
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVolumeResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateVolumeResponse.Builder, CreateVolumeResponse> {
    private final Volume volume;

    private CreateVolumeResponse(BuilderImpl builder) {
        this.volume = builder.volume;
    }

    /**
     * <p>
     * Describes a volume.
     * </p>
     * 
     * @return Describes a volume.
     */
    public Volume volume() {
        return volume;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((volume() == null) ? 0 : volume().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVolumeResponse)) {
            return false;
        }
        CreateVolumeResponse other = (CreateVolumeResponse) obj;
        if (other.volume() == null ^ this.volume() == null) {
            return false;
        }
        if (other.volume() != null && !other.volume().equals(this.volume())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (volume() != null) {
            sb.append("Volume: ").append(volume()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateVolumeResponse> {
        /**
         * <p>
         * Describes a volume.
         * </p>
         * 
         * @param volume
         *        Describes a volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volume(Volume volume);
    }

    private static final class BuilderImpl implements Builder {
        private Volume volume;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVolumeResponse model) {
            setVolume(model.volume);
        }

        public final Volume getVolume() {
            return volume;
        }

        @Override
        public final Builder volume(Volume volume) {
            this.volume = volume;
            return this;
        }

        public final void setVolume(Volume volume) {
            this.volume = volume;
        }

        @Override
        public CreateVolumeResponse build() {
            return new CreateVolumeResponse(this);
        }
    }
}
