/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateVpc.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVpcRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateVpcRequest.Builder, CreateVpcRequest> {
    private final String cidrBlock;

    private final Boolean amazonProvidedIpv6CidrBlock;

    private final String instanceTenancy;

    private CreateVpcRequest(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
        this.amazonProvidedIpv6CidrBlock = builder.amazonProvidedIpv6CidrBlock;
        this.instanceTenancy = builder.instanceTenancy;
    }

    /**
     * <p>
     * The IPv4 network range for the VPC, in CIDR notation. For example, <code>10.0.0.0/16</code>.
     * </p>
     * 
     * @return The IPv4 network range for the VPC, in CIDR notation. For example, <code>10.0.0.0/16</code>.
     */
    public String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of
     * IP addresses, or the size of the CIDR block.
     * </p>
     * 
     * @return Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the
     *         range of IP addresses, or the size of the CIDR block.
     */
    public Boolean amazonProvidedIpv6CidrBlock() {
        return amazonProvidedIpv6CidrBlock;
    }

    /**
     * <p>
     * The tenancy options for instances launched into the VPC. For <code>default</code>, instances are launched with
     * shared tenancy by default. You can launch instances with any tenancy into a shared tenancy VPC. For
     * <code>dedicated</code>, instances are launched as dedicated tenancy instances by default. You can only launch
     * instances with a tenancy of <code>dedicated</code> or <code>host</code> into a dedicated tenancy VPC.
     * </p>
     * <p>
     * <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the <code>default</code> or
     * <code>dedicated</code> values only.
     * </p>
     * <p>
     * Default: <code>default</code>
     * </p>
     * 
     * @return The tenancy options for instances launched into the VPC. For <code>default</code>, instances are launched
     *         with shared tenancy by default. You can launch instances with any tenancy into a shared tenancy VPC. For
     *         <code>dedicated</code>, instances are launched as dedicated tenancy instances by default. You can only
     *         launch instances with a tenancy of <code>dedicated</code> or <code>host</code> into a dedicated tenancy
     *         VPC. </p>
     *         <p>
     *         <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
     *         <code>default</code> or <code>dedicated</code> values only.
     *         </p>
     *         <p>
     *         Default: <code>default</code>
     * @see Tenancy
     */
    public String instanceTenancy() {
        return instanceTenancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((cidrBlock() == null) ? 0 : cidrBlock().hashCode());
        hashCode = 31 * hashCode + ((amazonProvidedIpv6CidrBlock() == null) ? 0 : amazonProvidedIpv6CidrBlock().hashCode());
        hashCode = 31 * hashCode + ((instanceTenancy() == null) ? 0 : instanceTenancy().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcRequest)) {
            return false;
        }
        CreateVpcRequest other = (CreateVpcRequest) obj;
        if (other.cidrBlock() == null ^ this.cidrBlock() == null) {
            return false;
        }
        if (other.cidrBlock() != null && !other.cidrBlock().equals(this.cidrBlock())) {
            return false;
        }
        if (other.amazonProvidedIpv6CidrBlock() == null ^ this.amazonProvidedIpv6CidrBlock() == null) {
            return false;
        }
        if (other.amazonProvidedIpv6CidrBlock() != null
                && !other.amazonProvidedIpv6CidrBlock().equals(this.amazonProvidedIpv6CidrBlock())) {
            return false;
        }
        if (other.instanceTenancy() == null ^ this.instanceTenancy() == null) {
            return false;
        }
        if (other.instanceTenancy() != null && !other.instanceTenancy().equals(this.instanceTenancy())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (cidrBlock() != null) {
            sb.append("CidrBlock: ").append(cidrBlock()).append(",");
        }
        if (amazonProvidedIpv6CidrBlock() != null) {
            sb.append("AmazonProvidedIpv6CidrBlock: ").append(amazonProvidedIpv6CidrBlock()).append(",");
        }
        if (instanceTenancy() != null) {
            sb.append("InstanceTenancy: ").append(instanceTenancy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateVpcRequest> {
        /**
         * <p>
         * The IPv4 network range for the VPC, in CIDR notation. For example, <code>10.0.0.0/16</code>.
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 network range for the VPC, in CIDR notation. For example, <code>10.0.0.0/16</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the
         * range of IP addresses, or the size of the CIDR block.
         * </p>
         * 
         * @param amazonProvidedIpv6CidrBlock
         *        Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify
         *        the range of IP addresses, or the size of the CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock);

        /**
         * <p>
         * The tenancy options for instances launched into the VPC. For <code>default</code>, instances are launched
         * with shared tenancy by default. You can launch instances with any tenancy into a shared tenancy VPC. For
         * <code>dedicated</code>, instances are launched as dedicated tenancy instances by default. You can only launch
         * instances with a tenancy of <code>dedicated</code> or <code>host</code> into a dedicated tenancy VPC.
         * </p>
         * <p>
         * <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
         * <code>default</code> or <code>dedicated</code> values only.
         * </p>
         * <p>
         * Default: <code>default</code>
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy options for instances launched into the VPC. For <code>default</code>, instances are
         *        launched with shared tenancy by default. You can launch instances with any tenancy into a shared
         *        tenancy VPC. For <code>dedicated</code>, instances are launched as dedicated tenancy instances by
         *        default. You can only launch instances with a tenancy of <code>dedicated</code> or <code>host</code>
         *        into a dedicated tenancy VPC. </p>
         *        <p>
         *        <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
         *        <code>default</code> or <code>dedicated</code> values only.
         *        </p>
         *        <p>
         *        Default: <code>default</code>
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(String instanceTenancy);

        /**
         * <p>
         * The tenancy options for instances launched into the VPC. For <code>default</code>, instances are launched
         * with shared tenancy by default. You can launch instances with any tenancy into a shared tenancy VPC. For
         * <code>dedicated</code>, instances are launched as dedicated tenancy instances by default. You can only launch
         * instances with a tenancy of <code>dedicated</code> or <code>host</code> into a dedicated tenancy VPC.
         * </p>
         * <p>
         * <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
         * <code>default</code> or <code>dedicated</code> values only.
         * </p>
         * <p>
         * Default: <code>default</code>
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy options for instances launched into the VPC. For <code>default</code>, instances are
         *        launched with shared tenancy by default. You can launch instances with any tenancy into a shared
         *        tenancy VPC. For <code>dedicated</code>, instances are launched as dedicated tenancy instances by
         *        default. You can only launch instances with a tenancy of <code>dedicated</code> or <code>host</code>
         *        into a dedicated tenancy VPC. </p>
         *        <p>
         *        <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
         *        <code>default</code> or <code>dedicated</code> values only.
         *        </p>
         *        <p>
         *        Default: <code>default</code>
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(Tenancy instanceTenancy);
    }

    private static final class BuilderImpl implements Builder {
        private String cidrBlock;

        private Boolean amazonProvidedIpv6CidrBlock;

        private String instanceTenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcRequest model) {
            setCidrBlock(model.cidrBlock);
            setAmazonProvidedIpv6CidrBlock(model.amazonProvidedIpv6CidrBlock);
            setInstanceTenancy(model.instanceTenancy);
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Boolean getAmazonProvidedIpv6CidrBlock() {
            return amazonProvidedIpv6CidrBlock;
        }

        @Override
        public final Builder amazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
            return this;
        }

        public final void setAmazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
        }

        public final String getInstanceTenancy() {
            return instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final void setInstanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
        }

        @Override
        public CreateVpcRequest build() {
            return new CreateVpcRequest(this);
        }
    }
}
