/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateVpnConnection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVpnConnectionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateVpnConnectionRequest.Builder, CreateVpnConnectionRequest> {
    private final String customerGatewayId;

    private final String type;

    private final String vpnGatewayId;

    private final VpnConnectionOptionsSpecification options;

    private CreateVpnConnectionRequest(BuilderImpl builder) {
        this.customerGatewayId = builder.customerGatewayId;
        this.type = builder.type;
        this.vpnGatewayId = builder.vpnGatewayId;
        this.options = builder.options;
    }

    /**
     * <p>
     * The ID of the customer gateway.
     * </p>
     * 
     * @return The ID of the customer gateway.
     */
    public String customerGatewayId() {
        return customerGatewayId;
    }

    /**
     * <p>
     * The type of VPN connection (<code>ipsec.1</code>).
     * </p>
     * 
     * @return The type of VPN connection (<code>ipsec.1</code>).
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The ID of the virtual private gateway.
     * </p>
     * 
     * @return The ID of the virtual private gateway.
     */
    public String vpnGatewayId() {
        return vpnGatewayId;
    }

    /**
     * <p>
     * Indicates whether the VPN connection requires static routes. If you are creating a VPN connection for a device
     * that does not support BGP, you must specify <code>true</code>.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Indicates whether the VPN connection requires static routes. If you are creating a VPN connection for a
     *         device that does not support BGP, you must specify <code>true</code>.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public VpnConnectionOptionsSpecification options() {
        return options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((customerGatewayId() == null) ? 0 : customerGatewayId().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((vpnGatewayId() == null) ? 0 : vpnGatewayId().hashCode());
        hashCode = 31 * hashCode + ((options() == null) ? 0 : options().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpnConnectionRequest)) {
            return false;
        }
        CreateVpnConnectionRequest other = (CreateVpnConnectionRequest) obj;
        if (other.customerGatewayId() == null ^ this.customerGatewayId() == null) {
            return false;
        }
        if (other.customerGatewayId() != null && !other.customerGatewayId().equals(this.customerGatewayId())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.vpnGatewayId() == null ^ this.vpnGatewayId() == null) {
            return false;
        }
        if (other.vpnGatewayId() != null && !other.vpnGatewayId().equals(this.vpnGatewayId())) {
            return false;
        }
        if (other.options() == null ^ this.options() == null) {
            return false;
        }
        if (other.options() != null && !other.options().equals(this.options())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (customerGatewayId() != null) {
            sb.append("CustomerGatewayId: ").append(customerGatewayId()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (vpnGatewayId() != null) {
            sb.append("VpnGatewayId: ").append(vpnGatewayId()).append(",");
        }
        if (options() != null) {
            sb.append("Options: ").append(options()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateVpnConnectionRequest> {
        /**
         * <p>
         * The ID of the customer gateway.
         * </p>
         * 
         * @param customerGatewayId
         *        The ID of the customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGatewayId(String customerGatewayId);

        /**
         * <p>
         * The type of VPN connection (<code>ipsec.1</code>).
         * </p>
         * 
         * @param type
         *        The type of VPN connection (<code>ipsec.1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The ID of the virtual private gateway.
         * </p>
         * 
         * @param vpnGatewayId
         *        The ID of the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGatewayId(String vpnGatewayId);

        /**
         * <p>
         * Indicates whether the VPN connection requires static routes. If you are creating a VPN connection for a
         * device that does not support BGP, you must specify <code>true</code>.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param options
         *        Indicates whether the VPN connection requires static routes. If you are creating a VPN connection for
         *        a device that does not support BGP, you must specify <code>true</code>.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(VpnConnectionOptionsSpecification options);
    }

    private static final class BuilderImpl implements Builder {
        private String customerGatewayId;

        private String type;

        private String vpnGatewayId;

        private VpnConnectionOptionsSpecification options;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpnConnectionRequest model) {
            setCustomerGatewayId(model.customerGatewayId);
            setType(model.type);
            setVpnGatewayId(model.vpnGatewayId);
            setOptions(model.options);
        }

        public final String getCustomerGatewayId() {
            return customerGatewayId;
        }

        @Override
        public final Builder customerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        public final void setCustomerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getVpnGatewayId() {
            return vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        public final VpnConnectionOptionsSpecification getOptions() {
            return options;
        }

        @Override
        public final Builder options(VpnConnectionOptionsSpecification options) {
            this.options = options;
            return this;
        }

        public final void setOptions(VpnConnectionOptionsSpecification options) {
            this.options = options;
        }

        @Override
        public CreateVpnConnectionRequest build() {
            return new CreateVpnConnectionRequest(this);
        }
    }
}
