/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateVpnConnectionRoute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVpnConnectionRouteRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateVpnConnectionRouteRequest.Builder, CreateVpnConnectionRouteRequest> {
    private final String destinationCidrBlock;

    private final String vpnConnectionId;

    private CreateVpnConnectionRouteRequest(BuilderImpl builder) {
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.vpnConnectionId = builder.vpnConnectionId;
    }

    /**
     * <p>
     * The CIDR block associated with the local subnet of the customer network.
     * </p>
     * 
     * @return The CIDR block associated with the local subnet of the customer network.
     */
    public String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * The ID of the VPN connection.
     * </p>
     * 
     * @return The ID of the VPN connection.
     */
    public String vpnConnectionId() {
        return vpnConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((destinationCidrBlock() == null) ? 0 : destinationCidrBlock().hashCode());
        hashCode = 31 * hashCode + ((vpnConnectionId() == null) ? 0 : vpnConnectionId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpnConnectionRouteRequest)) {
            return false;
        }
        CreateVpnConnectionRouteRequest other = (CreateVpnConnectionRouteRequest) obj;
        if (other.destinationCidrBlock() == null ^ this.destinationCidrBlock() == null) {
            return false;
        }
        if (other.destinationCidrBlock() != null && !other.destinationCidrBlock().equals(this.destinationCidrBlock())) {
            return false;
        }
        if (other.vpnConnectionId() == null ^ this.vpnConnectionId() == null) {
            return false;
        }
        if (other.vpnConnectionId() != null && !other.vpnConnectionId().equals(this.vpnConnectionId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (destinationCidrBlock() != null) {
            sb.append("DestinationCidrBlock: ").append(destinationCidrBlock()).append(",");
        }
        if (vpnConnectionId() != null) {
            sb.append("VpnConnectionId: ").append(vpnConnectionId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateVpnConnectionRouteRequest> {
        /**
         * <p>
         * The CIDR block associated with the local subnet of the customer network.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The CIDR block associated with the local subnet of the customer network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The ID of the VPN connection.
         * </p>
         * 
         * @param vpnConnectionId
         *        The ID of the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnectionId(String vpnConnectionId);
    }

    private static final class BuilderImpl implements Builder {
        private String destinationCidrBlock;

        private String vpnConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpnConnectionRouteRequest model) {
            setDestinationCidrBlock(model.destinationCidrBlock);
            setVpnConnectionId(model.vpnConnectionId);
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getVpnConnectionId() {
            return vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        @Override
        public CreateVpnConnectionRouteRequest build() {
            return new CreateVpnConnectionRouteRequest(this);
        }
    }
}
