/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteEgressOnlyInternetGatewayRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteEgressOnlyInternetGatewayRequest.Builder, DeleteEgressOnlyInternetGatewayRequest> {
    private final String egressOnlyInternetGatewayId;

    private DeleteEgressOnlyInternetGatewayRequest(BuilderImpl builder) {
        this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
    }

    /**
     * <p>
     * The ID of the egress-only Internet gateway.
     * </p>
     * 
     * @return The ID of the egress-only Internet gateway.
     */
    public String egressOnlyInternetGatewayId() {
        return egressOnlyInternetGatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((egressOnlyInternetGatewayId() == null) ? 0 : egressOnlyInternetGatewayId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEgressOnlyInternetGatewayRequest)) {
            return false;
        }
        DeleteEgressOnlyInternetGatewayRequest other = (DeleteEgressOnlyInternetGatewayRequest) obj;
        if (other.egressOnlyInternetGatewayId() == null ^ this.egressOnlyInternetGatewayId() == null) {
            return false;
        }
        if (other.egressOnlyInternetGatewayId() != null
                && !other.egressOnlyInternetGatewayId().equals(this.egressOnlyInternetGatewayId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (egressOnlyInternetGatewayId() != null) {
            sb.append("EgressOnlyInternetGatewayId: ").append(egressOnlyInternetGatewayId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteEgressOnlyInternetGatewayRequest> {
        /**
         * <p>
         * The ID of the egress-only Internet gateway.
         * </p>
         * 
         * @param egressOnlyInternetGatewayId
         *        The ID of the egress-only Internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId);
    }

    private static final class BuilderImpl implements Builder {
        private String egressOnlyInternetGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEgressOnlyInternetGatewayRequest model) {
            setEgressOnlyInternetGatewayId(model.egressOnlyInternetGatewayId);
        }

        public final String getEgressOnlyInternetGatewayId() {
            return egressOnlyInternetGatewayId;
        }

        @Override
        public final Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        public final void setEgressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
        }

        @Override
        public DeleteEgressOnlyInternetGatewayRequest build() {
            return new DeleteEgressOnlyInternetGatewayRequest(this);
        }
    }
}
