/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeFpgaImagesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeFpgaImagesRequest.Builder, DescribeFpgaImagesRequest> {
    private final List<String> fpgaImageIds;

    private final List<String> owners;

    private final List<Filter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeFpgaImagesRequest(BuilderImpl builder) {
        this.fpgaImageIds = builder.fpgaImageIds;
        this.owners = builder.owners;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * One or more AFI IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more AFI IDs.
     */
    public List<String> fpgaImageIds() {
        return fpgaImageIds;
    }

    /**
     * <p>
     * Filters the AFI by owner. Specify an AWS account ID, <code>self</code> (owner is the sender of the request), or
     * an AWS owner alias (valid values are <code>amazon</code> | <code>aws-marketplace</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Filters the AFI by owner. Specify an AWS account ID, <code>self</code> (owner is the sender of the
     *         request), or an AWS owner alias (valid values are <code>amazon</code> | <code>aws-marketplace</code>).
     */
    public List<String> owners() {
        return owners;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>create-time</code> - The creation time of the AFI.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fpga-image-id</code> - The FPGA image identifier (AFI ID).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fpga-image-global-id</code> - The global FPGA image identifier (AGFI ID).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>name</code> - The name of the AFI.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-id</code> - The AWS account ID of the AFI owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>product-code</code> - The product code.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>shell-version</code> - The version of the AWS Shell that was used to create the bitstream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the AFI (<code>pending</code> | <code>failed</code> | <code>available</code> |
     * <code>unavailable</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource. Specify
     * the key of the tag in the filter name and the value of the tag in the filter value. For example, for the tag
     * Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value is),
     * and the tag value X (regardless of what the tag's key is). If you want to list only resources where Purpose is X,
     * see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     * <code>tag-key</code> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>update-time</code> - The time of the most recent update.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>create-time</code> - The creation time of the AFI.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fpga-image-id</code> - The FPGA image identifier (AFI ID).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fpga-image-global-id</code> - The global FPGA image identifier (AGFI ID).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>name</code> - The name of the AFI.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-id</code> - The AWS account ID of the AFI owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>product-code</code> - The product code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>shell-version</code> - The version of the AWS Shell that was used to create the bitstream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the AFI (<code>pending</code> | <code>failed</code> |
     *         <code>available</code> | <code>unavailable</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
     *         Specify the key of the tag in the filter name and the value of the tag in the filter value. For example,
     *         for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the
     *         filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     *         "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's
     *         value is), and the tag value X (regardless of what the tag's key is). If you want to list only resources
     *         where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-key</code> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>update-time</code> - The time of the most recent update.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @return The token to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call.
     * </p>
     * 
     * @return The maximum number of results to return in a single call.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((fpgaImageIds() == null) ? 0 : fpgaImageIds().hashCode());
        hashCode = 31 * hashCode + ((owners() == null) ? 0 : owners().hashCode());
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFpgaImagesRequest)) {
            return false;
        }
        DescribeFpgaImagesRequest other = (DescribeFpgaImagesRequest) obj;
        if (other.fpgaImageIds() == null ^ this.fpgaImageIds() == null) {
            return false;
        }
        if (other.fpgaImageIds() != null && !other.fpgaImageIds().equals(this.fpgaImageIds())) {
            return false;
        }
        if (other.owners() == null ^ this.owners() == null) {
            return false;
        }
        if (other.owners() != null && !other.owners().equals(this.owners())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (fpgaImageIds() != null) {
            sb.append("FpgaImageIds: ").append(fpgaImageIds()).append(",");
        }
        if (owners() != null) {
            sb.append("Owners: ").append(owners()).append(",");
        }
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeFpgaImagesRequest> {
        /**
         * <p>
         * One or more AFI IDs.
         * </p>
         * 
         * @param fpgaImageIds
         *        One or more AFI IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageIds(Collection<String> fpgaImageIds);

        /**
         * <p>
         * One or more AFI IDs.
         * </p>
         * 
         * @param fpgaImageIds
         *        One or more AFI IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageIds(String... fpgaImageIds);

        /**
         * <p>
         * Filters the AFI by owner. Specify an AWS account ID, <code>self</code> (owner is the sender of the request),
         * or an AWS owner alias (valid values are <code>amazon</code> | <code>aws-marketplace</code>).
         * </p>
         * 
         * @param owners
         *        Filters the AFI by owner. Specify an AWS account ID, <code>self</code> (owner is the sender of the
         *        request), or an AWS owner alias (valid values are <code>amazon</code> | <code>aws-marketplace</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owners(Collection<String> owners);

        /**
         * <p>
         * Filters the AFI by owner. Specify an AWS account ID, <code>self</code> (owner is the sender of the request),
         * or an AWS owner alias (valid values are <code>amazon</code> | <code>aws-marketplace</code>).
         * </p>
         * 
         * @param owners
         *        Filters the AFI by owner. Specify an AWS account ID, <code>self</code> (owner is the sender of the
         *        request), or an AWS owner alias (valid values are <code>amazon</code> | <code>aws-marketplace</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owners(String... owners);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>create-time</code> - The creation time of the AFI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fpga-image-id</code> - The FPGA image identifier (AFI ID).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fpga-image-global-id</code> - The global FPGA image identifier (AGFI ID).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>name</code> - The name of the AFI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the AFI owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code</code> - The product code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>shell-version</code> - The version of the AWS Shell that was used to create the bitstream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the AFI (<code>pending</code> | <code>failed</code> |
         * <code>available</code> | <code>unavailable</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update-time</code> - The time of the most recent update.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>create-time</code> - The creation time of the AFI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fpga-image-id</code> - The FPGA image identifier (AFI ID).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fpga-image-global-id</code> - The global FPGA image identifier (AGFI ID).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>name</code> - The name of the AFI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The AWS account ID of the AFI owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code</code> - The product code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>shell-version</code> - The version of the AWS Shell that was used to create the bitstream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the AFI (<code>pending</code> | <code>failed</code> |
         *        <code>available</code> | <code>unavailable</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update-time</code> - The time of the most recent update.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>create-time</code> - The creation time of the AFI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fpga-image-id</code> - The FPGA image identifier (AFI ID).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fpga-image-global-id</code> - The global FPGA image identifier (AGFI ID).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>name</code> - The name of the AFI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the AFI owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code</code> - The product code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>shell-version</code> - The version of the AWS Shell that was used to create the bitstream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the AFI (<code>pending</code> | <code>failed</code> |
         * <code>available</code> | <code>unavailable</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update-time</code> - The time of the most recent update.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>create-time</code> - The creation time of the AFI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fpga-image-id</code> - The FPGA image identifier (AFI ID).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fpga-image-global-id</code> - The global FPGA image identifier (AGFI ID).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>name</code> - The name of the AFI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The AWS account ID of the AFI owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code</code> - The product code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>shell-version</code> - The version of the AWS Shell that was used to create the bitstream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the AFI (<code>pending</code> | <code>failed</code> |
         *        <code>available</code> | <code>unavailable</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update-time</code> - The time of the most recent update.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in a single call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> fpgaImageIds;

        private List<String> owners;

        private List<Filter> filters;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFpgaImagesRequest model) {
            setFpgaImageIds(model.fpgaImageIds);
            setOwners(model.owners);
            setFilters(model.filters);
            setNextToken(model.nextToken);
            setMaxResults(model.maxResults);
        }

        public final Collection<String> getFpgaImageIds() {
            return fpgaImageIds;
        }

        @Override
        public final Builder fpgaImageIds(Collection<String> fpgaImageIds) {
            this.fpgaImageIds = FpgaImageIdListCopier.copy(fpgaImageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fpgaImageIds(String... fpgaImageIds) {
            fpgaImageIds(Arrays.asList(fpgaImageIds));
            return this;
        }

        public final void setFpgaImageIds(Collection<String> fpgaImageIds) {
            this.fpgaImageIds = FpgaImageIdListCopier.copy(fpgaImageIds);
        }

        @SafeVarargs
        public final void setFpgaImageIds(String... fpgaImageIds) {
            fpgaImageIds(Arrays.asList(fpgaImageIds));
        }

        public final Collection<String> getOwners() {
            return owners;
        }

        @Override
        public final Builder owners(Collection<String> owners) {
            this.owners = OwnerStringListCopier.copy(owners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(String... owners) {
            owners(Arrays.asList(owners));
            return this;
        }

        public final void setOwners(Collection<String> owners) {
            this.owners = OwnerStringListCopier.copy(owners);
        }

        @SafeVarargs
        public final void setOwners(String... owners) {
            owners(Arrays.asList(owners));
        }

        public final Collection<Filter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter... filters) {
            filters(Arrays.asList(filters));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public DescribeFpgaImagesRequest build() {
            return new DescribeFpgaImagesRequest(this);
        }
    }
}
