/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeHostReservationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeHostReservationsResponse.Builder, DescribeHostReservationsResponse> {
    private final List<HostReservation> hostReservationSet;

    private final String nextToken;

    private DescribeHostReservationsResponse(BuilderImpl builder) {
        this.hostReservationSet = builder.hostReservationSet;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Details about the reservation's configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Details about the reservation's configuration.
     */
    public List<HostReservation> hostReservationSet() {
        return hostReservationSet;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((hostReservationSet() == null) ? 0 : hostReservationSet().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostReservationsResponse)) {
            return false;
        }
        DescribeHostReservationsResponse other = (DescribeHostReservationsResponse) obj;
        if (other.hostReservationSet() == null ^ this.hostReservationSet() == null) {
            return false;
        }
        if (other.hostReservationSet() != null && !other.hostReservationSet().equals(this.hostReservationSet())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (hostReservationSet() != null) {
            sb.append("HostReservationSet: ").append(hostReservationSet()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeHostReservationsResponse> {
        /**
         * <p>
         * Details about the reservation's configuration.
         * </p>
         * 
         * @param hostReservationSet
         *        Details about the reservation's configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostReservationSet(Collection<HostReservation> hostReservationSet);

        /**
         * <p>
         * Details about the reservation's configuration.
         * </p>
         * 
         * @param hostReservationSet
         *        Details about the reservation's configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostReservationSet(HostReservation... hostReservationSet);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<HostReservation> hostReservationSet;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostReservationsResponse model) {
            setHostReservationSet(model.hostReservationSet);
            setNextToken(model.nextToken);
        }

        public final Collection<HostReservation> getHostReservationSet() {
            return hostReservationSet;
        }

        @Override
        public final Builder hostReservationSet(Collection<HostReservation> hostReservationSet) {
            this.hostReservationSet = HostReservationSetCopier.copy(hostReservationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostReservationSet(HostReservation... hostReservationSet) {
            hostReservationSet(Arrays.asList(hostReservationSet));
            return this;
        }

        public final void setHostReservationSet(Collection<HostReservation> hostReservationSet) {
            this.hostReservationSet = HostReservationSetCopier.copy(hostReservationSet);
        }

        @SafeVarargs
        public final void setHostReservationSet(HostReservation... hostReservationSet) {
            hostReservationSet(Arrays.asList(hostReservationSet));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeHostReservationsResponse build() {
            return new DescribeHostReservationsResponse(this);
        }
    }
}
