/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeHosts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeHostsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeHostsRequest.Builder, DescribeHostsRequest> {
    private final List<Filter> filter;

    private final List<String> hostIds;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeHostsRequest(BuilderImpl builder) {
        this.filter = builder.filter;
        this.hostIds = builder.hostIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>instance-type</code> - The instance type size that the Dedicated Host is configured to support.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>auto-placement</code> - Whether auto-placement is enabled or disabled (<code>on</code> | <code>off</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>host-reservation-id</code> - The ID of the reservation assigned to this host.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client-token</code> - The idempotency token you provided when you launched the instance
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code>- The allocation state of the Dedicated Host (<code>available</code> |
     * <code>under-assessment</code> | <code>permanent-failure</code> | <code>released</code> |
     * <code>released-permanent-failure</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone of the host.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>instance-type</code> - The instance type size that the Dedicated Host is configured to support.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>auto-placement</code> - Whether auto-placement is enabled or disabled (<code>on</code> |
     *         <code>off</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>host-reservation-id</code> - The ID of the reservation assigned to this host.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>client-token</code> - The idempotency token you provided when you launched the instance
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code>- The allocation state of the Dedicated Host (<code>available</code> |
     *         <code>under-assessment</code> | <code>permanent-failure</code> | <code>released</code> |
     *         <code>released-permanent-failure</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone of the host.
     *         </p>
     *         </li>
     */
    public List<Filter> filter() {
        return filter;
    }

    /**
     * <p>
     * The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.
     */
    public List<String> hostIds() {
        return hostIds;
    }

    /**
     * <p>
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by
     * sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500; if
     * <code>maxResults</code> is given a larger value than 500, you will receive an error. You cannot specify this
     * parameter and the host IDs parameter in the same request.
     * </p>
     * 
     * @return The maximum number of results to return for the request in a single page. The remaining results can be
     *         seen by sending another request with the returned <code>nextToken</code> value. This value can be between
     *         5 and 500; if <code>maxResults</code> is given a larger value than 500, you will receive an error. You
     *         cannot specify this parameter and the host IDs parameter in the same request.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @return The token to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filter() == null) ? 0 : filter().hashCode());
        hashCode = 31 * hashCode + ((hostIds() == null) ? 0 : hostIds().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostsRequest)) {
            return false;
        }
        DescribeHostsRequest other = (DescribeHostsRequest) obj;
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        if (other.filter() != null && !other.filter().equals(this.filter())) {
            return false;
        }
        if (other.hostIds() == null ^ this.hostIds() == null) {
            return false;
        }
        if (other.hostIds() != null && !other.hostIds().equals(this.hostIds())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filter() != null) {
            sb.append("Filter: ").append(filter()).append(",");
        }
        if (hostIds() != null) {
            sb.append("HostIds: ").append(hostIds()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeHostsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type size that the Dedicated Host is configured to support.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>auto-placement</code> - Whether auto-placement is enabled or disabled (<code>on</code> |
         * <code>off</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>host-reservation-id</code> - The ID of the reservation assigned to this host.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client-token</code> - The idempotency token you provided when you launched the instance
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code>- The allocation state of the Dedicated Host (<code>available</code> |
         * <code>under-assessment</code> | <code>permanent-failure</code> | <code>released</code> |
         * <code>released-permanent-failure</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the host.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type size that the Dedicated Host is configured to support.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>auto-placement</code> - Whether auto-placement is enabled or disabled (<code>on</code> |
         *        <code>off</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>host-reservation-id</code> - The ID of the reservation assigned to this host.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>client-token</code> - The idempotency token you provided when you launched the instance
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code>- The allocation state of the Dedicated Host (<code>available</code> |
         *        <code>under-assessment</code> | <code>permanent-failure</code> | <code>released</code> |
         *        <code>released-permanent-failure</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the host.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Collection<Filter> filter);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type size that the Dedicated Host is configured to support.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>auto-placement</code> - Whether auto-placement is enabled or disabled (<code>on</code> |
         * <code>off</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>host-reservation-id</code> - The ID of the reservation assigned to this host.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client-token</code> - The idempotency token you provided when you launched the instance
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code>- The allocation state of the Dedicated Host (<code>available</code> |
         * <code>under-assessment</code> | <code>permanent-failure</code> | <code>released</code> |
         * <code>released-permanent-failure</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the host.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type size that the Dedicated Host is configured to support.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>auto-placement</code> - Whether auto-placement is enabled or disabled (<code>on</code> |
         *        <code>off</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>host-reservation-id</code> - The ID of the reservation assigned to this host.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>client-token</code> - The idempotency token you provided when you launched the instance
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code>- The allocation state of the Dedicated Host (<code>available</code> |
         *        <code>under-assessment</code> | <code>permanent-failure</code> | <code>released</code> |
         *        <code>released-permanent-failure</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the host.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Filter... filter);

        /**
         * <p>
         * The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.
         * </p>
         * 
         * @param hostIds
         *        The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIds(Collection<String> hostIds);

        /**
         * <p>
         * The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.
         * </p>
         * 
         * @param hostIds
         *        The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIds(String... hostIds);

        /**
         * <p>
         * The maximum number of results to return for the request in a single page. The remaining results can be seen
         * by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and
         * 500; if <code>maxResults</code> is given a larger value than 500, you will receive an error. You cannot
         * specify this parameter and the host IDs parameter in the same request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for the request in a single page. The remaining results can be
         *        seen by sending another request with the returned <code>nextToken</code> value. This value can be
         *        between 5 and 500; if <code>maxResults</code> is given a larger value than 500, you will receive an
         *        error. You cannot specify this parameter and the host IDs parameter in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Filter> filter;

        private List<String> hostIds;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostsRequest model) {
            setFilter(model.filter);
            setHostIds(model.hostIds);
            setMaxResults(model.maxResults);
            setNextToken(model.nextToken);
        }

        public final Collection<Filter> getFilter() {
            return filter;
        }

        @Override
        public final Builder filter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Filter... filter) {
            filter(Arrays.asList(filter));
            return this;
        }

        public final void setFilter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
        }

        @SafeVarargs
        public final void setFilter(Filter... filter) {
            filter(Arrays.asList(filter));
        }

        public final Collection<String> getHostIds() {
            return hostIds;
        }

        @Override
        public final Builder hostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIds(String... hostIds) {
            hostIds(Arrays.asList(hostIds));
            return this;
        }

        public final void setHostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
        }

        @SafeVarargs
        public final void setHostIds(String... hostIds) {
            hostIds(Arrays.asList(hostIds));
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeHostsRequest build() {
            return new DescribeHostsRequest(this);
        }
    }
}
