/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeInternetGateways.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeInternetGatewaysResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeInternetGatewaysResponse.Builder, DescribeInternetGatewaysResponse> {
    private final List<InternetGateway> internetGateways;

    private DescribeInternetGatewaysResponse(BuilderImpl builder) {
        this.internetGateways = builder.internetGateways;
    }

    /**
     * <p>
     * Information about one or more Internet gateways.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more Internet gateways.
     */
    public List<InternetGateway> internetGateways() {
        return internetGateways;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((internetGateways() == null) ? 0 : internetGateways().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInternetGatewaysResponse)) {
            return false;
        }
        DescribeInternetGatewaysResponse other = (DescribeInternetGatewaysResponse) obj;
        if (other.internetGateways() == null ^ this.internetGateways() == null) {
            return false;
        }
        if (other.internetGateways() != null && !other.internetGateways().equals(this.internetGateways())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (internetGateways() != null) {
            sb.append("InternetGateways: ").append(internetGateways()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeInternetGatewaysResponse> {
        /**
         * <p>
         * Information about one or more Internet gateways.
         * </p>
         * 
         * @param internetGateways
         *        Information about one or more Internet gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetGateways(Collection<InternetGateway> internetGateways);

        /**
         * <p>
         * Information about one or more Internet gateways.
         * </p>
         * 
         * @param internetGateways
         *        Information about one or more Internet gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetGateways(InternetGateway... internetGateways);
    }

    private static final class BuilderImpl implements Builder {
        private List<InternetGateway> internetGateways;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInternetGatewaysResponse model) {
            setInternetGateways(model.internetGateways);
        }

        public final Collection<InternetGateway> getInternetGateways() {
            return internetGateways;
        }

        @Override
        public final Builder internetGateways(Collection<InternetGateway> internetGateways) {
            this.internetGateways = InternetGatewayListCopier.copy(internetGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetGateways(InternetGateway... internetGateways) {
            internetGateways(Arrays.asList(internetGateways));
            return this;
        }

        public final void setInternetGateways(Collection<InternetGateway> internetGateways) {
            this.internetGateways = InternetGatewayListCopier.copy(internetGateways);
        }

        @SafeVarargs
        public final void setInternetGateways(InternetGateway... internetGateways) {
            internetGateways(Arrays.asList(internetGateways));
        }

        @Override
        public DescribeInternetGatewaysResponse build() {
            return new DescribeInternetGatewaysResponse(this);
        }
    }
}
