/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribePlacementGroups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribePlacementGroupsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribePlacementGroupsResponse.Builder, DescribePlacementGroupsResponse> {
    private final List<PlacementGroup> placementGroups;

    private DescribePlacementGroupsResponse(BuilderImpl builder) {
        this.placementGroups = builder.placementGroups;
    }

    /**
     * <p>
     * One or more placement groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more placement groups.
     */
    public List<PlacementGroup> placementGroups() {
        return placementGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((placementGroups() == null) ? 0 : placementGroups().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePlacementGroupsResponse)) {
            return false;
        }
        DescribePlacementGroupsResponse other = (DescribePlacementGroupsResponse) obj;
        if (other.placementGroups() == null ^ this.placementGroups() == null) {
            return false;
        }
        if (other.placementGroups() != null && !other.placementGroups().equals(this.placementGroups())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (placementGroups() != null) {
            sb.append("PlacementGroups: ").append(placementGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribePlacementGroupsResponse> {
        /**
         * <p>
         * One or more placement groups.
         * </p>
         * 
         * @param placementGroups
         *        One or more placement groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroups(Collection<PlacementGroup> placementGroups);

        /**
         * <p>
         * One or more placement groups.
         * </p>
         * 
         * @param placementGroups
         *        One or more placement groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroups(PlacementGroup... placementGroups);
    }

    private static final class BuilderImpl implements Builder {
        private List<PlacementGroup> placementGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePlacementGroupsResponse model) {
            setPlacementGroups(model.placementGroups);
        }

        public final Collection<PlacementGroup> getPlacementGroups() {
            return placementGroups;
        }

        @Override
        public final Builder placementGroups(Collection<PlacementGroup> placementGroups) {
            this.placementGroups = PlacementGroupListCopier.copy(placementGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementGroups(PlacementGroup... placementGroups) {
            placementGroups(Arrays.asList(placementGroups));
            return this;
        }

        public final void setPlacementGroups(Collection<PlacementGroup> placementGroups) {
            this.placementGroups = PlacementGroupListCopier.copy(placementGroups);
        }

        @SafeVarargs
        public final void setPlacementGroups(PlacementGroup... placementGroups) {
            placementGroups(Arrays.asList(placementGroups));
        }

        @Override
        public DescribePlacementGroupsResponse build() {
            return new DescribePlacementGroupsResponse(this);
        }
    }
}
