/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeRegions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeRegionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeRegionsRequest.Builder, DescribeRegionsRequest> {
    private final List<Filter> filters;

    private final List<String> regionNames;

    private DescribeRegionsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.regionNames = builder.regionNames;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>endpoint</code> - The endpoint of the region (for example, <code>ec2.us-east-1.amazonaws.com</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>region-name</code> - The name of the region (for example, <code>us-east-1</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>endpoint</code> - The endpoint of the region (for example, <code>ec2.us-east-1.amazonaws.com</code>
     *         ).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>region-name</code> - The name of the region (for example, <code>us-east-1</code>).
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The names of one or more regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of one or more regions.
     */
    public List<String> regionNames() {
        return regionNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((regionNames() == null) ? 0 : regionNames().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegionsRequest)) {
            return false;
        }
        DescribeRegionsRequest other = (DescribeRegionsRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.regionNames() == null ^ this.regionNames() == null) {
            return false;
        }
        if (other.regionNames() != null && !other.regionNames().equals(this.regionNames())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (regionNames() != null) {
            sb.append("RegionNames: ").append(regionNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeRegionsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>endpoint</code> - The endpoint of the region (for example, <code>ec2.us-east-1.amazonaws.com</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>region-name</code> - The name of the region (for example, <code>us-east-1</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>endpoint</code> - The endpoint of the region (for example,
         *        <code>ec2.us-east-1.amazonaws.com</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>region-name</code> - The name of the region (for example, <code>us-east-1</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>endpoint</code> - The endpoint of the region (for example, <code>ec2.us-east-1.amazonaws.com</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>region-name</code> - The name of the region (for example, <code>us-east-1</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>endpoint</code> - The endpoint of the region (for example,
         *        <code>ec2.us-east-1.amazonaws.com</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>region-name</code> - The name of the region (for example, <code>us-east-1</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The names of one or more regions.
         * </p>
         * 
         * @param regionNames
         *        The names of one or more regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionNames(Collection<String> regionNames);

        /**
         * <p>
         * The names of one or more regions.
         * </p>
         * 
         * @param regionNames
         *        The names of one or more regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionNames(String... regionNames);
    }

    private static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> regionNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegionsRequest model) {
            setFilters(model.filters);
            setRegionNames(model.regionNames);
        }

        public final Collection<Filter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter... filters) {
            filters(Arrays.asList(filters));
        }

        public final Collection<String> getRegionNames() {
            return regionNames;
        }

        @Override
        public final Builder regionNames(Collection<String> regionNames) {
            this.regionNames = RegionNameStringListCopier.copy(regionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionNames(String... regionNames) {
            regionNames(Arrays.asList(regionNames));
            return this;
        }

        public final void setRegionNames(Collection<String> regionNames) {
            this.regionNames = RegionNameStringListCopier.copy(regionNames);
        }

        @SafeVarargs
        public final void setRegionNames(String... regionNames) {
            regionNames(Arrays.asList(regionNames));
        }

        @Override
        public DescribeRegionsRequest build() {
            return new DescribeRegionsRequest(this);
        }
    }
}
