/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeReservedInstancesModifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeReservedInstancesModificationsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeReservedInstancesModificationsRequest.Builder, DescribeReservedInstancesModificationsRequest> {
    private final List<Filter> filters;

    private final List<String> reservedInstancesModificationIds;

    private final String nextToken;

    private DescribeReservedInstancesModificationsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.reservedInstancesModificationIds = builder.reservedInstancesModificationIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client-token</code> - The idempotency token for the modification request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>create-date</code> - The time when the modification request was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>effective-date</code> - The time when the modification becomes effective.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>modification-result.reserved-instances-id</code> - The ID for the Reserved Instances created as part of the
     * modification request. This ID is only available when the status of the modification is <code>fulfilled</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>modification-result.target-configuration.availability-zone</code> - The Availability Zone for the new
     * Reserved Instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>modification-result.target-configuration.instance-count </code> - The number of new Reserved Instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>modification-result.target-configuration.instance-type</code> - The instance type of the new Reserved
     * Instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>modification-result.target-configuration.platform</code> - The network platform of the new Reserved
     * Instances (<code>EC2-Classic</code> | <code>EC2-VPC</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>reserved-instances-id</code> - The ID of the Reserved Instances modified.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>reserved-instances-modification-id</code> - The ID of the modification request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status</code> - The status of the Reserved Instances modification request (<code>processing</code> |
     * <code>fulfilled</code> | <code>failed</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status-message</code> - The reason for the status.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>update-date</code> - The time when the modification request was last updated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>client-token</code> - The idempotency token for the modification request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>create-date</code> - The time when the modification request was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>effective-date</code> - The time when the modification becomes effective.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>modification-result.reserved-instances-id</code> - The ID for the Reserved Instances created as
     *         part of the modification request. This ID is only available when the status of the modification is
     *         <code>fulfilled</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>modification-result.target-configuration.availability-zone</code> - The Availability Zone for the
     *         new Reserved Instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>modification-result.target-configuration.instance-count </code> - The number of new Reserved
     *         Instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>modification-result.target-configuration.instance-type</code> - The instance type of the new
     *         Reserved Instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>modification-result.target-configuration.platform</code> - The network platform of the new Reserved
     *         Instances (<code>EC2-Classic</code> | <code>EC2-VPC</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>reserved-instances-id</code> - The ID of the Reserved Instances modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>reserved-instances-modification-id</code> - The ID of the modification request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status</code> - The status of the Reserved Instances modification request (<code>processing</code>
     *         | <code>fulfilled</code> | <code>failed</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status-message</code> - The reason for the status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>update-date</code> - The time when the modification request was last updated.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * IDs for the submitted modification request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return IDs for the submitted modification request.
     */
    public List<String> reservedInstancesModificationIds() {
        return reservedInstancesModificationIds;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @return The token to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode
                + ((reservedInstancesModificationIds() == null) ? 0 : reservedInstancesModificationIds().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesModificationsRequest)) {
            return false;
        }
        DescribeReservedInstancesModificationsRequest other = (DescribeReservedInstancesModificationsRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.reservedInstancesModificationIds() == null ^ this.reservedInstancesModificationIds() == null) {
            return false;
        }
        if (other.reservedInstancesModificationIds() != null
                && !other.reservedInstancesModificationIds().equals(this.reservedInstancesModificationIds())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (reservedInstancesModificationIds() != null) {
            sb.append("ReservedInstancesModificationIds: ").append(reservedInstancesModificationIds()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeReservedInstancesModificationsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>client-token</code> - The idempotency token for the modification request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>create-date</code> - The time when the modification request was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>effective-date</code> - The time when the modification becomes effective.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.reserved-instances-id</code> - The ID for the Reserved Instances created as part of
         * the modification request. This ID is only available when the status of the modification is
         * <code>fulfilled</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.target-configuration.availability-zone</code> - The Availability Zone for the new
         * Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.target-configuration.instance-count </code> - The number of new Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.target-configuration.instance-type</code> - The instance type of the new Reserved
         * Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.target-configuration.platform</code> - The network platform of the new Reserved
         * Instances (<code>EC2-Classic</code> | <code>EC2-VPC</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-id</code> - The ID of the Reserved Instances modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-modification-id</code> - The ID of the modification request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the Reserved Instances modification request (<code>processing</code> |
         * <code>fulfilled</code> | <code>failed</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-message</code> - The reason for the status.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update-date</code> - The time when the modification request was last updated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>client-token</code> - The idempotency token for the modification request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>create-date</code> - The time when the modification request was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>effective-date</code> - The time when the modification becomes effective.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modification-result.reserved-instances-id</code> - The ID for the Reserved Instances created as
         *        part of the modification request. This ID is only available when the status of the modification is
         *        <code>fulfilled</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modification-result.target-configuration.availability-zone</code> - The Availability Zone for
         *        the new Reserved Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modification-result.target-configuration.instance-count </code> - The number of new Reserved
         *        Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modification-result.target-configuration.instance-type</code> - The instance type of the new
         *        Reserved Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modification-result.target-configuration.platform</code> - The network platform of the new
         *        Reserved Instances (<code>EC2-Classic</code> | <code>EC2-VPC</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reserved-instances-id</code> - The ID of the Reserved Instances modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reserved-instances-modification-id</code> - The ID of the modification request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the Reserved Instances modification request (
         *        <code>processing</code> | <code>fulfilled</code> | <code>failed</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status-message</code> - The reason for the status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update-date</code> - The time when the modification request was last updated.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>client-token</code> - The idempotency token for the modification request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>create-date</code> - The time when the modification request was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>effective-date</code> - The time when the modification becomes effective.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.reserved-instances-id</code> - The ID for the Reserved Instances created as part of
         * the modification request. This ID is only available when the status of the modification is
         * <code>fulfilled</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.target-configuration.availability-zone</code> - The Availability Zone for the new
         * Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.target-configuration.instance-count </code> - The number of new Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.target-configuration.instance-type</code> - The instance type of the new Reserved
         * Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modification-result.target-configuration.platform</code> - The network platform of the new Reserved
         * Instances (<code>EC2-Classic</code> | <code>EC2-VPC</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-id</code> - The ID of the Reserved Instances modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-modification-id</code> - The ID of the modification request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the Reserved Instances modification request (<code>processing</code> |
         * <code>fulfilled</code> | <code>failed</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-message</code> - The reason for the status.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update-date</code> - The time when the modification request was last updated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>client-token</code> - The idempotency token for the modification request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>create-date</code> - The time when the modification request was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>effective-date</code> - The time when the modification becomes effective.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modification-result.reserved-instances-id</code> - The ID for the Reserved Instances created as
         *        part of the modification request. This ID is only available when the status of the modification is
         *        <code>fulfilled</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modification-result.target-configuration.availability-zone</code> - The Availability Zone for
         *        the new Reserved Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modification-result.target-configuration.instance-count </code> - The number of new Reserved
         *        Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modification-result.target-configuration.instance-type</code> - The instance type of the new
         *        Reserved Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modification-result.target-configuration.platform</code> - The network platform of the new
         *        Reserved Instances (<code>EC2-Classic</code> | <code>EC2-VPC</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reserved-instances-id</code> - The ID of the Reserved Instances modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reserved-instances-modification-id</code> - The ID of the modification request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the Reserved Instances modification request (
         *        <code>processing</code> | <code>fulfilled</code> | <code>failed</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status-message</code> - The reason for the status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update-date</code> - The time when the modification request was last updated.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * IDs for the submitted modification request.
         * </p>
         * 
         * @param reservedInstancesModificationIds
         *        IDs for the submitted modification request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesModificationIds(Collection<String> reservedInstancesModificationIds);

        /**
         * <p>
         * IDs for the submitted modification request.
         * </p>
         * 
         * @param reservedInstancesModificationIds
         *        IDs for the submitted modification request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesModificationIds(String... reservedInstancesModificationIds);

        /**
         * <p>
         * The token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> reservedInstancesModificationIds;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesModificationsRequest model) {
            setFilters(model.filters);
            setReservedInstancesModificationIds(model.reservedInstancesModificationIds);
            setNextToken(model.nextToken);
        }

        public final Collection<Filter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter... filters) {
            filters(Arrays.asList(filters));
        }

        public final Collection<String> getReservedInstancesModificationIds() {
            return reservedInstancesModificationIds;
        }

        @Override
        public final Builder reservedInstancesModificationIds(Collection<String> reservedInstancesModificationIds) {
            this.reservedInstancesModificationIds = ReservedInstancesModificationIdStringListCopier
                    .copy(reservedInstancesModificationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesModificationIds(String... reservedInstancesModificationIds) {
            reservedInstancesModificationIds(Arrays.asList(reservedInstancesModificationIds));
            return this;
        }

        public final void setReservedInstancesModificationIds(Collection<String> reservedInstancesModificationIds) {
            this.reservedInstancesModificationIds = ReservedInstancesModificationIdStringListCopier
                    .copy(reservedInstancesModificationIds);
        }

        @SafeVarargs
        public final void setReservedInstancesModificationIds(String... reservedInstancesModificationIds) {
            reservedInstancesModificationIds(Arrays.asList(reservedInstancesModificationIds));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeReservedInstancesModificationsRequest build() {
            return new DescribeReservedInstancesModificationsRequest(this);
        }
    }
}
