/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeReservedInstancesOfferings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeReservedInstancesOfferingsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeReservedInstancesOfferingsRequest.Builder, DescribeReservedInstancesOfferingsRequest> {
    private final String availabilityZone;

    private final List<Filter> filters;

    private final Boolean includeMarketplace;

    private final String instanceType;

    private final Long maxDuration;

    private final Integer maxInstanceCount;

    private final Long minDuration;

    private final String offeringClass;

    private final String productDescription;

    private final List<String> reservedInstancesOfferingIds;

    private final String instanceTenancy;

    private final Integer maxResults;

    private final String nextToken;

    private final String offeringType;

    private DescribeReservedInstancesOfferingsRequest(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.filters = builder.filters;
        this.includeMarketplace = builder.includeMarketplace;
        this.instanceType = builder.instanceType;
        this.maxDuration = builder.maxDuration;
        this.maxInstanceCount = builder.maxInstanceCount;
        this.minDuration = builder.minDuration;
        this.offeringClass = builder.offeringClass;
        this.productDescription = builder.productDescription;
        this.reservedInstancesOfferingIds = builder.reservedInstancesOfferingIds;
        this.instanceTenancy = builder.instanceTenancy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.offeringType = builder.offeringType;
    }

    /**
     * <p>
     * The Availability Zone in which the Reserved Instance can be used.
     * </p>
     * 
     * @return The Availability Zone in which the Reserved Instance can be used.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>duration</code> - The duration of the Reserved Instance (for example, one year or three years), in seconds
     * (<code>31536000</code> | <code>94608000</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-type</code> - The instance type that is covered by the reservation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>marketplace</code> - Set to <code>true</code> to show only Reserved Instance Marketplace offerings. When
     * this filter is not used, which is the default behavior, all offerings from both AWS and the Reserved Instance
     * Marketplace are listed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>product-description</code> - The Reserved Instance product platform description. Instances that include
     * <code>(Amazon VPC)</code> in the product platform description will only be displayed to EC2-Classic account
     * holders and are for use with Amazon VPC. (<code>Linux/UNIX</code> | <code>Linux/UNIX (Amazon VPC)</code> |
     * <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code> | <code>Red Hat Enterprise Linux</code> |
     * <code>Red Hat Enterprise Linux (Amazon VPC)</code> | <code>Windows</code> | <code>Windows (Amazon VPC)</code> |
     * <code>Windows with SQL Server Standard</code> | <code>Windows with SQL Server Standard (Amazon VPC)</code> |
     * <code>Windows with SQL Server Web</code> | <code> Windows with SQL Server Web (Amazon VPC)</code> |
     * <code>Windows with SQL Server Enterprise</code> | <code>Windows with SQL Server Enterprise (Amazon VPC)</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>reserved-instances-offering-id</code> - The Reserved Instances offering ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>scope</code> - The scope of the Reserved Instance (<code>Availability Zone</code> or <code>Region</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>duration</code> - The duration of the Reserved Instance (for example, one year or three years), in
     *         seconds (<code>31536000</code> | <code>94608000</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-type</code> - The instance type that is covered by the reservation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>marketplace</code> - Set to <code>true</code> to show only Reserved Instance Marketplace offerings.
     *         When this filter is not used, which is the default behavior, all offerings from both AWS and the Reserved
     *         Instance Marketplace are listed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>product-description</code> - The Reserved Instance product platform description. Instances that
     *         include <code>(Amazon VPC)</code> in the product platform description will only be displayed to
     *         EC2-Classic account holders and are for use with Amazon VPC. (<code>Linux/UNIX</code> |
     *         <code>Linux/UNIX (Amazon VPC)</code> | <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code> |
     *         <code>Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux (Amazon VPC)</code> |
     *         <code>Windows</code> | <code>Windows (Amazon VPC)</code> | <code>Windows with SQL Server Standard</code>
     *         | <code>Windows with SQL Server Standard (Amazon VPC)</code> | <code>Windows with SQL Server Web</code> |
     *         <code> Windows with SQL Server Web (Amazon VPC)</code> | <code>Windows with SQL Server Enterprise</code>
     *         | <code>Windows with SQL Server Enterprise (Amazon VPC)</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>reserved-instances-offering-id</code> - The Reserved Instances offering ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>scope</code> - The scope of the Reserved Instance (<code>Availability Zone</code> or
     *         <code>Region</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * Include Reserved Instance Marketplace offerings in the response.
     * </p>
     * 
     * @return Include Reserved Instance Marketplace offerings in the response.
     */
    public Boolean includeMarketplace() {
        return includeMarketplace;
    }

    /**
     * <p>
     * The instance type that the reservation will cover (for example, <code>m1.small</code>). For more information, see
     * <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The instance type that the reservation will cover (for example, <code>m1.small</code>). For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.
     * @see InstanceType
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The maximum duration (in seconds) to filter when searching for offerings.
     * </p>
     * <p>
     * Default: 94608000 (3 years)
     * </p>
     * 
     * @return The maximum duration (in seconds) to filter when searching for offerings.</p>
     *         <p>
     *         Default: 94608000 (3 years)
     */
    public Long maxDuration() {
        return maxDuration;
    }

    /**
     * <p>
     * The maximum number of instances to filter when searching for offerings.
     * </p>
     * <p>
     * Default: 20
     * </p>
     * 
     * @return The maximum number of instances to filter when searching for offerings.</p>
     *         <p>
     *         Default: 20
     */
    public Integer maxInstanceCount() {
        return maxInstanceCount;
    }

    /**
     * <p>
     * The minimum duration (in seconds) to filter when searching for offerings.
     * </p>
     * <p>
     * Default: 2592000 (1 month)
     * </p>
     * 
     * @return The minimum duration (in seconds) to filter when searching for offerings.</p>
     *         <p>
     *         Default: 2592000 (1 month)
     */
    public Long minDuration() {
        return minDuration;
    }

    /**
     * <p>
     * The offering class of the Reserved Instance. Can be <code>standard</code> or <code>convertible</code>.
     * </p>
     * 
     * @return The offering class of the Reserved Instance. Can be <code>standard</code> or <code>convertible</code>.
     * @see OfferingClassType
     */
    public String offeringClass() {
        return offeringClass;
    }

    /**
     * <p>
     * The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code> in the
     * description are for use with Amazon VPC.
     * </p>
     * 
     * @return The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code> in
     *         the description are for use with Amazon VPC.
     * @see RIProductDescription
     */
    public String productDescription() {
        return productDescription;
    }

    /**
     * <p>
     * One or more Reserved Instances offering IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more Reserved Instances offering IDs.
     */
    public List<String> reservedInstancesOfferingIds() {
        return reservedInstancesOfferingIds;
    }

    /**
     * <p>
     * The tenancy of the instances covered by the reservation. A Reserved Instance with a tenancy of
     * <code>dedicated</code> is applied to instances that run in a VPC on single-tenant hardware (i.e., Dedicated
     * Instances).
     * </p>
     * <p>
     * <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the <code>default</code> or
     * <code>dedicated</code> values only.
     * </p>
     * <p>
     * Default: <code>default</code>
     * </p>
     * 
     * @return The tenancy of the instances covered by the reservation. A Reserved Instance with a tenancy of
     *         <code>dedicated</code> is applied to instances that run in a VPC on single-tenant hardware (i.e.,
     *         Dedicated Instances).</p>
     *         <p>
     *         <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
     *         <code>default</code> or <code>dedicated</code> values only.
     *         </p>
     *         <p>
     *         Default: <code>default</code>
     * @see Tenancy
     */
    public String instanceTenancy() {
        return instanceTenancy;
    }

    /**
     * <p>
     * The maximum number of results to return for the request in a single page. The remaining results of the initial
     * request can be seen by sending another request with the returned <code>NextToken</code> value. The maximum is
     * 100.
     * </p>
     * <p>
     * Default: 100
     * </p>
     * 
     * @return The maximum number of results to return for the request in a single page. The remaining results of the
     *         initial request can be seen by sending another request with the returned <code>NextToken</code> value.
     *         The maximum is 100.</p>
     *         <p>
     *         Default: 100
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @return The token to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you only
     * have access to the <code>Medium Utilization</code> Reserved Instance offering type.
     * </p>
     * 
     * @return The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you
     *         only have access to the <code>Medium Utilization</code> Reserved Instance offering type.
     * @see OfferingTypeValues
     */
    public String offeringType() {
        return offeringType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((includeMarketplace() == null) ? 0 : includeMarketplace().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((maxDuration() == null) ? 0 : maxDuration().hashCode());
        hashCode = 31 * hashCode + ((maxInstanceCount() == null) ? 0 : maxInstanceCount().hashCode());
        hashCode = 31 * hashCode + ((minDuration() == null) ? 0 : minDuration().hashCode());
        hashCode = 31 * hashCode + ((offeringClass() == null) ? 0 : offeringClass().hashCode());
        hashCode = 31 * hashCode + ((productDescription() == null) ? 0 : productDescription().hashCode());
        hashCode = 31 * hashCode + ((reservedInstancesOfferingIds() == null) ? 0 : reservedInstancesOfferingIds().hashCode());
        hashCode = 31 * hashCode + ((instanceTenancy() == null) ? 0 : instanceTenancy().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((offeringType() == null) ? 0 : offeringType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesOfferingsRequest)) {
            return false;
        }
        DescribeReservedInstancesOfferingsRequest other = (DescribeReservedInstancesOfferingsRequest) obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.includeMarketplace() == null ^ this.includeMarketplace() == null) {
            return false;
        }
        if (other.includeMarketplace() != null && !other.includeMarketplace().equals(this.includeMarketplace())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.maxDuration() == null ^ this.maxDuration() == null) {
            return false;
        }
        if (other.maxDuration() != null && !other.maxDuration().equals(this.maxDuration())) {
            return false;
        }
        if (other.maxInstanceCount() == null ^ this.maxInstanceCount() == null) {
            return false;
        }
        if (other.maxInstanceCount() != null && !other.maxInstanceCount().equals(this.maxInstanceCount())) {
            return false;
        }
        if (other.minDuration() == null ^ this.minDuration() == null) {
            return false;
        }
        if (other.minDuration() != null && !other.minDuration().equals(this.minDuration())) {
            return false;
        }
        if (other.offeringClass() == null ^ this.offeringClass() == null) {
            return false;
        }
        if (other.offeringClass() != null && !other.offeringClass().equals(this.offeringClass())) {
            return false;
        }
        if (other.productDescription() == null ^ this.productDescription() == null) {
            return false;
        }
        if (other.productDescription() != null && !other.productDescription().equals(this.productDescription())) {
            return false;
        }
        if (other.reservedInstancesOfferingIds() == null ^ this.reservedInstancesOfferingIds() == null) {
            return false;
        }
        if (other.reservedInstancesOfferingIds() != null
                && !other.reservedInstancesOfferingIds().equals(this.reservedInstancesOfferingIds())) {
            return false;
        }
        if (other.instanceTenancy() == null ^ this.instanceTenancy() == null) {
            return false;
        }
        if (other.instanceTenancy() != null && !other.instanceTenancy().equals(this.instanceTenancy())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.offeringType() == null ^ this.offeringType() == null) {
            return false;
        }
        if (other.offeringType() != null && !other.offeringType().equals(this.offeringType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (includeMarketplace() != null) {
            sb.append("IncludeMarketplace: ").append(includeMarketplace()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (maxDuration() != null) {
            sb.append("MaxDuration: ").append(maxDuration()).append(",");
        }
        if (maxInstanceCount() != null) {
            sb.append("MaxInstanceCount: ").append(maxInstanceCount()).append(",");
        }
        if (minDuration() != null) {
            sb.append("MinDuration: ").append(minDuration()).append(",");
        }
        if (offeringClass() != null) {
            sb.append("OfferingClass: ").append(offeringClass()).append(",");
        }
        if (productDescription() != null) {
            sb.append("ProductDescription: ").append(productDescription()).append(",");
        }
        if (reservedInstancesOfferingIds() != null) {
            sb.append("ReservedInstancesOfferingIds: ").append(reservedInstancesOfferingIds()).append(",");
        }
        if (instanceTenancy() != null) {
            sb.append("InstanceTenancy: ").append(instanceTenancy()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (offeringType() != null) {
            sb.append("OfferingType: ").append(offeringType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeReservedInstancesOfferingsRequest> {
        /**
         * <p>
         * The Availability Zone in which the Reserved Instance can be used.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the Reserved Instance can be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>duration</code> - The duration of the Reserved Instance (for example, one year or three years), in
         * seconds (<code>31536000</code> | <code>94608000</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type that is covered by the reservation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>marketplace</code> - Set to <code>true</code> to show only Reserved Instance Marketplace offerings.
         * When this filter is not used, which is the default behavior, all offerings from both AWS and the Reserved
         * Instance Marketplace are listed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-description</code> - The Reserved Instance product platform description. Instances that include
         * <code>(Amazon VPC)</code> in the product platform description will only be displayed to EC2-Classic account
         * holders and are for use with Amazon VPC. (<code>Linux/UNIX</code> | <code>Linux/UNIX (Amazon VPC)</code> |
         * <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code> | <code>Red Hat Enterprise Linux</code> |
         * <code>Red Hat Enterprise Linux (Amazon VPC)</code> | <code>Windows</code> | <code>Windows (Amazon VPC)</code>
         * | <code>Windows with SQL Server Standard</code> | <code>Windows with SQL Server Standard (Amazon VPC)</code>
         * | <code>Windows with SQL Server Web</code> | <code> Windows with SQL Server Web (Amazon VPC)</code> |
         * <code>Windows with SQL Server Enterprise</code> |
         * <code>Windows with SQL Server Enterprise (Amazon VPC)</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-offering-id</code> - The Reserved Instances offering ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>scope</code> - The scope of the Reserved Instance (<code>Availability Zone</code> or
         * <code>Region</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>duration</code> - The duration of the Reserved Instance (for example, one year or three years),
         *        in seconds (<code>31536000</code> | <code>94608000</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type that is covered by the reservation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>marketplace</code> - Set to <code>true</code> to show only Reserved Instance Marketplace
         *        offerings. When this filter is not used, which is the default behavior, all offerings from both AWS
         *        and the Reserved Instance Marketplace are listed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-description</code> - The Reserved Instance product platform description. Instances that
         *        include <code>(Amazon VPC)</code> in the product platform description will only be displayed to
         *        EC2-Classic account holders and are for use with Amazon VPC. (<code>Linux/UNIX</code> |
         *        <code>Linux/UNIX (Amazon VPC)</code> | <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code>
         *        | <code>Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux (Amazon VPC)</code> |
         *        <code>Windows</code> | <code>Windows (Amazon VPC)</code> |
         *        <code>Windows with SQL Server Standard</code> |
         *        <code>Windows with SQL Server Standard (Amazon VPC)</code> | <code>Windows with SQL Server Web</code>
         *        | <code> Windows with SQL Server Web (Amazon VPC)</code> |
         *        <code>Windows with SQL Server Enterprise</code> |
         *        <code>Windows with SQL Server Enterprise (Amazon VPC)</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reserved-instances-offering-id</code> - The Reserved Instances offering ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>scope</code> - The scope of the Reserved Instance (<code>Availability Zone</code> or
         *        <code>Region</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>duration</code> - The duration of the Reserved Instance (for example, one year or three years), in
         * seconds (<code>31536000</code> | <code>94608000</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type that is covered by the reservation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>marketplace</code> - Set to <code>true</code> to show only Reserved Instance Marketplace offerings.
         * When this filter is not used, which is the default behavior, all offerings from both AWS and the Reserved
         * Instance Marketplace are listed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-description</code> - The Reserved Instance product platform description. Instances that include
         * <code>(Amazon VPC)</code> in the product platform description will only be displayed to EC2-Classic account
         * holders and are for use with Amazon VPC. (<code>Linux/UNIX</code> | <code>Linux/UNIX (Amazon VPC)</code> |
         * <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code> | <code>Red Hat Enterprise Linux</code> |
         * <code>Red Hat Enterprise Linux (Amazon VPC)</code> | <code>Windows</code> | <code>Windows (Amazon VPC)</code>
         * | <code>Windows with SQL Server Standard</code> | <code>Windows with SQL Server Standard (Amazon VPC)</code>
         * | <code>Windows with SQL Server Web</code> | <code> Windows with SQL Server Web (Amazon VPC)</code> |
         * <code>Windows with SQL Server Enterprise</code> |
         * <code>Windows with SQL Server Enterprise (Amazon VPC)</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reserved-instances-offering-id</code> - The Reserved Instances offering ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>scope</code> - The scope of the Reserved Instance (<code>Availability Zone</code> or
         * <code>Region</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>duration</code> - The duration of the Reserved Instance (for example, one year or three years),
         *        in seconds (<code>31536000</code> | <code>94608000</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type that is covered by the reservation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>marketplace</code> - Set to <code>true</code> to show only Reserved Instance Marketplace
         *        offerings. When this filter is not used, which is the default behavior, all offerings from both AWS
         *        and the Reserved Instance Marketplace are listed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-description</code> - The Reserved Instance product platform description. Instances that
         *        include <code>(Amazon VPC)</code> in the product platform description will only be displayed to
         *        EC2-Classic account holders and are for use with Amazon VPC. (<code>Linux/UNIX</code> |
         *        <code>Linux/UNIX (Amazon VPC)</code> | <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code>
         *        | <code>Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux (Amazon VPC)</code> |
         *        <code>Windows</code> | <code>Windows (Amazon VPC)</code> |
         *        <code>Windows with SQL Server Standard</code> |
         *        <code>Windows with SQL Server Standard (Amazon VPC)</code> | <code>Windows with SQL Server Web</code>
         *        | <code> Windows with SQL Server Web (Amazon VPC)</code> |
         *        <code>Windows with SQL Server Enterprise</code> |
         *        <code>Windows with SQL Server Enterprise (Amazon VPC)</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reserved-instances-offering-id</code> - The Reserved Instances offering ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>scope</code> - The scope of the Reserved Instance (<code>Availability Zone</code> or
         *        <code>Region</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * Include Reserved Instance Marketplace offerings in the response.
         * </p>
         * 
         * @param includeMarketplace
         *        Include Reserved Instance Marketplace offerings in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeMarketplace(Boolean includeMarketplace);

        /**
         * <p>
         * The instance type that the reservation will cover (for example, <code>m1.small</code>). For more information,
         * see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in
         * the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param instanceType
         *        The instance type that the reservation will cover (for example, <code>m1.small</code>). For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in
         *        the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type that the reservation will cover (for example, <code>m1.small</code>). For more information,
         * see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in
         * the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param instanceType
         *        The instance type that the reservation will cover (for example, <code>m1.small</code>). For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in
         *        the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The maximum duration (in seconds) to filter when searching for offerings.
         * </p>
         * <p>
         * Default: 94608000 (3 years)
         * </p>
         * 
         * @param maxDuration
         *        The maximum duration (in seconds) to filter when searching for offerings.</p>
         *        <p>
         *        Default: 94608000 (3 years)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDuration(Long maxDuration);

        /**
         * <p>
         * The maximum number of instances to filter when searching for offerings.
         * </p>
         * <p>
         * Default: 20
         * </p>
         * 
         * @param maxInstanceCount
         *        The maximum number of instances to filter when searching for offerings.</p>
         *        <p>
         *        Default: 20
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxInstanceCount(Integer maxInstanceCount);

        /**
         * <p>
         * The minimum duration (in seconds) to filter when searching for offerings.
         * </p>
         * <p>
         * Default: 2592000 (1 month)
         * </p>
         * 
         * @param minDuration
         *        The minimum duration (in seconds) to filter when searching for offerings.</p>
         *        <p>
         *        Default: 2592000 (1 month)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minDuration(Long minDuration);

        /**
         * <p>
         * The offering class of the Reserved Instance. Can be <code>standard</code> or <code>convertible</code>.
         * </p>
         * 
         * @param offeringClass
         *        The offering class of the Reserved Instance. Can be <code>standard</code> or <code>convertible</code>.
         * @see OfferingClassType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClassType
         */
        Builder offeringClass(String offeringClass);

        /**
         * <p>
         * The offering class of the Reserved Instance. Can be <code>standard</code> or <code>convertible</code>.
         * </p>
         * 
         * @param offeringClass
         *        The offering class of the Reserved Instance. Can be <code>standard</code> or <code>convertible</code>.
         * @see OfferingClassType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClassType
         */
        Builder offeringClass(OfferingClassType offeringClass);

        /**
         * <p>
         * The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code> in the
         * description are for use with Amazon VPC.
         * </p>
         * 
         * @param productDescription
         *        The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code>
         *        in the description are for use with Amazon VPC.
         * @see RIProductDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RIProductDescription
         */
        Builder productDescription(String productDescription);

        /**
         * <p>
         * The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code> in the
         * description are for use with Amazon VPC.
         * </p>
         * 
         * @param productDescription
         *        The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code>
         *        in the description are for use with Amazon VPC.
         * @see RIProductDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RIProductDescription
         */
        Builder productDescription(RIProductDescription productDescription);

        /**
         * <p>
         * One or more Reserved Instances offering IDs.
         * </p>
         * 
         * @param reservedInstancesOfferingIds
         *        One or more Reserved Instances offering IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesOfferingIds(Collection<String> reservedInstancesOfferingIds);

        /**
         * <p>
         * One or more Reserved Instances offering IDs.
         * </p>
         * 
         * @param reservedInstancesOfferingIds
         *        One or more Reserved Instances offering IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesOfferingIds(String... reservedInstancesOfferingIds);

        /**
         * <p>
         * The tenancy of the instances covered by the reservation. A Reserved Instance with a tenancy of
         * <code>dedicated</code> is applied to instances that run in a VPC on single-tenant hardware (i.e., Dedicated
         * Instances).
         * </p>
         * <p>
         * <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
         * <code>default</code> or <code>dedicated</code> values only.
         * </p>
         * <p>
         * Default: <code>default</code>
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy of the instances covered by the reservation. A Reserved Instance with a tenancy of
         *        <code>dedicated</code> is applied to instances that run in a VPC on single-tenant hardware (i.e.,
         *        Dedicated Instances).</p>
         *        <p>
         *        <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
         *        <code>default</code> or <code>dedicated</code> values only.
         *        </p>
         *        <p>
         *        Default: <code>default</code>
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(String instanceTenancy);

        /**
         * <p>
         * The tenancy of the instances covered by the reservation. A Reserved Instance with a tenancy of
         * <code>dedicated</code> is applied to instances that run in a VPC on single-tenant hardware (i.e., Dedicated
         * Instances).
         * </p>
         * <p>
         * <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
         * <code>default</code> or <code>dedicated</code> values only.
         * </p>
         * <p>
         * Default: <code>default</code>
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy of the instances covered by the reservation. A Reserved Instance with a tenancy of
         *        <code>dedicated</code> is applied to instances that run in a VPC on single-tenant hardware (i.e.,
         *        Dedicated Instances).</p>
         *        <p>
         *        <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
         *        <code>default</code> or <code>dedicated</code> values only.
         *        </p>
         *        <p>
         *        Default: <code>default</code>
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(Tenancy instanceTenancy);

        /**
         * <p>
         * The maximum number of results to return for the request in a single page. The remaining results of the
         * initial request can be seen by sending another request with the returned <code>NextToken</code> value. The
         * maximum is 100.
         * </p>
         * <p>
         * Default: 100
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for the request in a single page. The remaining results of the
         *        initial request can be seen by sending another request with the returned <code>NextToken</code> value.
         *        The maximum is 100.</p>
         *        <p>
         *        Default: 100
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you only
         * have access to the <code>Medium Utilization</code> Reserved Instance offering type.
         * </p>
         * 
         * @param offeringType
         *        The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version,
         *        you only have access to the <code>Medium Utilization</code> Reserved Instance offering type.
         * @see OfferingTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTypeValues
         */
        Builder offeringType(String offeringType);

        /**
         * <p>
         * The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you only
         * have access to the <code>Medium Utilization</code> Reserved Instance offering type.
         * </p>
         * 
         * @param offeringType
         *        The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version,
         *        you only have access to the <code>Medium Utilization</code> Reserved Instance offering type.
         * @see OfferingTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTypeValues
         */
        Builder offeringType(OfferingTypeValues offeringType);
    }

    private static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private List<Filter> filters;

        private Boolean includeMarketplace;

        private String instanceType;

        private Long maxDuration;

        private Integer maxInstanceCount;

        private Long minDuration;

        private String offeringClass;

        private String productDescription;

        private List<String> reservedInstancesOfferingIds;

        private String instanceTenancy;

        private Integer maxResults;

        private String nextToken;

        private String offeringType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesOfferingsRequest model) {
            setAvailabilityZone(model.availabilityZone);
            setFilters(model.filters);
            setIncludeMarketplace(model.includeMarketplace);
            setInstanceType(model.instanceType);
            setMaxDuration(model.maxDuration);
            setMaxInstanceCount(model.maxInstanceCount);
            setMinDuration(model.minDuration);
            setOfferingClass(model.offeringClass);
            setProductDescription(model.productDescription);
            setReservedInstancesOfferingIds(model.reservedInstancesOfferingIds);
            setInstanceTenancy(model.instanceTenancy);
            setMaxResults(model.maxResults);
            setNextToken(model.nextToken);
            setOfferingType(model.offeringType);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Collection<Filter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter... filters) {
            filters(Arrays.asList(filters));
        }

        public final Boolean getIncludeMarketplace() {
            return includeMarketplace;
        }

        @Override
        public final Builder includeMarketplace(Boolean includeMarketplace) {
            this.includeMarketplace = includeMarketplace;
            return this;
        }

        public final void setIncludeMarketplace(Boolean includeMarketplace) {
            this.includeMarketplace = includeMarketplace;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final void setInstanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
        }

        public final Long getMaxDuration() {
            return maxDuration;
        }

        @Override
        public final Builder maxDuration(Long maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public final void setMaxDuration(Long maxDuration) {
            this.maxDuration = maxDuration;
        }

        public final Integer getMaxInstanceCount() {
            return maxInstanceCount;
        }

        @Override
        public final Builder maxInstanceCount(Integer maxInstanceCount) {
            this.maxInstanceCount = maxInstanceCount;
            return this;
        }

        public final void setMaxInstanceCount(Integer maxInstanceCount) {
            this.maxInstanceCount = maxInstanceCount;
        }

        public final Long getMinDuration() {
            return minDuration;
        }

        @Override
        public final Builder minDuration(Long minDuration) {
            this.minDuration = minDuration;
            return this;
        }

        public final void setMinDuration(Long minDuration) {
            this.minDuration = minDuration;
        }

        public final String getOfferingClass() {
            return offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
            return this;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        public final void setOfferingClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
        }

        public final String getProductDescription() {
            return productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final void setProductDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
        }

        public final Collection<String> getReservedInstancesOfferingIds() {
            return reservedInstancesOfferingIds;
        }

        @Override
        public final Builder reservedInstancesOfferingIds(Collection<String> reservedInstancesOfferingIds) {
            this.reservedInstancesOfferingIds = ReservedInstancesOfferingIdStringListCopier.copy(reservedInstancesOfferingIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesOfferingIds(String... reservedInstancesOfferingIds) {
            reservedInstancesOfferingIds(Arrays.asList(reservedInstancesOfferingIds));
            return this;
        }

        public final void setReservedInstancesOfferingIds(Collection<String> reservedInstancesOfferingIds) {
            this.reservedInstancesOfferingIds = ReservedInstancesOfferingIdStringListCopier.copy(reservedInstancesOfferingIds);
        }

        @SafeVarargs
        public final void setReservedInstancesOfferingIds(String... reservedInstancesOfferingIds) {
            reservedInstancesOfferingIds(Arrays.asList(reservedInstancesOfferingIds));
        }

        public final String getInstanceTenancy() {
            return instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final void setInstanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getOfferingType() {
            return offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final void setOfferingType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
        }

        @Override
        public DescribeReservedInstancesOfferingsRequest build() {
            return new DescribeReservedInstancesOfferingsRequest(this);
        }
    }
}
