/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeSpotPriceHistory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSpotPriceHistoryResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeSpotPriceHistoryResponse.Builder, DescribeSpotPriceHistoryResponse> {
    private final String nextToken;

    private final List<SpotPrice> spotPriceHistory;

    private DescribeSpotPriceHistoryResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.spotPriceHistory = builder.spotPriceHistory;
    }

    /**
     * <p>
     * The token required to retrieve the next set of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token required to retrieve the next set of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The historical Spot prices.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The historical Spot prices.
     */
    public List<SpotPrice> spotPriceHistory() {
        return spotPriceHistory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((spotPriceHistory() == null) ? 0 : spotPriceHistory().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotPriceHistoryResponse)) {
            return false;
        }
        DescribeSpotPriceHistoryResponse other = (DescribeSpotPriceHistoryResponse) obj;
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.spotPriceHistory() == null ^ this.spotPriceHistory() == null) {
            return false;
        }
        if (other.spotPriceHistory() != null && !other.spotPriceHistory().equals(this.spotPriceHistory())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (spotPriceHistory() != null) {
            sb.append("SpotPriceHistory: ").append(spotPriceHistory()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeSpotPriceHistoryResponse> {
        /**
         * <p>
         * The token required to retrieve the next set of results. This value is <code>null</code> when there are no
         * more results to return.
         * </p>
         * 
         * @param nextToken
         *        The token required to retrieve the next set of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The historical Spot prices.
         * </p>
         * 
         * @param spotPriceHistory
         *        The historical Spot prices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotPriceHistory(Collection<SpotPrice> spotPriceHistory);

        /**
         * <p>
         * The historical Spot prices.
         * </p>
         * 
         * @param spotPriceHistory
         *        The historical Spot prices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotPriceHistory(SpotPrice... spotPriceHistory);
    }

    private static final class BuilderImpl implements Builder {
        private String nextToken;

        private List<SpotPrice> spotPriceHistory;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotPriceHistoryResponse model) {
            setNextToken(model.nextToken);
            setSpotPriceHistory(model.spotPriceHistory);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<SpotPrice> getSpotPriceHistory() {
            return spotPriceHistory;
        }

        @Override
        public final Builder spotPriceHistory(Collection<SpotPrice> spotPriceHistory) {
            this.spotPriceHistory = SpotPriceHistoryListCopier.copy(spotPriceHistory);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotPriceHistory(SpotPrice... spotPriceHistory) {
            spotPriceHistory(Arrays.asList(spotPriceHistory));
            return this;
        }

        public final void setSpotPriceHistory(Collection<SpotPrice> spotPriceHistory) {
            this.spotPriceHistory = SpotPriceHistoryListCopier.copy(spotPriceHistory);
        }

        @SafeVarargs
        public final void setSpotPriceHistory(SpotPrice... spotPriceHistory) {
            spotPriceHistory(Arrays.asList(spotPriceHistory));
        }

        @Override
        public DescribeSpotPriceHistoryResponse build() {
            return new DescribeSpotPriceHistoryResponse(this);
        }
    }
}
