/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeVpcClassicLink.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVpcClassicLinkResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeVpcClassicLinkResponse.Builder, DescribeVpcClassicLinkResponse> {
    private final List<VpcClassicLink> vpcs;

    private DescribeVpcClassicLinkResponse(BuilderImpl builder) {
        this.vpcs = builder.vpcs;
    }

    /**
     * <p>
     * The ClassicLink status of one or more VPCs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The ClassicLink status of one or more VPCs.
     */
    public List<VpcClassicLink> vpcs() {
        return vpcs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((vpcs() == null) ? 0 : vpcs().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcClassicLinkResponse)) {
            return false;
        }
        DescribeVpcClassicLinkResponse other = (DescribeVpcClassicLinkResponse) obj;
        if (other.vpcs() == null ^ this.vpcs() == null) {
            return false;
        }
        if (other.vpcs() != null && !other.vpcs().equals(this.vpcs())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (vpcs() != null) {
            sb.append("Vpcs: ").append(vpcs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeVpcClassicLinkResponse> {
        /**
         * <p>
         * The ClassicLink status of one or more VPCs.
         * </p>
         * 
         * @param vpcs
         *        The ClassicLink status of one or more VPCs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcs(Collection<VpcClassicLink> vpcs);

        /**
         * <p>
         * The ClassicLink status of one or more VPCs.
         * </p>
         * 
         * @param vpcs
         *        The ClassicLink status of one or more VPCs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcs(VpcClassicLink... vpcs);
    }

    private static final class BuilderImpl implements Builder {
        private List<VpcClassicLink> vpcs;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcClassicLinkResponse model) {
            setVpcs(model.vpcs);
        }

        public final Collection<VpcClassicLink> getVpcs() {
            return vpcs;
        }

        @Override
        public final Builder vpcs(Collection<VpcClassicLink> vpcs) {
            this.vpcs = VpcClassicLinkListCopier.copy(vpcs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcs(VpcClassicLink... vpcs) {
            vpcs(Arrays.asList(vpcs));
            return this;
        }

        public final void setVpcs(Collection<VpcClassicLink> vpcs) {
            this.vpcs = VpcClassicLinkListCopier.copy(vpcs);
        }

        @SafeVarargs
        public final void setVpcs(VpcClassicLink... vpcs) {
            vpcs(Arrays.asList(vpcs));
        }

        @Override
        public DescribeVpcClassicLinkResponse build() {
            return new DescribeVpcClassicLinkResponse(this);
        }
    }
}
