/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeVpnConnections.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVpnConnectionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeVpnConnectionsResponse.Builder, DescribeVpnConnectionsResponse> {
    private final List<VpnConnection> vpnConnections;

    private DescribeVpnConnectionsResponse(BuilderImpl builder) {
        this.vpnConnections = builder.vpnConnections;
    }

    /**
     * <p>
     * Information about one or more VPN connections.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more VPN connections.
     */
    public List<VpnConnection> vpnConnections() {
        return vpnConnections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((vpnConnections() == null) ? 0 : vpnConnections().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnConnectionsResponse)) {
            return false;
        }
        DescribeVpnConnectionsResponse other = (DescribeVpnConnectionsResponse) obj;
        if (other.vpnConnections() == null ^ this.vpnConnections() == null) {
            return false;
        }
        if (other.vpnConnections() != null && !other.vpnConnections().equals(this.vpnConnections())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (vpnConnections() != null) {
            sb.append("VpnConnections: ").append(vpnConnections()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeVpnConnectionsResponse> {
        /**
         * <p>
         * Information about one or more VPN connections.
         * </p>
         * 
         * @param vpnConnections
         *        Information about one or more VPN connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnections(Collection<VpnConnection> vpnConnections);

        /**
         * <p>
         * Information about one or more VPN connections.
         * </p>
         * 
         * @param vpnConnections
         *        Information about one or more VPN connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnections(VpnConnection... vpnConnections);
    }

    private static final class BuilderImpl implements Builder {
        private List<VpnConnection> vpnConnections;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpnConnectionsResponse model) {
            setVpnConnections(model.vpnConnections);
        }

        public final Collection<VpnConnection> getVpnConnections() {
            return vpnConnections;
        }

        @Override
        public final Builder vpnConnections(Collection<VpnConnection> vpnConnections) {
            this.vpnConnections = VpnConnectionListCopier.copy(vpnConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnConnections(VpnConnection... vpnConnections) {
            vpnConnections(Arrays.asList(vpnConnections));
            return this;
        }

        public final void setVpnConnections(Collection<VpnConnection> vpnConnections) {
            this.vpnConnections = VpnConnectionListCopier.copy(vpnConnections);
        }

        @SafeVarargs
        public final void setVpnConnections(VpnConnection... vpnConnections) {
            vpnConnections(Arrays.asList(vpnConnections));
        }

        @Override
        public DescribeVpnConnectionsResponse build() {
            return new DescribeVpnConnectionsResponse(this);
        }
    }
}
