/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a disk image volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DiskImageVolumeDescription implements
        ToCopyableBuilder<DiskImageVolumeDescription.Builder, DiskImageVolumeDescription> {
    private final String id;

    private final Long size;

    private DiskImageVolumeDescription(BuilderImpl builder) {
        this.id = builder.id;
        this.size = builder.size;
    }

    /**
     * <p>
     * The volume identifier.
     * </p>
     * 
     * @return The volume identifier.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The size of the volume, in GiB.
     * </p>
     * 
     * @return The size of the volume, in GiB.
     */
    public Long size() {
        return size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((size() == null) ? 0 : size().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskImageVolumeDescription)) {
            return false;
        }
        DiskImageVolumeDescription other = (DiskImageVolumeDescription) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.size() == null ^ this.size() == null) {
            return false;
        }
        if (other.size() != null && !other.size().equals(this.size())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (size() != null) {
            sb.append("Size: ").append(size()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DiskImageVolumeDescription> {
        /**
         * <p>
         * The volume identifier.
         * </p>
         * 
         * @param id
         *        The volume identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The size of the volume, in GiB.
         * </p>
         * 
         * @param size
         *        The size of the volume, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Long size);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private Long size;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskImageVolumeDescription model) {
            setId(model.id);
            setSize(model.size);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Long getSize() {
            return size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public DiskImageVolumeDescription build() {
            return new DiskImageVolumeDescription(this);
        }
    }
}
