/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for EnableVgwRoutePropagation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class EnableVgwRoutePropagationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<EnableVgwRoutePropagationRequest.Builder, EnableVgwRoutePropagationRequest> {
    private final String gatewayId;

    private final String routeTableId;

    private EnableVgwRoutePropagationRequest(BuilderImpl builder) {
        this.gatewayId = builder.gatewayId;
        this.routeTableId = builder.routeTableId;
    }

    /**
     * <p>
     * The ID of the virtual private gateway.
     * </p>
     * 
     * @return The ID of the virtual private gateway.
     */
    public String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The ID of the route table.
     * </p>
     * 
     * @return The ID of the route table.
     */
    public String routeTableId() {
        return routeTableId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((gatewayId() == null) ? 0 : gatewayId().hashCode());
        hashCode = 31 * hashCode + ((routeTableId() == null) ? 0 : routeTableId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableVgwRoutePropagationRequest)) {
            return false;
        }
        EnableVgwRoutePropagationRequest other = (EnableVgwRoutePropagationRequest) obj;
        if (other.gatewayId() == null ^ this.gatewayId() == null) {
            return false;
        }
        if (other.gatewayId() != null && !other.gatewayId().equals(this.gatewayId())) {
            return false;
        }
        if (other.routeTableId() == null ^ this.routeTableId() == null) {
            return false;
        }
        if (other.routeTableId() != null && !other.routeTableId().equals(this.routeTableId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (gatewayId() != null) {
            sb.append("GatewayId: ").append(gatewayId()).append(",");
        }
        if (routeTableId() != null) {
            sb.append("RouteTableId: ").append(routeTableId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, EnableVgwRoutePropagationRequest> {
        /**
         * <p>
         * The ID of the virtual private gateway.
         * </p>
         * 
         * @param gatewayId
         *        The ID of the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The ID of the route table.
         * </p>
         * 
         * @param routeTableId
         *        The ID of the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(String routeTableId);
    }

    private static final class BuilderImpl implements Builder {
        private String gatewayId;

        private String routeTableId;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableVgwRoutePropagationRequest model) {
            setGatewayId(model.gatewayId);
            setRouteTableId(model.routeTableId);
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getRouteTableId() {
            return routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public EnableVgwRoutePropagationRequest build() {
            return new EnableVgwRoutePropagationRequest(this);
        }
    }
}
