/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the format and location for an instance export task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ExportToS3Task implements ToCopyableBuilder<ExportToS3Task.Builder, ExportToS3Task> {
    private final String containerFormat;

    private final String diskImageFormat;

    private final String s3Bucket;

    private final String s3Key;

    private ExportToS3Task(BuilderImpl builder) {
        this.containerFormat = builder.containerFormat;
        this.diskImageFormat = builder.diskImageFormat;
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
    }

    /**
     * <p>
     * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image is
     * exported.
     * </p>
     * 
     * @return The container format used to combine disk images with metadata (such as OVF). If absent, only the disk
     *         image is exported.
     * @see ContainerFormat
     */
    public String containerFormat() {
        return containerFormat;
    }

    /**
     * <p>
     * The format for the exported image.
     * </p>
     * 
     * @return The format for the exported image.
     * @see DiskImageFormat
     */
    public String diskImageFormat() {
        return diskImageFormat;
    }

    /**
     * <p>
     * The S3 bucket for the destination image. The destination bucket must exist and grant WRITE and READ_ACP
     * permissions to the AWS account <code>vm-import-export@amazon.com</code>.
     * </p>
     * 
     * @return The S3 bucket for the destination image. The destination bucket must exist and grant WRITE and READ_ACP
     *         permissions to the AWS account <code>vm-import-export@amazon.com</code>.
     */
    public String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The encryption key for your S3 bucket.
     * </p>
     * 
     * @return The encryption key for your S3 bucket.
     */
    public String s3Key() {
        return s3Key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((containerFormat() == null) ? 0 : containerFormat().hashCode());
        hashCode = 31 * hashCode + ((diskImageFormat() == null) ? 0 : diskImageFormat().hashCode());
        hashCode = 31 * hashCode + ((s3Bucket() == null) ? 0 : s3Bucket().hashCode());
        hashCode = 31 * hashCode + ((s3Key() == null) ? 0 : s3Key().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportToS3Task)) {
            return false;
        }
        ExportToS3Task other = (ExportToS3Task) obj;
        if (other.containerFormat() == null ^ this.containerFormat() == null) {
            return false;
        }
        if (other.containerFormat() != null && !other.containerFormat().equals(this.containerFormat())) {
            return false;
        }
        if (other.diskImageFormat() == null ^ this.diskImageFormat() == null) {
            return false;
        }
        if (other.diskImageFormat() != null && !other.diskImageFormat().equals(this.diskImageFormat())) {
            return false;
        }
        if (other.s3Bucket() == null ^ this.s3Bucket() == null) {
            return false;
        }
        if (other.s3Bucket() != null && !other.s3Bucket().equals(this.s3Bucket())) {
            return false;
        }
        if (other.s3Key() == null ^ this.s3Key() == null) {
            return false;
        }
        if (other.s3Key() != null && !other.s3Key().equals(this.s3Key())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (containerFormat() != null) {
            sb.append("ContainerFormat: ").append(containerFormat()).append(",");
        }
        if (diskImageFormat() != null) {
            sb.append("DiskImageFormat: ").append(diskImageFormat()).append(",");
        }
        if (s3Bucket() != null) {
            sb.append("S3Bucket: ").append(s3Bucket()).append(",");
        }
        if (s3Key() != null) {
            sb.append("S3Key: ").append(s3Key()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ExportToS3Task> {
        /**
         * <p>
         * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image
         * is exported.
         * </p>
         * 
         * @param containerFormat
         *        The container format used to combine disk images with metadata (such as OVF). If absent, only the disk
         *        image is exported.
         * @see ContainerFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerFormat
         */
        Builder containerFormat(String containerFormat);

        /**
         * <p>
         * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image
         * is exported.
         * </p>
         * 
         * @param containerFormat
         *        The container format used to combine disk images with metadata (such as OVF). If absent, only the disk
         *        image is exported.
         * @see ContainerFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerFormat
         */
        Builder containerFormat(ContainerFormat containerFormat);

        /**
         * <p>
         * The format for the exported image.
         * </p>
         * 
         * @param diskImageFormat
         *        The format for the exported image.
         * @see DiskImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskImageFormat
         */
        Builder diskImageFormat(String diskImageFormat);

        /**
         * <p>
         * The format for the exported image.
         * </p>
         * 
         * @param diskImageFormat
         *        The format for the exported image.
         * @see DiskImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskImageFormat
         */
        Builder diskImageFormat(DiskImageFormat diskImageFormat);

        /**
         * <p>
         * The S3 bucket for the destination image. The destination bucket must exist and grant WRITE and READ_ACP
         * permissions to the AWS account <code>vm-import-export@amazon.com</code>.
         * </p>
         * 
         * @param s3Bucket
         *        The S3 bucket for the destination image. The destination bucket must exist and grant WRITE and
         *        READ_ACP permissions to the AWS account <code>vm-import-export@amazon.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The encryption key for your S3 bucket.
         * </p>
         * 
         * @param s3Key
         *        The encryption key for your S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Key(String s3Key);
    }

    private static final class BuilderImpl implements Builder {
        private String containerFormat;

        private String diskImageFormat;

        private String s3Bucket;

        private String s3Key;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportToS3Task model) {
            setContainerFormat(model.containerFormat);
            setDiskImageFormat(model.diskImageFormat);
            setS3Bucket(model.s3Bucket);
            setS3Key(model.s3Key);
        }

        public final String getContainerFormat() {
            return containerFormat;
        }

        @Override
        public final Builder containerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
            return this;
        }

        @Override
        public final Builder containerFormat(ContainerFormat containerFormat) {
            this.containerFormat(containerFormat.toString());
            return this;
        }

        public final void setContainerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
        }

        public final void setContainerFormat(ContainerFormat containerFormat) {
            this.containerFormat(containerFormat.toString());
        }

        public final String getDiskImageFormat() {
            return diskImageFormat;
        }

        @Override
        public final Builder diskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
            return this;
        }

        @Override
        public final Builder diskImageFormat(DiskImageFormat diskImageFormat) {
            this.diskImageFormat(diskImageFormat.toString());
            return this;
        }

        public final void setDiskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
        }

        public final void setDiskImageFormat(DiskImageFormat diskImageFormat) {
            this.diskImageFormat(diskImageFormat.toString());
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Key() {
            return s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        @Override
        public ExportToS3Task build() {
            return new ExportToS3Task(this);
        }
    }
}
