/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an event in the history of the Spot fleet request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class HistoryRecord implements ToCopyableBuilder<HistoryRecord.Builder, HistoryRecord> {
    private final EventInformation eventInformation;

    private final String eventType;

    private final Instant timestamp;

    private HistoryRecord(BuilderImpl builder) {
        this.eventInformation = builder.eventInformation;
        this.eventType = builder.eventType;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * Information about the event.
     * </p>
     * 
     * @return Information about the event.
     */
    public EventInformation eventInformation() {
        return eventInformation;
    }

    /**
     * <p>
     * The event type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>error</code> - Indicates an error with the Spot fleet request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fleetRequestChange</code> - Indicates a change in the status or configuration of the Spot fleet request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instanceChange</code> - Indicates that an instance was launched or terminated.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The event type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>error</code> - Indicates an error with the Spot fleet request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fleetRequestChange</code> - Indicates a change in the status or configuration of the Spot fleet
     *         request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instanceChange</code> - Indicates that an instance was launched or terminated.
     *         </p>
     *         </li>
     * @see EventType
     */
    public String eventType() {
        return eventType;
    }

    /**
     * <p>
     * The date and time of the event, in UTC format (for example,
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     * </p>
     * 
     * @return The date and time of the event, in UTC format (for example,
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     */
    public Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((eventInformation() == null) ? 0 : eventInformation().hashCode());
        hashCode = 31 * hashCode + ((eventType() == null) ? 0 : eventType().hashCode());
        hashCode = 31 * hashCode + ((timestamp() == null) ? 0 : timestamp().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoryRecord)) {
            return false;
        }
        HistoryRecord other = (HistoryRecord) obj;
        if (other.eventInformation() == null ^ this.eventInformation() == null) {
            return false;
        }
        if (other.eventInformation() != null && !other.eventInformation().equals(this.eventInformation())) {
            return false;
        }
        if (other.eventType() == null ^ this.eventType() == null) {
            return false;
        }
        if (other.eventType() != null && !other.eventType().equals(this.eventType())) {
            return false;
        }
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (eventInformation() != null) {
            sb.append("EventInformation: ").append(eventInformation()).append(",");
        }
        if (eventType() != null) {
            sb.append("EventType: ").append(eventType()).append(",");
        }
        if (timestamp() != null) {
            sb.append("Timestamp: ").append(timestamp()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, HistoryRecord> {
        /**
         * <p>
         * Information about the event.
         * </p>
         * 
         * @param eventInformation
         *        Information about the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventInformation(EventInformation eventInformation);

        /**
         * <p>
         * The event type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>error</code> - Indicates an error with the Spot fleet request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fleetRequestChange</code> - Indicates a change in the status or configuration of the Spot fleet
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instanceChange</code> - Indicates that an instance was launched or terminated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param eventType
         *        The event type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>error</code> - Indicates an error with the Spot fleet request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fleetRequestChange</code> - Indicates a change in the status or configuration of the Spot fleet
         *        request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instanceChange</code> - Indicates that an instance was launched or terminated.
         *        </p>
         *        </li>
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The event type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>error</code> - Indicates an error with the Spot fleet request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fleetRequestChange</code> - Indicates a change in the status or configuration of the Spot fleet
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instanceChange</code> - Indicates that an instance was launched or terminated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param eventType
         *        The event type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>error</code> - Indicates an error with the Spot fleet request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fleetRequestChange</code> - Indicates a change in the status or configuration of the Spot fleet
         *        request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instanceChange</code> - Indicates that an instance was launched or terminated.
         *        </p>
         *        </li>
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(EventType eventType);

        /**
         * <p>
         * The date and time of the event, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * </p>
         * 
         * @param timestamp
         *        The date and time of the event, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    private static final class BuilderImpl implements Builder {
        private EventInformation eventInformation;

        private String eventType;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(HistoryRecord model) {
            setEventInformation(model.eventInformation);
            setEventType(model.eventType);
            setTimestamp(model.timestamp);
        }

        public final EventInformation getEventInformation() {
            return eventInformation;
        }

        @Override
        public final Builder eventInformation(EventInformation eventInformation) {
            this.eventInformation = eventInformation;
            return this;
        }

        public final void setEventInformation(EventInformation eventInformation) {
            this.eventInformation = eventInformation;
        }

        public final String getEventType() {
            return eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType.toString());
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final void setEventType(EventType eventType) {
            this.eventType(eventType.toString());
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public HistoryRecord build() {
            return new HistoryRecord(this);
        }
    }
}
