/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Image implements ToCopyableBuilder<Image.Builder, Image> {
    private final String architecture;

    private final String creationDate;

    private final String imageId;

    private final String imageLocation;

    private final String imageType;

    private final String kernelId;

    private final String ownerId;

    private final String platform;

    private final List<ProductCode> productCodes;

    private final String ramdiskId;

    private final String state;

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final String description;

    private final Boolean enaSupport;

    private final String hypervisor;

    private final String imageOwnerAlias;

    private final String name;

    private final String rootDeviceName;

    private final String rootDeviceType;

    private final String sriovNetSupport;

    private final StateReason stateReason;

    private final List<Tag> tags;

    private final String virtualizationType;

    private final Boolean publicLaunchPermissions;

    private Image(BuilderImpl builder) {
        this.architecture = builder.architecture;
        this.creationDate = builder.creationDate;
        this.imageId = builder.imageId;
        this.imageLocation = builder.imageLocation;
        this.imageType = builder.imageType;
        this.kernelId = builder.kernelId;
        this.ownerId = builder.ownerId;
        this.platform = builder.platform;
        this.productCodes = builder.productCodes;
        this.ramdiskId = builder.ramdiskId;
        this.state = builder.state;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.description = builder.description;
        this.enaSupport = builder.enaSupport;
        this.hypervisor = builder.hypervisor;
        this.imageOwnerAlias = builder.imageOwnerAlias;
        this.name = builder.name;
        this.rootDeviceName = builder.rootDeviceName;
        this.rootDeviceType = builder.rootDeviceType;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.stateReason = builder.stateReason;
        this.tags = builder.tags;
        this.virtualizationType = builder.virtualizationType;
        this.publicLaunchPermissions = builder.publicLaunchPermissions;
    }

    /**
     * <p>
     * The architecture of the image.
     * </p>
     * 
     * @return The architecture of the image.
     * @see ArchitectureValues
     */
    public String architecture() {
        return architecture;
    }

    /**
     * <p>
     * The date and time the image was created.
     * </p>
     * 
     * @return The date and time the image was created.
     */
    public String creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The location of the AMI.
     * </p>
     * 
     * @return The location of the AMI.
     */
    public String imageLocation() {
        return imageLocation;
    }

    /**
     * <p>
     * The type of image.
     * </p>
     * 
     * @return The type of image.
     * @see ImageTypeValues
     */
    public String imageType() {
        return imageType;
    }

    /**
     * <p>
     * The kernel associated with the image, if any. Only applicable for machine images.
     * </p>
     * 
     * @return The kernel associated with the image, if any. Only applicable for machine images.
     */
    public String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The AWS account ID of the image owner.
     * </p>
     * 
     * @return The AWS account ID of the image owner.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The value is <code>Windows</code> for Windows AMIs; otherwise blank.
     * </p>
     * 
     * @return The value is <code>Windows</code> for Windows AMIs; otherwise blank.
     * @see PlatformValues
     */
    public String platform() {
        return platform;
    }

    /**
     * <p>
     * Any product codes associated with the AMI.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any product codes associated with the AMI.
     */
    public List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * The RAM disk associated with the image, if any. Only applicable for machine images.
     * </p>
     * 
     * @return The RAM disk associated with the image, if any. Only applicable for machine images.
     */
    public String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * The current state of the AMI. If the state is <code>available</code>, the image is successfully registered and
     * can be used to launch an instance.
     * </p>
     * 
     * @return The current state of the AMI. If the state is <code>available</code>, the image is successfully
     *         registered and can be used to launch an instance.
     * @see ImageState
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * Any block device mapping entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any block device mapping entries.
     */
    public List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * The description of the AMI that was provided during image creation.
     * </p>
     * 
     * @return The description of the AMI that was provided during image creation.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether enhanced networking with ENA is enabled.
     * </p>
     * 
     * @return Specifies whether enhanced networking with ENA is enabled.
     */
    public Boolean enaSupport() {
        return enaSupport;
    }

    /**
     * <p>
     * The hypervisor type of the image.
     * </p>
     * 
     * @return The hypervisor type of the image.
     * @see HypervisorType
     */
    public String hypervisor() {
        return hypervisor;
    }

    /**
     * <p>
     * The AWS account alias (for example, <code>amazon</code>, <code>self</code>) or the AWS account ID of the AMI
     * owner.
     * </p>
     * 
     * @return The AWS account alias (for example, <code>amazon</code>, <code>self</code>) or the AWS account ID of the
     *         AMI owner.
     */
    public String imageOwnerAlias() {
        return imageOwnerAlias;
    }

    /**
     * <p>
     * The name of the AMI that was provided during image creation.
     * </p>
     * 
     * @return The name of the AMI that was provided during image creation.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The device name of the root device (for example, <code>/dev/sda1</code> or <code>/dev/xvda</code>).
     * </p>
     * 
     * @return The device name of the root device (for example, <code>/dev/sda1</code> or <code>/dev/xvda</code>).
     */
    public String rootDeviceName() {
        return rootDeviceName;
    }

    /**
     * <p>
     * The type of root device used by the AMI. The AMI can use an EBS volume or an instance store volume.
     * </p>
     * 
     * @return The type of root device used by the AMI. The AMI can use an EBS volume or an instance store volume.
     * @see DeviceType
     */
    public String rootDeviceType() {
        return rootDeviceType;
    }

    /**
     * <p>
     * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     * </p>
     * 
     * @return Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     */
    public String sriovNetSupport() {
        return sriovNetSupport;
    }

    /**
     * <p>
     * The reason for the state change.
     * </p>
     * 
     * @return The reason for the state change.
     */
    public StateReason stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * Any tags assigned to the image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the image.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The type of virtualization of the AMI.
     * </p>
     * 
     * @return The type of virtualization of the AMI.
     * @see VirtualizationType
     */
    public String virtualizationType() {
        return virtualizationType;
    }

    /**
     * <p>
     * Indicates whether the image has public launch permissions. The value is <code>true</code> if this image has
     * public launch permissions or <code>false</code> if it has only implicit and explicit launch permissions.
     * </p>
     * 
     * @return Indicates whether the image has public launch permissions. The value is <code>true</code> if this image
     *         has public launch permissions or <code>false</code> if it has only implicit and explicit launch
     *         permissions.
     */
    public Boolean publicLaunchPermissions() {
        return publicLaunchPermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((architecture() == null) ? 0 : architecture().hashCode());
        hashCode = 31 * hashCode + ((creationDate() == null) ? 0 : creationDate().hashCode());
        hashCode = 31 * hashCode + ((imageId() == null) ? 0 : imageId().hashCode());
        hashCode = 31 * hashCode + ((imageLocation() == null) ? 0 : imageLocation().hashCode());
        hashCode = 31 * hashCode + ((imageType() == null) ? 0 : imageType().hashCode());
        hashCode = 31 * hashCode + ((kernelId() == null) ? 0 : kernelId().hashCode());
        hashCode = 31 * hashCode + ((ownerId() == null) ? 0 : ownerId().hashCode());
        hashCode = 31 * hashCode + ((platform() == null) ? 0 : platform().hashCode());
        hashCode = 31 * hashCode + ((productCodes() == null) ? 0 : productCodes().hashCode());
        hashCode = 31 * hashCode + ((ramdiskId() == null) ? 0 : ramdiskId().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((blockDeviceMappings() == null) ? 0 : blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((enaSupport() == null) ? 0 : enaSupport().hashCode());
        hashCode = 31 * hashCode + ((hypervisor() == null) ? 0 : hypervisor().hashCode());
        hashCode = 31 * hashCode + ((imageOwnerAlias() == null) ? 0 : imageOwnerAlias().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((rootDeviceName() == null) ? 0 : rootDeviceName().hashCode());
        hashCode = 31 * hashCode + ((rootDeviceType() == null) ? 0 : rootDeviceType().hashCode());
        hashCode = 31 * hashCode + ((sriovNetSupport() == null) ? 0 : sriovNetSupport().hashCode());
        hashCode = 31 * hashCode + ((stateReason() == null) ? 0 : stateReason().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        hashCode = 31 * hashCode + ((virtualizationType() == null) ? 0 : virtualizationType().hashCode());
        hashCode = 31 * hashCode + ((publicLaunchPermissions() == null) ? 0 : publicLaunchPermissions().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image) obj;
        if (other.architecture() == null ^ this.architecture() == null) {
            return false;
        }
        if (other.architecture() != null && !other.architecture().equals(this.architecture())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.imageLocation() == null ^ this.imageLocation() == null) {
            return false;
        }
        if (other.imageLocation() != null && !other.imageLocation().equals(this.imageLocation())) {
            return false;
        }
        if (other.imageType() == null ^ this.imageType() == null) {
            return false;
        }
        if (other.imageType() != null && !other.imageType().equals(this.imageType())) {
            return false;
        }
        if (other.kernelId() == null ^ this.kernelId() == null) {
            return false;
        }
        if (other.kernelId() != null && !other.kernelId().equals(this.kernelId())) {
            return false;
        }
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.productCodes() == null ^ this.productCodes() == null) {
            return false;
        }
        if (other.productCodes() != null && !other.productCodes().equals(this.productCodes())) {
            return false;
        }
        if (other.ramdiskId() == null ^ this.ramdiskId() == null) {
            return false;
        }
        if (other.ramdiskId() != null && !other.ramdiskId().equals(this.ramdiskId())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.enaSupport() == null ^ this.enaSupport() == null) {
            return false;
        }
        if (other.enaSupport() != null && !other.enaSupport().equals(this.enaSupport())) {
            return false;
        }
        if (other.hypervisor() == null ^ this.hypervisor() == null) {
            return false;
        }
        if (other.hypervisor() != null && !other.hypervisor().equals(this.hypervisor())) {
            return false;
        }
        if (other.imageOwnerAlias() == null ^ this.imageOwnerAlias() == null) {
            return false;
        }
        if (other.imageOwnerAlias() != null && !other.imageOwnerAlias().equals(this.imageOwnerAlias())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.rootDeviceName() == null ^ this.rootDeviceName() == null) {
            return false;
        }
        if (other.rootDeviceName() != null && !other.rootDeviceName().equals(this.rootDeviceName())) {
            return false;
        }
        if (other.rootDeviceType() == null ^ this.rootDeviceType() == null) {
            return false;
        }
        if (other.rootDeviceType() != null && !other.rootDeviceType().equals(this.rootDeviceType())) {
            return false;
        }
        if (other.sriovNetSupport() == null ^ this.sriovNetSupport() == null) {
            return false;
        }
        if (other.sriovNetSupport() != null && !other.sriovNetSupport().equals(this.sriovNetSupport())) {
            return false;
        }
        if (other.stateReason() == null ^ this.stateReason() == null) {
            return false;
        }
        if (other.stateReason() != null && !other.stateReason().equals(this.stateReason())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.virtualizationType() == null ^ this.virtualizationType() == null) {
            return false;
        }
        if (other.virtualizationType() != null && !other.virtualizationType().equals(this.virtualizationType())) {
            return false;
        }
        if (other.publicLaunchPermissions() == null ^ this.publicLaunchPermissions() == null) {
            return false;
        }
        if (other.publicLaunchPermissions() != null && !other.publicLaunchPermissions().equals(this.publicLaunchPermissions())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (architecture() != null) {
            sb.append("Architecture: ").append(architecture()).append(",");
        }
        if (creationDate() != null) {
            sb.append("CreationDate: ").append(creationDate()).append(",");
        }
        if (imageId() != null) {
            sb.append("ImageId: ").append(imageId()).append(",");
        }
        if (imageLocation() != null) {
            sb.append("ImageLocation: ").append(imageLocation()).append(",");
        }
        if (imageType() != null) {
            sb.append("ImageType: ").append(imageType()).append(",");
        }
        if (kernelId() != null) {
            sb.append("KernelId: ").append(kernelId()).append(",");
        }
        if (ownerId() != null) {
            sb.append("OwnerId: ").append(ownerId()).append(",");
        }
        if (platform() != null) {
            sb.append("Platform: ").append(platform()).append(",");
        }
        if (productCodes() != null) {
            sb.append("ProductCodes: ").append(productCodes()).append(",");
        }
        if (ramdiskId() != null) {
            sb.append("RamdiskId: ").append(ramdiskId()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(blockDeviceMappings()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (enaSupport() != null) {
            sb.append("EnaSupport: ").append(enaSupport()).append(",");
        }
        if (hypervisor() != null) {
            sb.append("Hypervisor: ").append(hypervisor()).append(",");
        }
        if (imageOwnerAlias() != null) {
            sb.append("ImageOwnerAlias: ").append(imageOwnerAlias()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (rootDeviceName() != null) {
            sb.append("RootDeviceName: ").append(rootDeviceName()).append(",");
        }
        if (rootDeviceType() != null) {
            sb.append("RootDeviceType: ").append(rootDeviceType()).append(",");
        }
        if (sriovNetSupport() != null) {
            sb.append("SriovNetSupport: ").append(sriovNetSupport()).append(",");
        }
        if (stateReason() != null) {
            sb.append("StateReason: ").append(stateReason()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (virtualizationType() != null) {
            sb.append("VirtualizationType: ").append(virtualizationType()).append(",");
        }
        if (publicLaunchPermissions() != null) {
            sb.append("PublicLaunchPermissions: ").append(publicLaunchPermissions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Image> {
        /**
         * <p>
         * The architecture of the image.
         * </p>
         * 
         * @param architecture
         *        The architecture of the image.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The architecture of the image.
         * </p>
         * 
         * @param architecture
         *        The architecture of the image.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(ArchitectureValues architecture);

        /**
         * <p>
         * The date and time the image was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time the image was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * The ID of the AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The location of the AMI.
         * </p>
         * 
         * @param imageLocation
         *        The location of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageLocation(String imageLocation);

        /**
         * <p>
         * The type of image.
         * </p>
         * 
         * @param imageType
         *        The type of image.
         * @see ImageTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageTypeValues
         */
        Builder imageType(String imageType);

        /**
         * <p>
         * The type of image.
         * </p>
         * 
         * @param imageType
         *        The type of image.
         * @see ImageTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageTypeValues
         */
        Builder imageType(ImageTypeValues imageType);

        /**
         * <p>
         * The kernel associated with the image, if any. Only applicable for machine images.
         * </p>
         * 
         * @param kernelId
         *        The kernel associated with the image, if any. Only applicable for machine images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The AWS account ID of the image owner.
         * </p>
         * 
         * @param ownerId
         *        The AWS account ID of the image owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The value is <code>Windows</code> for Windows AMIs; otherwise blank.
         * </p>
         * 
         * @param platform
         *        The value is <code>Windows</code> for Windows AMIs; otherwise blank.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(String platform);

        /**
         * <p>
         * The value is <code>Windows</code> for Windows AMIs; otherwise blank.
         * </p>
         * 
         * @param platform
         *        The value is <code>Windows</code> for Windows AMIs; otherwise blank.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(PlatformValues platform);

        /**
         * <p>
         * Any product codes associated with the AMI.
         * </p>
         * 
         * @param productCodes
         *        Any product codes associated with the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * Any product codes associated with the AMI.
         * </p>
         * 
         * @param productCodes
         *        Any product codes associated with the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * The RAM disk associated with the image, if any. Only applicable for machine images.
         * </p>
         * 
         * @param ramdiskId
         *        The RAM disk associated with the image, if any. Only applicable for machine images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * The current state of the AMI. If the state is <code>available</code>, the image is successfully registered
         * and can be used to launch an instance.
         * </p>
         * 
         * @param state
         *        The current state of the AMI. If the state is <code>available</code>, the image is successfully
         *        registered and can be used to launch an instance.
         * @see ImageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the AMI. If the state is <code>available</code>, the image is successfully registered
         * and can be used to launch an instance.
         * </p>
         * 
         * @param state
         *        The current state of the AMI. If the state is <code>available</code>, the image is successfully
         *        registered and can be used to launch an instance.
         * @see ImageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageState
         */
        Builder state(ImageState state);

        /**
         * <p>
         * Any block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Any block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * Any block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Any block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * The description of the AMI that was provided during image creation.
         * </p>
         * 
         * @param description
         *        The description of the AMI that was provided during image creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether enhanced networking with ENA is enabled.
         * </p>
         * 
         * @param enaSupport
         *        Specifies whether enhanced networking with ENA is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSupport(Boolean enaSupport);

        /**
         * <p>
         * The hypervisor type of the image.
         * </p>
         * 
         * @param hypervisor
         *        The hypervisor type of the image.
         * @see HypervisorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HypervisorType
         */
        Builder hypervisor(String hypervisor);

        /**
         * <p>
         * The hypervisor type of the image.
         * </p>
         * 
         * @param hypervisor
         *        The hypervisor type of the image.
         * @see HypervisorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HypervisorType
         */
        Builder hypervisor(HypervisorType hypervisor);

        /**
         * <p>
         * The AWS account alias (for example, <code>amazon</code>, <code>self</code>) or the AWS account ID of the AMI
         * owner.
         * </p>
         * 
         * @param imageOwnerAlias
         *        The AWS account alias (for example, <code>amazon</code>, <code>self</code>) or the AWS account ID of
         *        the AMI owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageOwnerAlias(String imageOwnerAlias);

        /**
         * <p>
         * The name of the AMI that was provided during image creation.
         * </p>
         * 
         * @param name
         *        The name of the AMI that was provided during image creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The device name of the root device (for example, <code>/dev/sda1</code> or <code>/dev/xvda</code>).
         * </p>
         * 
         * @param rootDeviceName
         *        The device name of the root device (for example, <code>/dev/sda1</code> or <code>/dev/xvda</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDeviceName(String rootDeviceName);

        /**
         * <p>
         * The type of root device used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * </p>
         * 
         * @param rootDeviceType
         *        The type of root device used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder rootDeviceType(String rootDeviceType);

        /**
         * <p>
         * The type of root device used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * </p>
         * 
         * @param rootDeviceType
         *        The type of root device used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder rootDeviceType(DeviceType rootDeviceType);

        /**
         * <p>
         * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * </p>
         * 
         * @param sriovNetSupport
         *        Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sriovNetSupport(String sriovNetSupport);

        /**
         * <p>
         * The reason for the state change.
         * </p>
         * 
         * @param stateReason
         *        The reason for the state change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(StateReason stateReason);

        /**
         * <p>
         * Any tags assigned to the image.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the image.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The type of virtualization of the AMI.
         * </p>
         * 
         * @param virtualizationType
         *        The type of virtualization of the AMI.
         * @see VirtualizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualizationType
         */
        Builder virtualizationType(String virtualizationType);

        /**
         * <p>
         * The type of virtualization of the AMI.
         * </p>
         * 
         * @param virtualizationType
         *        The type of virtualization of the AMI.
         * @see VirtualizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualizationType
         */
        Builder virtualizationType(VirtualizationType virtualizationType);

        /**
         * <p>
         * Indicates whether the image has public launch permissions. The value is <code>true</code> if this image has
         * public launch permissions or <code>false</code> if it has only implicit and explicit launch permissions.
         * </p>
         * 
         * @param publicLaunchPermissions
         *        Indicates whether the image has public launch permissions. The value is <code>true</code> if this
         *        image has public launch permissions or <code>false</code> if it has only implicit and explicit launch
         *        permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicLaunchPermissions(Boolean publicLaunchPermissions);
    }

    private static final class BuilderImpl implements Builder {
        private String architecture;

        private String creationDate;

        private String imageId;

        private String imageLocation;

        private String imageType;

        private String kernelId;

        private String ownerId;

        private String platform;

        private List<ProductCode> productCodes;

        private String ramdiskId;

        private String state;

        private List<BlockDeviceMapping> blockDeviceMappings;

        private String description;

        private Boolean enaSupport;

        private String hypervisor;

        private String imageOwnerAlias;

        private String name;

        private String rootDeviceName;

        private String rootDeviceType;

        private String sriovNetSupport;

        private StateReason stateReason;

        private List<Tag> tags;

        private String virtualizationType;

        private Boolean publicLaunchPermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            setArchitecture(model.architecture);
            setCreationDate(model.creationDate);
            setImageId(model.imageId);
            setImageLocation(model.imageLocation);
            setImageType(model.imageType);
            setKernelId(model.kernelId);
            setOwnerId(model.ownerId);
            setPlatform(model.platform);
            setProductCodes(model.productCodes);
            setRamdiskId(model.ramdiskId);
            setState(model.state);
            setBlockDeviceMappings(model.blockDeviceMappings);
            setDescription(model.description);
            setEnaSupport(model.enaSupport);
            setHypervisor(model.hypervisor);
            setImageOwnerAlias(model.imageOwnerAlias);
            setName(model.name);
            setRootDeviceName(model.rootDeviceName);
            setRootDeviceType(model.rootDeviceType);
            setSriovNetSupport(model.sriovNetSupport);
            setStateReason(model.stateReason);
            setTags(model.tags);
            setVirtualizationType(model.virtualizationType);
            setPublicLaunchPermissions(model.publicLaunchPermissions);
        }

        public final String getArchitecture() {
            return architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final void setArchitecture(ArchitectureValues architecture) {
            this.architecture(architecture.toString());
        }

        public final String getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getImageLocation() {
            return imageLocation;
        }

        @Override
        public final Builder imageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
            return this;
        }

        public final void setImageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
        }

        public final String getImageType() {
            return imageType;
        }

        @Override
        public final Builder imageType(String imageType) {
            this.imageType = imageType;
            return this;
        }

        @Override
        public final Builder imageType(ImageTypeValues imageType) {
            this.imageType(imageType.toString());
            return this;
        }

        public final void setImageType(String imageType) {
            this.imageType = imageType;
        }

        public final void setImageType(ImageTypeValues imageType) {
            this.imageType(imageType.toString());
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final void setPlatform(PlatformValues platform) {
            this.platform(platform.toString());
        }

        public final Collection<ProductCode> getProductCodes() {
            return productCodes;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
        }

        @SafeVarargs
        public final void setProductCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ImageState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(ImageState state) {
            this.state(state.toString());
        }

        public final Collection<BlockDeviceMapping> getBlockDeviceMappings() {
            return blockDeviceMappings;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
        }

        @SafeVarargs
        public final void setBlockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getEnaSupport() {
            return enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        public final String getHypervisor() {
            return hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        @Override
        public final Builder hypervisor(HypervisorType hypervisor) {
            this.hypervisor(hypervisor.toString());
            return this;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        public final void setHypervisor(HypervisorType hypervisor) {
            this.hypervisor(hypervisor.toString());
        }

        public final String getImageOwnerAlias() {
            return imageOwnerAlias;
        }

        @Override
        public final Builder imageOwnerAlias(String imageOwnerAlias) {
            this.imageOwnerAlias = imageOwnerAlias;
            return this;
        }

        public final void setImageOwnerAlias(String imageOwnerAlias) {
            this.imageOwnerAlias = imageOwnerAlias;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRootDeviceName() {
            return rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        public final String getRootDeviceType() {
            return rootDeviceType;
        }

        @Override
        public final Builder rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        @Override
        public final Builder rootDeviceType(DeviceType rootDeviceType) {
            this.rootDeviceType(rootDeviceType.toString());
            return this;
        }

        public final void setRootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
        }

        public final void setRootDeviceType(DeviceType rootDeviceType) {
            this.rootDeviceType(rootDeviceType.toString());
        }

        public final String getSriovNetSupport() {
            return sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        public final StateReason getStateReason() {
            return stateReason;
        }

        @Override
        public final Builder stateReason(StateReason stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(StateReason stateReason) {
            this.stateReason = stateReason;
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag... tags) {
            tags(Arrays.asList(tags));
        }

        public final String getVirtualizationType() {
            return virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        @Override
        public final Builder virtualizationType(VirtualizationType virtualizationType) {
            this.virtualizationType(virtualizationType.toString());
            return this;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        public final void setVirtualizationType(VirtualizationType virtualizationType) {
            this.virtualizationType(virtualizationType.toString());
        }

        public final Boolean getPublicLaunchPermissions() {
            return publicLaunchPermissions;
        }

        @Override
        public final Builder publicLaunchPermissions(Boolean publicLaunchPermissions) {
            this.publicLaunchPermissions = publicLaunchPermissions;
            return this;
        }

        public final void setPublicLaunchPermissions(Boolean publicLaunchPermissions) {
            this.publicLaunchPermissions = publicLaunchPermissions;
        }

        @Override
        public Image build() {
            return new Image(this);
        }
    }
}
