/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ImportImage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImportImageRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ImportImageRequest.Builder, ImportImageRequest> {
    private final String architecture;

    private final ClientData clientData;

    private final String clientToken;

    private final String description;

    private final List<ImageDiskContainer> diskContainers;

    private final String hypervisor;

    private final String licenseType;

    private final String platform;

    private final String roleName;

    private ImportImageRequest(BuilderImpl builder) {
        this.architecture = builder.architecture;
        this.clientData = builder.clientData;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.diskContainers = builder.diskContainers;
        this.hypervisor = builder.hypervisor;
        this.licenseType = builder.licenseType;
        this.platform = builder.platform;
        this.roleName = builder.roleName;
    }

    /**
     * <p>
     * The architecture of the virtual machine.
     * </p>
     * <p>
     * Valid values: <code>i386</code> | <code>x86_64</code>
     * </p>
     * 
     * @return The architecture of the virtual machine.</p>
     *         <p>
     *         Valid values: <code>i386</code> | <code>x86_64</code>
     */
    public String architecture() {
        return architecture;
    }

    /**
     * <p>
     * The client-specific data.
     * </p>
     * 
     * @return The client-specific data.
     */
    public ClientData clientData() {
        return clientData;
    }

    /**
     * <p>
     * The token to enable idempotency for VM import requests.
     * </p>
     * 
     * @return The token to enable idempotency for VM import requests.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A description string for the import image task.
     * </p>
     * 
     * @return A description string for the import image task.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Information about the disk containers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the disk containers.
     */
    public List<ImageDiskContainer> diskContainers() {
        return diskContainers;
    }

    /**
     * <p>
     * The target hypervisor platform.
     * </p>
     * <p>
     * Valid values: <code>xen</code>
     * </p>
     * 
     * @return The target hypervisor platform.</p>
     *         <p>
     *         Valid values: <code>xen</code>
     */
    public String hypervisor() {
        return hypervisor;
    }

    /**
     * <p>
     * The license type to be used for the Amazon Machine Image (AMI) after importing.
     * </p>
     * <p>
     * <b>Note:</b> You may only use BYOL if you have existing licenses with rights to use these licenses in a third
     * party cloud like AWS. For more information, see <a
     * href="http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#prerequisites-image"
     * >Prerequisites</a> in the VM Import/Export User Guide.
     * </p>
     * <p>
     * Valid values: <code>AWS</code> | <code>BYOL</code>
     * </p>
     * 
     * @return The license type to be used for the Amazon Machine Image (AMI) after importing.</p>
     *         <p>
     *         <b>Note:</b> You may only use BYOL if you have existing licenses with rights to use these licenses in a
     *         third party cloud like AWS. For more information, see <a href=
     *         "http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#prerequisites-image"
     *         >Prerequisites</a> in the VM Import/Export User Guide.
     *         </p>
     *         <p>
     *         Valid values: <code>AWS</code> | <code>BYOL</code>
     */
    public String licenseType() {
        return licenseType;
    }

    /**
     * <p>
     * The operating system of the virtual machine.
     * </p>
     * <p>
     * Valid values: <code>Windows</code> | <code>Linux</code>
     * </p>
     * 
     * @return The operating system of the virtual machine.</p>
     *         <p>
     *         Valid values: <code>Windows</code> | <code>Linux</code>
     */
    public String platform() {
        return platform;
    }

    /**
     * <p>
     * The name of the role to use when not using the default role, 'vmimport'.
     * </p>
     * 
     * @return The name of the role to use when not using the default role, 'vmimport'.
     */
    public String roleName() {
        return roleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((architecture() == null) ? 0 : architecture().hashCode());
        hashCode = 31 * hashCode + ((clientData() == null) ? 0 : clientData().hashCode());
        hashCode = 31 * hashCode + ((clientToken() == null) ? 0 : clientToken().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((diskContainers() == null) ? 0 : diskContainers().hashCode());
        hashCode = 31 * hashCode + ((hypervisor() == null) ? 0 : hypervisor().hashCode());
        hashCode = 31 * hashCode + ((licenseType() == null) ? 0 : licenseType().hashCode());
        hashCode = 31 * hashCode + ((platform() == null) ? 0 : platform().hashCode());
        hashCode = 31 * hashCode + ((roleName() == null) ? 0 : roleName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportImageRequest)) {
            return false;
        }
        ImportImageRequest other = (ImportImageRequest) obj;
        if (other.architecture() == null ^ this.architecture() == null) {
            return false;
        }
        if (other.architecture() != null && !other.architecture().equals(this.architecture())) {
            return false;
        }
        if (other.clientData() == null ^ this.clientData() == null) {
            return false;
        }
        if (other.clientData() != null && !other.clientData().equals(this.clientData())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.diskContainers() == null ^ this.diskContainers() == null) {
            return false;
        }
        if (other.diskContainers() != null && !other.diskContainers().equals(this.diskContainers())) {
            return false;
        }
        if (other.hypervisor() == null ^ this.hypervisor() == null) {
            return false;
        }
        if (other.hypervisor() != null && !other.hypervisor().equals(this.hypervisor())) {
            return false;
        }
        if (other.licenseType() == null ^ this.licenseType() == null) {
            return false;
        }
        if (other.licenseType() != null && !other.licenseType().equals(this.licenseType())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.roleName() == null ^ this.roleName() == null) {
            return false;
        }
        if (other.roleName() != null && !other.roleName().equals(this.roleName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (architecture() != null) {
            sb.append("Architecture: ").append(architecture()).append(",");
        }
        if (clientData() != null) {
            sb.append("ClientData: ").append(clientData()).append(",");
        }
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (diskContainers() != null) {
            sb.append("DiskContainers: ").append(diskContainers()).append(",");
        }
        if (hypervisor() != null) {
            sb.append("Hypervisor: ").append(hypervisor()).append(",");
        }
        if (licenseType() != null) {
            sb.append("LicenseType: ").append(licenseType()).append(",");
        }
        if (platform() != null) {
            sb.append("Platform: ").append(platform()).append(",");
        }
        if (roleName() != null) {
            sb.append("RoleName: ").append(roleName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ImportImageRequest> {
        /**
         * <p>
         * The architecture of the virtual machine.
         * </p>
         * <p>
         * Valid values: <code>i386</code> | <code>x86_64</code>
         * </p>
         * 
         * @param architecture
         *        The architecture of the virtual machine.</p>
         *        <p>
         *        Valid values: <code>i386</code> | <code>x86_64</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The client-specific data.
         * </p>
         * 
         * @param clientData
         *        The client-specific data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientData(ClientData clientData);

        /**
         * <p>
         * The token to enable idempotency for VM import requests.
         * </p>
         * 
         * @param clientToken
         *        The token to enable idempotency for VM import requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A description string for the import image task.
         * </p>
         * 
         * @param description
         *        A description string for the import image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the disk containers.
         * </p>
         * 
         * @param diskContainers
         *        Information about the disk containers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskContainers(Collection<ImageDiskContainer> diskContainers);

        /**
         * <p>
         * Information about the disk containers.
         * </p>
         * 
         * @param diskContainers
         *        Information about the disk containers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskContainers(ImageDiskContainer... diskContainers);

        /**
         * <p>
         * The target hypervisor platform.
         * </p>
         * <p>
         * Valid values: <code>xen</code>
         * </p>
         * 
         * @param hypervisor
         *        The target hypervisor platform.</p>
         *        <p>
         *        Valid values: <code>xen</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hypervisor(String hypervisor);

        /**
         * <p>
         * The license type to be used for the Amazon Machine Image (AMI) after importing.
         * </p>
         * <p>
         * <b>Note:</b> You may only use BYOL if you have existing licenses with rights to use these licenses in a third
         * party cloud like AWS. For more information, see <a
         * href="http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#prerequisites-image"
         * >Prerequisites</a> in the VM Import/Export User Guide.
         * </p>
         * <p>
         * Valid values: <code>AWS</code> | <code>BYOL</code>
         * </p>
         * 
         * @param licenseType
         *        The license type to be used for the Amazon Machine Image (AMI) after importing.</p>
         *        <p>
         *        <b>Note:</b> You may only use BYOL if you have existing licenses with rights to use these licenses in
         *        a third party cloud like AWS. For more information, see <a href=
         *        "http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#prerequisites-image"
         *        >Prerequisites</a> in the VM Import/Export User Guide.
         *        </p>
         *        <p>
         *        Valid values: <code>AWS</code> | <code>BYOL</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseType(String licenseType);

        /**
         * <p>
         * The operating system of the virtual machine.
         * </p>
         * <p>
         * Valid values: <code>Windows</code> | <code>Linux</code>
         * </p>
         * 
         * @param platform
         *        The operating system of the virtual machine.</p>
         *        <p>
         *        Valid values: <code>Windows</code> | <code>Linux</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The name of the role to use when not using the default role, 'vmimport'.
         * </p>
         * 
         * @param roleName
         *        The name of the role to use when not using the default role, 'vmimport'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);
    }

    private static final class BuilderImpl implements Builder {
        private String architecture;

        private ClientData clientData;

        private String clientToken;

        private String description;

        private List<ImageDiskContainer> diskContainers;

        private String hypervisor;

        private String licenseType;

        private String platform;

        private String roleName;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportImageRequest model) {
            setArchitecture(model.architecture);
            setClientData(model.clientData);
            setClientToken(model.clientToken);
            setDescription(model.description);
            setDiskContainers(model.diskContainers);
            setHypervisor(model.hypervisor);
            setLicenseType(model.licenseType);
            setPlatform(model.platform);
            setRoleName(model.roleName);
        }

        public final String getArchitecture() {
            return architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final ClientData getClientData() {
            return clientData;
        }

        @Override
        public final Builder clientData(ClientData clientData) {
            this.clientData = clientData;
            return this;
        }

        public final void setClientData(ClientData clientData) {
            this.clientData = clientData;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<ImageDiskContainer> getDiskContainers() {
            return diskContainers;
        }

        @Override
        public final Builder diskContainers(Collection<ImageDiskContainer> diskContainers) {
            this.diskContainers = ImageDiskContainerListCopier.copy(diskContainers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskContainers(ImageDiskContainer... diskContainers) {
            diskContainers(Arrays.asList(diskContainers));
            return this;
        }

        public final void setDiskContainers(Collection<ImageDiskContainer> diskContainers) {
            this.diskContainers = ImageDiskContainerListCopier.copy(diskContainers);
        }

        @SafeVarargs
        public final void setDiskContainers(ImageDiskContainer... diskContainers) {
            diskContainers(Arrays.asList(diskContainers));
        }

        public final String getHypervisor() {
            return hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        public final String getLicenseType() {
            return licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getRoleName() {
            return roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public ImportImageRequest build() {
            return new ImportImageRequest(this);
        }
    }
}
