/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ImportKeyPair.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImportKeyPairRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ImportKeyPairRequest.Builder, ImportKeyPairRequest> {
    private final String keyName;

    private final String publicKeyMaterial;

    private ImportKeyPairRequest(BuilderImpl builder) {
        this.keyName = builder.keyName;
        this.publicKeyMaterial = builder.publicKeyMaterial;
    }

    /**
     * <p>
     * A unique name for the key pair.
     * </p>
     * 
     * @return A unique name for the key pair.
     */
    public String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The public key. For API calls, the text must be base64-encoded. For command line tools, base64 encoding is
     * performed for you.
     * </p>
     * 
     * @return The public key. For API calls, the text must be base64-encoded. For command line tools, base64 encoding
     *         is performed for you.
     */
    public String publicKeyMaterial() {
        return publicKeyMaterial;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((keyName() == null) ? 0 : keyName().hashCode());
        hashCode = 31 * hashCode + ((publicKeyMaterial() == null) ? 0 : publicKeyMaterial().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyPairRequest)) {
            return false;
        }
        ImportKeyPairRequest other = (ImportKeyPairRequest) obj;
        if (other.keyName() == null ^ this.keyName() == null) {
            return false;
        }
        if (other.keyName() != null && !other.keyName().equals(this.keyName())) {
            return false;
        }
        if (other.publicKeyMaterial() == null ^ this.publicKeyMaterial() == null) {
            return false;
        }
        if (other.publicKeyMaterial() != null && !other.publicKeyMaterial().equals(this.publicKeyMaterial())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (keyName() != null) {
            sb.append("KeyName: ").append(keyName()).append(",");
        }
        if (publicKeyMaterial() != null) {
            sb.append("PublicKeyMaterial: ").append(publicKeyMaterial()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ImportKeyPairRequest> {
        /**
         * <p>
         * A unique name for the key pair.
         * </p>
         * 
         * @param keyName
         *        A unique name for the key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The public key. For API calls, the text must be base64-encoded. For command line tools, base64 encoding is
         * performed for you.
         * </p>
         * 
         * @param publicKeyMaterial
         *        The public key. For API calls, the text must be base64-encoded. For command line tools, base64
         *        encoding is performed for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeyMaterial(String publicKeyMaterial);
    }

    private static final class BuilderImpl implements Builder {
        private String keyName;

        private String publicKeyMaterial;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportKeyPairRequest model) {
            setKeyName(model.keyName);
            setPublicKeyMaterial(model.publicKeyMaterial);
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final String getPublicKeyMaterial() {
            return publicKeyMaterial;
        }

        @Override
        public final Builder publicKeyMaterial(String publicKeyMaterial) {
            this.publicKeyMaterial = publicKeyMaterial;
            return this;
        }

        public final void setPublicKeyMaterial(String publicKeyMaterial) {
            this.publicKeyMaterial = publicKeyMaterial;
        }

        @Override
        public ImportKeyPairRequest build() {
            return new ImportKeyPairRequest(this);
        }
    }
}
