/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Reserved Instance listing state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceCount implements ToCopyableBuilder<InstanceCount.Builder, InstanceCount> {
    private final Integer instanceCount;

    private final String state;

    private InstanceCount(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.state = builder.state;
    }

    /**
     * <p>
     * The number of listed Reserved Instances in the state specified by the <code>state</code>.
     * </p>
     * 
     * @return The number of listed Reserved Instances in the state specified by the <code>state</code>.
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The states of the listed Reserved Instances.
     * </p>
     * 
     * @return The states of the listed Reserved Instances.
     * @see ListingState
     */
    public String state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceCount() == null) ? 0 : instanceCount().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCount)) {
            return false;
        }
        InstanceCount other = (InstanceCount) obj;
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceCount() != null) {
            sb.append("InstanceCount: ").append(instanceCount()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceCount> {
        /**
         * <p>
         * The number of listed Reserved Instances in the state specified by the <code>state</code>.
         * </p>
         * 
         * @param instanceCount
         *        The number of listed Reserved Instances in the state specified by the <code>state</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The states of the listed Reserved Instances.
         * </p>
         * 
         * @param state
         *        The states of the listed Reserved Instances.
         * @see ListingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListingState
         */
        Builder state(String state);

        /**
         * <p>
         * The states of the listed Reserved Instances.
         * </p>
         * 
         * @param state
         *        The states of the listed Reserved Instances.
         * @see ListingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListingState
         */
        Builder state(ListingState state);
    }

    private static final class BuilderImpl implements Builder {
        private Integer instanceCount;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCount model) {
            setInstanceCount(model.instanceCount);
            setState(model.state);
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ListingState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(ListingState state) {
            this.state(state.toString());
        }

        @Override
        public InstanceCount build() {
            return new InstanceCount(this);
        }
    }
}
