/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceNetworkInterface implements ToCopyableBuilder<InstanceNetworkInterface.Builder, InstanceNetworkInterface> {
    private final InstanceNetworkInterfaceAssociation association;

    private final InstanceNetworkInterfaceAttachment attachment;

    private final String description;

    private final List<GroupIdentifier> groups;

    private final List<InstanceIpv6Address> ipv6Addresses;

    private final String macAddress;

    private final String networkInterfaceId;

    private final String ownerId;

    private final String privateDnsName;

    private final String privateIpAddress;

    private final List<InstancePrivateIpAddress> privateIpAddresses;

    private final Boolean sourceDestCheck;

    private final String status;

    private final String subnetId;

    private final String vpcId;

    private InstanceNetworkInterface(BuilderImpl builder) {
        this.association = builder.association;
        this.attachment = builder.attachment;
        this.description = builder.description;
        this.groups = builder.groups;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.macAddress = builder.macAddress;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.ownerId = builder.ownerId;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.status = builder.status;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The association information for an Elastic IPv4 associated with the network interface.
     * </p>
     * 
     * @return The association information for an Elastic IPv4 associated with the network interface.
     */
    public InstanceNetworkInterfaceAssociation association() {
        return association;
    }

    /**
     * <p>
     * The network interface attachment.
     * </p>
     * 
     * @return The network interface attachment.
     */
    public InstanceNetworkInterfaceAttachment attachment() {
        return attachment;
    }

    /**
     * <p>
     * The description.
     * </p>
     * 
     * @return The description.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * One or more security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security groups.
     */
    public List<GroupIdentifier> groups() {
        return groups;
    }

    /**
     * <p>
     * One or more IPv6 addresses associated with the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more IPv6 addresses associated with the network interface.
     */
    public List<InstanceIpv6Address> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * The MAC address.
     * </p>
     * 
     * @return The MAC address.
     */
    public String macAddress() {
        return macAddress;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The ID of the AWS account that created the network interface.
     * </p>
     * 
     * @return The ID of the AWS account that created the network interface.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The private DNS name.
     * </p>
     * 
     * @return The private DNS name.
     */
    public String privateDnsName() {
        return privateDnsName;
    }

    /**
     * <p>
     * The IPv4 address of the network interface within the subnet.
     * </p>
     * 
     * @return The IPv4 address of the network interface within the subnet.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * One or more private IPv4 addresses associated with the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more private IPv4 addresses associated with the network interface.
     */
    public List<InstancePrivateIpAddress> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * <p>
     * Indicates whether to validate network traffic to or from this network interface.
     * </p>
     * 
     * @return Indicates whether to validate network traffic to or from this network interface.
     */
    public Boolean sourceDestCheck() {
        return sourceDestCheck;
    }

    /**
     * <p>
     * The status of the network interface.
     * </p>
     * 
     * @return The status of the network interface.
     * @see NetworkInterfaceStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((association() == null) ? 0 : association().hashCode());
        hashCode = 31 * hashCode + ((attachment() == null) ? 0 : attachment().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((groups() == null) ? 0 : groups().hashCode());
        hashCode = 31 * hashCode + ((ipv6Addresses() == null) ? 0 : ipv6Addresses().hashCode());
        hashCode = 31 * hashCode + ((macAddress() == null) ? 0 : macAddress().hashCode());
        hashCode = 31 * hashCode + ((networkInterfaceId() == null) ? 0 : networkInterfaceId().hashCode());
        hashCode = 31 * hashCode + ((ownerId() == null) ? 0 : ownerId().hashCode());
        hashCode = 31 * hashCode + ((privateDnsName() == null) ? 0 : privateDnsName().hashCode());
        hashCode = 31 * hashCode + ((privateIpAddress() == null) ? 0 : privateIpAddress().hashCode());
        hashCode = 31 * hashCode + ((privateIpAddresses() == null) ? 0 : privateIpAddresses().hashCode());
        hashCode = 31 * hashCode + ((sourceDestCheck() == null) ? 0 : sourceDestCheck().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((subnetId() == null) ? 0 : subnetId().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworkInterface)) {
            return false;
        }
        InstanceNetworkInterface other = (InstanceNetworkInterface) obj;
        if (other.association() == null ^ this.association() == null) {
            return false;
        }
        if (other.association() != null && !other.association().equals(this.association())) {
            return false;
        }
        if (other.attachment() == null ^ this.attachment() == null) {
            return false;
        }
        if (other.attachment() != null && !other.attachment().equals(this.attachment())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.groups() == null ^ this.groups() == null) {
            return false;
        }
        if (other.groups() != null && !other.groups().equals(this.groups())) {
            return false;
        }
        if (other.ipv6Addresses() == null ^ this.ipv6Addresses() == null) {
            return false;
        }
        if (other.ipv6Addresses() != null && !other.ipv6Addresses().equals(this.ipv6Addresses())) {
            return false;
        }
        if (other.macAddress() == null ^ this.macAddress() == null) {
            return false;
        }
        if (other.macAddress() != null && !other.macAddress().equals(this.macAddress())) {
            return false;
        }
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        if (other.networkInterfaceId() != null && !other.networkInterfaceId().equals(this.networkInterfaceId())) {
            return false;
        }
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.privateDnsName() == null ^ this.privateDnsName() == null) {
            return false;
        }
        if (other.privateDnsName() != null && !other.privateDnsName().equals(this.privateDnsName())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        if (other.privateIpAddress() != null && !other.privateIpAddress().equals(this.privateIpAddress())) {
            return false;
        }
        if (other.privateIpAddresses() == null ^ this.privateIpAddresses() == null) {
            return false;
        }
        if (other.privateIpAddresses() != null && !other.privateIpAddresses().equals(this.privateIpAddresses())) {
            return false;
        }
        if (other.sourceDestCheck() == null ^ this.sourceDestCheck() == null) {
            return false;
        }
        if (other.sourceDestCheck() != null && !other.sourceDestCheck().equals(this.sourceDestCheck())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (association() != null) {
            sb.append("Association: ").append(association()).append(",");
        }
        if (attachment() != null) {
            sb.append("Attachment: ").append(attachment()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (groups() != null) {
            sb.append("Groups: ").append(groups()).append(",");
        }
        if (ipv6Addresses() != null) {
            sb.append("Ipv6Addresses: ").append(ipv6Addresses()).append(",");
        }
        if (macAddress() != null) {
            sb.append("MacAddress: ").append(macAddress()).append(",");
        }
        if (networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(networkInterfaceId()).append(",");
        }
        if (ownerId() != null) {
            sb.append("OwnerId: ").append(ownerId()).append(",");
        }
        if (privateDnsName() != null) {
            sb.append("PrivateDnsName: ").append(privateDnsName()).append(",");
        }
        if (privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(privateIpAddress()).append(",");
        }
        if (privateIpAddresses() != null) {
            sb.append("PrivateIpAddresses: ").append(privateIpAddresses()).append(",");
        }
        if (sourceDestCheck() != null) {
            sb.append("SourceDestCheck: ").append(sourceDestCheck()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (subnetId() != null) {
            sb.append("SubnetId: ").append(subnetId()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceNetworkInterface> {
        /**
         * <p>
         * The association information for an Elastic IPv4 associated with the network interface.
         * </p>
         * 
         * @param association
         *        The association information for an Elastic IPv4 associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder association(InstanceNetworkInterfaceAssociation association);

        /**
         * <p>
         * The network interface attachment.
         * </p>
         * 
         * @param attachment
         *        The network interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(InstanceNetworkInterfaceAttachment attachment);

        /**
         * <p>
         * The description.
         * </p>
         * 
         * @param description
         *        The description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * One or more security groups.
         * </p>
         * 
         * @param groups
         *        One or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<GroupIdentifier> groups);

        /**
         * <p>
         * One or more security groups.
         * </p>
         * 
         * @param groups
         *        One or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(GroupIdentifier... groups);

        /**
         * <p>
         * One or more IPv6 addresses associated with the network interface.
         * </p>
         * 
         * @param ipv6Addresses
         *        One or more IPv6 addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses);

        /**
         * <p>
         * One or more IPv6 addresses associated with the network interface.
         * </p>
         * 
         * @param ipv6Addresses
         *        One or more IPv6 addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(InstanceIpv6Address... ipv6Addresses);

        /**
         * <p>
         * The MAC address.
         * </p>
         * 
         * @param macAddress
         *        The MAC address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddress(String macAddress);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The ID of the AWS account that created the network interface.
         * </p>
         * 
         * @param ownerId
         *        The ID of the AWS account that created the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The private DNS name.
         * </p>
         * 
         * @param privateDnsName
         *        The private DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * The IPv4 address of the network interface within the subnet.
         * </p>
         * 
         * @param privateIpAddress
         *        The IPv4 address of the network interface within the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * One or more private IPv4 addresses associated with the network interface.
         * </p>
         * 
         * @param privateIpAddresses
         *        One or more private IPv4 addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<InstancePrivateIpAddress> privateIpAddresses);

        /**
         * <p>
         * One or more private IPv4 addresses associated with the network interface.
         * </p>
         * 
         * @param privateIpAddresses
         *        One or more private IPv4 addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(InstancePrivateIpAddress... privateIpAddresses);

        /**
         * <p>
         * Indicates whether to validate network traffic to or from this network interface.
         * </p>
         * 
         * @param sourceDestCheck
         *        Indicates whether to validate network traffic to or from this network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(Boolean sourceDestCheck);

        /**
         * <p>
         * The status of the network interface.
         * </p>
         * 
         * @param status
         *        The status of the network interface.
         * @see NetworkInterfaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the network interface.
         * </p>
         * 
         * @param status
         *        The status of the network interface.
         * @see NetworkInterfaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceStatus
         */
        Builder status(NetworkInterfaceStatus status);

        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    private static final class BuilderImpl implements Builder {
        private InstanceNetworkInterfaceAssociation association;

        private InstanceNetworkInterfaceAttachment attachment;

        private String description;

        private List<GroupIdentifier> groups;

        private List<InstanceIpv6Address> ipv6Addresses;

        private String macAddress;

        private String networkInterfaceId;

        private String ownerId;

        private String privateDnsName;

        private String privateIpAddress;

        private List<InstancePrivateIpAddress> privateIpAddresses;

        private Boolean sourceDestCheck;

        private String status;

        private String subnetId;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworkInterface model) {
            setAssociation(model.association);
            setAttachment(model.attachment);
            setDescription(model.description);
            setGroups(model.groups);
            setIpv6Addresses(model.ipv6Addresses);
            setMacAddress(model.macAddress);
            setNetworkInterfaceId(model.networkInterfaceId);
            setOwnerId(model.ownerId);
            setPrivateDnsName(model.privateDnsName);
            setPrivateIpAddress(model.privateIpAddress);
            setPrivateIpAddresses(model.privateIpAddresses);
            setSourceDestCheck(model.sourceDestCheck);
            setStatus(model.status);
            setSubnetId(model.subnetId);
            setVpcId(model.vpcId);
        }

        public final InstanceNetworkInterfaceAssociation getAssociation() {
            return association;
        }

        @Override
        public final Builder association(InstanceNetworkInterfaceAssociation association) {
            this.association = association;
            return this;
        }

        public final void setAssociation(InstanceNetworkInterfaceAssociation association) {
            this.association = association;
        }

        public final InstanceNetworkInterfaceAttachment getAttachment() {
            return attachment;
        }

        @Override
        public final Builder attachment(InstanceNetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final void setAttachment(InstanceNetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<GroupIdentifier> getGroups() {
            return groups;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
        }

        @SafeVarargs
        public final void setGroups(GroupIdentifier... groups) {
            groups(Arrays.asList(groups));
        }

        public final Collection<InstanceIpv6Address> getIpv6Addresses() {
            return ipv6Addresses;
        }

        @Override
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
        }

        @SafeVarargs
        public final void setIpv6Addresses(InstanceIpv6Address... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
        }

        public final String getMacAddress() {
            return macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<InstancePrivateIpAddress> getPrivateIpAddresses() {
            return privateIpAddresses;
        }

        @Override
        public final Builder privateIpAddresses(Collection<InstancePrivateIpAddress> privateIpAddresses) {
            this.privateIpAddresses = InstancePrivateIpAddressListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(InstancePrivateIpAddress... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        public final void setPrivateIpAddresses(Collection<InstancePrivateIpAddress> privateIpAddresses) {
            this.privateIpAddresses = InstancePrivateIpAddressListCopier.copy(privateIpAddresses);
        }

        @SafeVarargs
        public final void setPrivateIpAddresses(InstancePrivateIpAddress... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
        }

        public final Boolean getSourceDestCheck() {
            return sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkInterfaceStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(NetworkInterfaceStatus status) {
            this.status(status.toString());
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public InstanceNetworkInterface build() {
            return new InstanceNetworkInterface(this);
        }
    }
}
