/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the instance status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceStatusDetails implements ToCopyableBuilder<InstanceStatusDetails.Builder, InstanceStatusDetails> {
    private final Instant impairedSince;

    private final String name;

    private final String status;

    private InstanceStatusDetails(BuilderImpl builder) {
        this.impairedSince = builder.impairedSince;
        this.name = builder.name;
        this.status = builder.status;
    }

    /**
     * <p>
     * The time when a status check failed. For an instance that was launched and impaired, this is the time when the
     * instance was launched.
     * </p>
     * 
     * @return The time when a status check failed. For an instance that was launched and impaired, this is the time
     *         when the instance was launched.
     */
    public Instant impairedSince() {
        return impairedSince;
    }

    /**
     * <p>
     * The type of instance status.
     * </p>
     * 
     * @return The type of instance status.
     * @see StatusName
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The status.
     * </p>
     * 
     * @return The status.
     * @see StatusType
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((impairedSince() == null) ? 0 : impairedSince().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatusDetails)) {
            return false;
        }
        InstanceStatusDetails other = (InstanceStatusDetails) obj;
        if (other.impairedSince() == null ^ this.impairedSince() == null) {
            return false;
        }
        if (other.impairedSince() != null && !other.impairedSince().equals(this.impairedSince())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (impairedSince() != null) {
            sb.append("ImpairedSince: ").append(impairedSince()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceStatusDetails> {
        /**
         * <p>
         * The time when a status check failed. For an instance that was launched and impaired, this is the time when
         * the instance was launched.
         * </p>
         * 
         * @param impairedSince
         *        The time when a status check failed. For an instance that was launched and impaired, this is the time
         *        when the instance was launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impairedSince(Instant impairedSince);

        /**
         * <p>
         * The type of instance status.
         * </p>
         * 
         * @param name
         *        The type of instance status.
         * @see StatusName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusName
         */
        Builder name(String name);

        /**
         * <p>
         * The type of instance status.
         * </p>
         * 
         * @param name
         *        The type of instance status.
         * @see StatusName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusName
         */
        Builder name(StatusName name);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder status(StatusType status);
    }

    private static final class BuilderImpl implements Builder {
        private Instant impairedSince;

        private String name;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatusDetails model) {
            setImpairedSince(model.impairedSince);
            setName(model.name);
            setStatus(model.status);
        }

        public final Instant getImpairedSince() {
            return impairedSince;
        }

        @Override
        public final Builder impairedSince(Instant impairedSince) {
            this.impairedSince = impairedSince;
            return this;
        }

        public final void setImpairedSince(Instant impairedSince) {
            this.impairedSince = impairedSince;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(StatusName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final void setName(StatusName name) {
            this.name(name.toString());
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(StatusType status) {
            this.status(status.toString());
        }

        @Override
        public InstanceStatusDetails build() {
            return new InstanceStatusDetails(this);
        }
    }
}
