/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceStatusSummary implements ToCopyableBuilder<InstanceStatusSummary.Builder, InstanceStatusSummary> {
    private final List<InstanceStatusDetails> details;

    private final String status;

    private InstanceStatusSummary(BuilderImpl builder) {
        this.details = builder.details;
        this.status = builder.status;
    }

    /**
     * <p>
     * The system instance health or application instance health.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The system instance health or application instance health.
     */
    public List<InstanceStatusDetails> details() {
        return details;
    }

    /**
     * <p>
     * The status.
     * </p>
     * 
     * @return The status.
     * @see SummaryStatus
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((details() == null) ? 0 : details().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatusSummary)) {
            return false;
        }
        InstanceStatusSummary other = (InstanceStatusSummary) obj;
        if (other.details() == null ^ this.details() == null) {
            return false;
        }
        if (other.details() != null && !other.details().equals(this.details())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (details() != null) {
            sb.append("Details: ").append(details()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceStatusSummary> {
        /**
         * <p>
         * The system instance health or application instance health.
         * </p>
         * 
         * @param details
         *        The system instance health or application instance health.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Collection<InstanceStatusDetails> details);

        /**
         * <p>
         * The system instance health or application instance health.
         * </p>
         * 
         * @param details
         *        The system instance health or application instance health.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(InstanceStatusDetails... details);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see SummaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SummaryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see SummaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SummaryStatus
         */
        Builder status(SummaryStatus status);
    }

    private static final class BuilderImpl implements Builder {
        private List<InstanceStatusDetails> details;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatusSummary model) {
            setDetails(model.details);
            setStatus(model.status);
        }

        public final Collection<InstanceStatusDetails> getDetails() {
            return details;
        }

        @Override
        public final Builder details(Collection<InstanceStatusDetails> details) {
            this.details = InstanceStatusDetailsListCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(InstanceStatusDetails... details) {
            details(Arrays.asList(details));
            return this;
        }

        public final void setDetails(Collection<InstanceStatusDetails> details) {
            this.details = InstanceStatusDetailsListCopier.copy(details);
        }

        @SafeVarargs
        public final void setDetails(InstanceStatusDetails... details) {
            details(Arrays.asList(details));
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SummaryStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(SummaryStatus status) {
            this.status(status.toString());
        }

        @Override
        public InstanceStatusSummary build() {
            return new InstanceStatusSummary(this);
        }
    }
}
