/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * [EC2-VPC only] Describes an IPv6 range.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Ipv6Range implements ToCopyableBuilder<Ipv6Range.Builder, Ipv6Range> {
    private final String cidrIpv6;

    private Ipv6Range(BuilderImpl builder) {
        this.cidrIpv6 = builder.cidrIpv6;
    }

    /**
     * <p>
     * The IPv6 CIDR range. You can either specify a CIDR range or a source security group, not both. To specify a
     * single IPv6 address, use the /128 prefix.
     * </p>
     * 
     * @return The IPv6 CIDR range. You can either specify a CIDR range or a source security group, not both. To specify
     *         a single IPv6 address, use the /128 prefix.
     */
    public String cidrIpv6() {
        return cidrIpv6;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((cidrIpv6() == null) ? 0 : cidrIpv6().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ipv6Range)) {
            return false;
        }
        Ipv6Range other = (Ipv6Range) obj;
        if (other.cidrIpv6() == null ^ this.cidrIpv6() == null) {
            return false;
        }
        if (other.cidrIpv6() != null && !other.cidrIpv6().equals(this.cidrIpv6())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (cidrIpv6() != null) {
            sb.append("CidrIpv6: ").append(cidrIpv6()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Ipv6Range> {
        /**
         * <p>
         * The IPv6 CIDR range. You can either specify a CIDR range or a source security group, not both. To specify a
         * single IPv6 address, use the /128 prefix.
         * </p>
         * 
         * @param cidrIpv6
         *        The IPv6 CIDR range. You can either specify a CIDR range or a source security group, not both. To
         *        specify a single IPv6 address, use the /128 prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIpv6(String cidrIpv6);
    }

    private static final class BuilderImpl implements Builder {
        private String cidrIpv6;

        private BuilderImpl() {
        }

        private BuilderImpl(Ipv6Range model) {
            setCidrIpv6(model.cidrIpv6);
        }

        public final String getCidrIpv6() {
            return cidrIpv6;
        }

        @Override
        public final Builder cidrIpv6(String cidrIpv6) {
            this.cidrIpv6 = cidrIpv6;
            return this;
        }

        public final void setCidrIpv6(String cidrIpv6) {
            this.cidrIpv6 = cidrIpv6;
        }

        @Override
        public Ipv6Range build() {
            return new Ipv6Range(this);
        }
    }
}
