/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the launch specification for an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LaunchSpecification implements ToCopyableBuilder<LaunchSpecification.Builder, LaunchSpecification> {
    private final String userData;

    private final String addressingType;

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final Boolean ebsOptimized;

    private final IamInstanceProfileSpecification iamInstanceProfile;

    private final String imageId;

    private final String instanceType;

    private final String kernelId;

    private final String keyName;

    private final List<InstanceNetworkInterfaceSpecification> networkInterfaces;

    private final SpotPlacement placement;

    private final String ramdiskId;

    private final String subnetId;

    private final List<GroupIdentifier> allSecurityGroups;

    private final Boolean monitoringEnabled;

    private final List<String> securityGroups;

    private LaunchSpecification(BuilderImpl builder) {
        this.userData = builder.userData;
        this.addressingType = builder.addressingType;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.networkInterfaces = builder.networkInterfaces;
        this.placement = builder.placement;
        this.ramdiskId = builder.ramdiskId;
        this.subnetId = builder.subnetId;
        this.allSecurityGroups = builder.allSecurityGroups;
        this.monitoringEnabled = builder.monitoringEnabled;
        this.securityGroups = builder.securityGroups;
    }

    /**
     * <p>
     * The user data to make available to the instances. If you are using an AWS SDK or command line tool,
     * Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide
     * Base64-encoded text.
     * </p>
     * 
     * @return The user data to make available to the instances. If you are using an AWS SDK or command line tool,
     *         Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide
     *         Base64-encoded text.
     */
    public String userData() {
        return userData;
    }

    /**
     * <p>
     * Deprecated.
     * </p>
     * 
     * @return Deprecated.
     */
    public String addressingType() {
        return addressingType;
    }

    /**
     * <p>
     * One or more block device mapping entries.
     * </p>
     * <p>
     * Although you can specify encrypted EBS volumes in this block device mapping for your Spot Instances, these
     * volumes are not encrypted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more block device mapping entries.</p>
     *         <p>
     *         Although you can specify encrypted EBS volumes in this block device mapping for your Spot Instances,
     *         these volumes are not encrypted.
     */
    public List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to
     * Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't
     * available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput
     *         to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This
     *         optimization isn't available with all instance types. Additional usage charges apply when using an EBS
     *         Optimized instance.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The IAM instance profile.
     * </p>
     * 
     * @return The IAM instance profile.
     */
    public IamInstanceProfileSpecification iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * 
     * @return The instance type.
     * @see InstanceType
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the kernel.
     * </p>
     * 
     * @return The ID of the kernel.
     */
    public String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The name of the key pair.
     * </p>
     * 
     * @return The name of the key pair.
     */
    public String keyName() {
        return keyName;
    }

    /**
     * <p>
     * One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security
     * group IDs using the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more network interfaces. If you specify a network interface, you must specify subnet IDs and
     *         security group IDs using the network interface.
     */
    public List<InstanceNetworkInterfaceSpecification> networkInterfaces() {
        return networkInterfaces;
    }

    /**
     * <p>
     * The placement information for the instance.
     * </p>
     * 
     * @return The placement information for the instance.
     */
    public SpotPlacement placement() {
        return placement;
    }

    /**
     * <p>
     * The ID of the RAM disk.
     * </p>
     * 
     * @return The ID of the RAM disk.
     */
    public String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * The ID of the subnet in which to launch the instance.
     * </p>
     * 
     * @return The ID of the subnet in which to launch the instance.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups.
     * When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security
     *         groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security
     *         groups.
     */
    public List<GroupIdentifier> allSecurityGroups() {
        return allSecurityGroups;
    }

    /**
     * Returns the value of the MonitoringEnabled property for this object.
     * 
     * @return The value of the MonitoringEnabled property for this object.
     */
    public Boolean monitoringEnabled() {
        return monitoringEnabled;
    }

    /**
     * <p>
     * One or more security group names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security group names.
     */
    public List<String> securityGroups() {
        return securityGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((userData() == null) ? 0 : userData().hashCode());
        hashCode = 31 * hashCode + ((addressingType() == null) ? 0 : addressingType().hashCode());
        hashCode = 31 * hashCode + ((blockDeviceMappings() == null) ? 0 : blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + ((ebsOptimized() == null) ? 0 : ebsOptimized().hashCode());
        hashCode = 31 * hashCode + ((iamInstanceProfile() == null) ? 0 : iamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + ((imageId() == null) ? 0 : imageId().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((kernelId() == null) ? 0 : kernelId().hashCode());
        hashCode = 31 * hashCode + ((keyName() == null) ? 0 : keyName().hashCode());
        hashCode = 31 * hashCode + ((networkInterfaces() == null) ? 0 : networkInterfaces().hashCode());
        hashCode = 31 * hashCode + ((placement() == null) ? 0 : placement().hashCode());
        hashCode = 31 * hashCode + ((ramdiskId() == null) ? 0 : ramdiskId().hashCode());
        hashCode = 31 * hashCode + ((subnetId() == null) ? 0 : subnetId().hashCode());
        hashCode = 31 * hashCode + ((allSecurityGroups() == null) ? 0 : allSecurityGroups().hashCode());
        hashCode = 31 * hashCode + ((monitoringEnabled() == null) ? 0 : monitoringEnabled().hashCode());
        hashCode = 31 * hashCode + ((securityGroups() == null) ? 0 : securityGroups().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchSpecification)) {
            return false;
        }
        LaunchSpecification other = (LaunchSpecification) obj;
        if (other.userData() == null ^ this.userData() == null) {
            return false;
        }
        if (other.userData() != null && !other.userData().equals(this.userData())) {
            return false;
        }
        if (other.addressingType() == null ^ this.addressingType() == null) {
            return false;
        }
        if (other.addressingType() != null && !other.addressingType().equals(this.addressingType())) {
            return false;
        }
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.iamInstanceProfile() == null ^ this.iamInstanceProfile() == null) {
            return false;
        }
        if (other.iamInstanceProfile() != null && !other.iamInstanceProfile().equals(this.iamInstanceProfile())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.kernelId() == null ^ this.kernelId() == null) {
            return false;
        }
        if (other.kernelId() != null && !other.kernelId().equals(this.kernelId())) {
            return false;
        }
        if (other.keyName() == null ^ this.keyName() == null) {
            return false;
        }
        if (other.keyName() != null && !other.keyName().equals(this.keyName())) {
            return false;
        }
        if (other.networkInterfaces() == null ^ this.networkInterfaces() == null) {
            return false;
        }
        if (other.networkInterfaces() != null && !other.networkInterfaces().equals(this.networkInterfaces())) {
            return false;
        }
        if (other.placement() == null ^ this.placement() == null) {
            return false;
        }
        if (other.placement() != null && !other.placement().equals(this.placement())) {
            return false;
        }
        if (other.ramdiskId() == null ^ this.ramdiskId() == null) {
            return false;
        }
        if (other.ramdiskId() != null && !other.ramdiskId().equals(this.ramdiskId())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.allSecurityGroups() == null ^ this.allSecurityGroups() == null) {
            return false;
        }
        if (other.allSecurityGroups() != null && !other.allSecurityGroups().equals(this.allSecurityGroups())) {
            return false;
        }
        if (other.monitoringEnabled() == null ^ this.monitoringEnabled() == null) {
            return false;
        }
        if (other.monitoringEnabled() != null && !other.monitoringEnabled().equals(this.monitoringEnabled())) {
            return false;
        }
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        if (other.securityGroups() != null && !other.securityGroups().equals(this.securityGroups())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (userData() != null) {
            sb.append("UserData: ").append(userData()).append(",");
        }
        if (addressingType() != null) {
            sb.append("AddressingType: ").append(addressingType()).append(",");
        }
        if (blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(blockDeviceMappings()).append(",");
        }
        if (ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(ebsOptimized()).append(",");
        }
        if (iamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(iamInstanceProfile()).append(",");
        }
        if (imageId() != null) {
            sb.append("ImageId: ").append(imageId()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (kernelId() != null) {
            sb.append("KernelId: ").append(kernelId()).append(",");
        }
        if (keyName() != null) {
            sb.append("KeyName: ").append(keyName()).append(",");
        }
        if (networkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(networkInterfaces()).append(",");
        }
        if (placement() != null) {
            sb.append("Placement: ").append(placement()).append(",");
        }
        if (ramdiskId() != null) {
            sb.append("RamdiskId: ").append(ramdiskId()).append(",");
        }
        if (subnetId() != null) {
            sb.append("SubnetId: ").append(subnetId()).append(",");
        }
        if (allSecurityGroups() != null) {
            sb.append("AllSecurityGroups: ").append(allSecurityGroups()).append(",");
        }
        if (monitoringEnabled() != null) {
            sb.append("MonitoringEnabled: ").append(monitoringEnabled()).append(",");
        }
        if (securityGroups() != null) {
            sb.append("SecurityGroups: ").append(securityGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, LaunchSpecification> {
        /**
         * <p>
         * The user data to make available to the instances. If you are using an AWS SDK or command line tool,
         * Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide
         * Base64-encoded text.
         * </p>
         * 
         * @param userData
         *        The user data to make available to the instances. If you are using an AWS SDK or command line tool,
         *        Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must
         *        provide Base64-encoded text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * Deprecated.
         * </p>
         * 
         * @param addressingType
         *        Deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressingType(String addressingType);

        /**
         * <p>
         * One or more block device mapping entries.
         * </p>
         * <p>
         * Although you can specify encrypted EBS volumes in this block device mapping for your Spot Instances, these
         * volumes are not encrypted.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more block device mapping entries.</p>
         *        <p>
         *        Although you can specify encrypted EBS volumes in this block device mapping for your Spot Instances,
         *        these volumes are not encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * One or more block device mapping entries.
         * </p>
         * <p>
         * Although you can specify encrypted EBS volumes in this block device mapping for your Spot Instances, these
         * volumes are not encrypted.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more block device mapping entries.</p>
         *        <p>
         *        Although you can specify encrypted EBS volumes in this block device mapping for your Spot Instances,
         *        these volumes are not encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to
         * Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization
         * isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated
         *        throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance.
         *        This optimization isn't available with all instance types. Additional usage charges apply when using
         *        an EBS Optimized instance.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The IAM instance profile.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The IAM instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile);

        /**
         * <p>
         * The ID of the AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The ID of the kernel.
         * </p>
         * 
         * @param kernelId
         *        The ID of the kernel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The name of the key pair.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security
         * group IDs using the network interface.
         * </p>
         * 
         * @param networkInterfaces
         *        One or more network interfaces. If you specify a network interface, you must specify subnet IDs and
         *        security group IDs using the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces);

        /**
         * <p>
         * One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security
         * group IDs using the network interface.
         * </p>
         * 
         * @param networkInterfaces
         *        One or more network interfaces. If you specify a network interface, you must specify subnet IDs and
         *        security group IDs using the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(InstanceNetworkInterfaceSpecification... networkInterfaces);

        /**
         * <p>
         * The placement information for the instance.
         * </p>
         * 
         * @param placement
         *        The placement information for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(SpotPlacement placement);

        /**
         * <p>
         * The ID of the RAM disk.
         * </p>
         * 
         * @param ramdiskId
         *        The ID of the RAM disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * The ID of the subnet in which to launch the instance.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet in which to launch the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security
         * groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security
         * groups.
         * </p>
         * 
         * @param allSecurityGroups
         *        One or more security groups. When requesting instances in a VPC, you must specify the IDs of the
         *        security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the
         *        security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allSecurityGroups(Collection<GroupIdentifier> allSecurityGroups);

        /**
         * <p>
         * One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security
         * groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security
         * groups.
         * </p>
         * 
         * @param allSecurityGroups
         *        One or more security groups. When requesting instances in a VPC, you must specify the IDs of the
         *        security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the
         *        security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allSecurityGroups(GroupIdentifier... allSecurityGroups);

        /**
         * Sets the value of the MonitoringEnabled property for this object.
         *
         * @param monitoringEnabled
         *        The new value for the MonitoringEnabled property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringEnabled(Boolean monitoringEnabled);

        /**
         * <p>
         * One or more security group names.
         * </p>
         * 
         * @param securityGroups
         *        One or more security group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * One or more security group names.
         * </p>
         * 
         * @param securityGroups
         *        One or more security group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);
    }

    private static final class BuilderImpl implements Builder {
        private String userData;

        private String addressingType;

        private List<BlockDeviceMapping> blockDeviceMappings;

        private Boolean ebsOptimized;

        private IamInstanceProfileSpecification iamInstanceProfile;

        private String imageId;

        private String instanceType;

        private String kernelId;

        private String keyName;

        private List<InstanceNetworkInterfaceSpecification> networkInterfaces;

        private SpotPlacement placement;

        private String ramdiskId;

        private String subnetId;

        private List<GroupIdentifier> allSecurityGroups;

        private Boolean monitoringEnabled;

        private List<String> securityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchSpecification model) {
            setUserData(model.userData);
            setAddressingType(model.addressingType);
            setBlockDeviceMappings(model.blockDeviceMappings);
            setEbsOptimized(model.ebsOptimized);
            setIamInstanceProfile(model.iamInstanceProfile);
            setImageId(model.imageId);
            setInstanceType(model.instanceType);
            setKernelId(model.kernelId);
            setKeyName(model.keyName);
            setNetworkInterfaces(model.networkInterfaces);
            setPlacement(model.placement);
            setRamdiskId(model.ramdiskId);
            setSubnetId(model.subnetId);
            setAllSecurityGroups(model.allSecurityGroups);
            setMonitoringEnabled(model.monitoringEnabled);
            setSecurityGroups(model.securityGroups);
        }

        public final String getUserData() {
            return userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getAddressingType() {
            return addressingType;
        }

        @Override
        public final Builder addressingType(String addressingType) {
            this.addressingType = addressingType;
            return this;
        }

        public final void setAddressingType(String addressingType) {
            this.addressingType = addressingType;
        }

        public final Collection<BlockDeviceMapping> getBlockDeviceMappings() {
            return blockDeviceMappings;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
        }

        @SafeVarargs
        public final void setBlockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final IamInstanceProfileSpecification getIamInstanceProfile() {
            return iamInstanceProfile;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final void setInstanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final Collection<InstanceNetworkInterfaceSpecification> getNetworkInterfaces() {
            return networkInterfaces;
        }

        @Override
        public final Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterfaceSpecification... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
        }

        @SafeVarargs
        public final void setNetworkInterfaces(InstanceNetworkInterfaceSpecification... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
        }

        public final SpotPlacement getPlacement() {
            return placement;
        }

        @Override
        public final Builder placement(SpotPlacement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(SpotPlacement placement) {
            this.placement = placement;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Collection<GroupIdentifier> getAllSecurityGroups() {
            return allSecurityGroups;
        }

        @Override
        public final Builder allSecurityGroups(Collection<GroupIdentifier> allSecurityGroups) {
            this.allSecurityGroups = GroupIdentifierListCopier.copy(allSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allSecurityGroups(GroupIdentifier... allSecurityGroups) {
            allSecurityGroups(Arrays.asList(allSecurityGroups));
            return this;
        }

        public final void setAllSecurityGroups(Collection<GroupIdentifier> allSecurityGroups) {
            this.allSecurityGroups = GroupIdentifierListCopier.copy(allSecurityGroups);
        }

        @SafeVarargs
        public final void setAllSecurityGroups(GroupIdentifier... allSecurityGroups) {
            allSecurityGroups(Arrays.asList(allSecurityGroups));
        }

        public final Boolean getMonitoringEnabled() {
            return monitoringEnabled;
        }

        @Override
        public final Builder monitoringEnabled(Boolean monitoringEnabled) {
            this.monitoringEnabled = monitoringEnabled;
            return this;
        }

        public final void setMonitoringEnabled(Boolean monitoringEnabled) {
            this.monitoringEnabled = monitoringEnabled;
        }

        public final Collection<String> getSecurityGroups() {
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = GroupNameStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = GroupNameStringListCopier.copy(securityGroups);
        }

        @SafeVarargs
        public final void setSecurityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
        }

        @Override
        public LaunchSpecification build() {
            return new LaunchSpecification(this);
        }
    }
}
