/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifyInstanceAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyInstanceAttributeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ModifyInstanceAttributeRequest.Builder, ModifyInstanceAttributeRequest> {
    private final Boolean sourceDestCheck;

    private final String attribute;

    private final List<InstanceBlockDeviceMappingSpecification> blockDeviceMappings;

    private final Boolean disableApiTermination;

    private final Boolean ebsOptimized;

    private final Boolean enaSupport;

    private final List<String> groups;

    private final String instanceId;

    private final String instanceInitiatedShutdownBehavior;

    private final String instanceType;

    private final String kernel;

    private final String ramdisk;

    private final String sriovNetSupport;

    private final String userData;

    private final String value;

    private ModifyInstanceAttributeRequest(BuilderImpl builder) {
        this.sourceDestCheck = builder.sourceDestCheck;
        this.attribute = builder.attribute;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.disableApiTermination = builder.disableApiTermination;
        this.ebsOptimized = builder.ebsOptimized;
        this.enaSupport = builder.enaSupport;
        this.groups = builder.groups;
        this.instanceId = builder.instanceId;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.instanceType = builder.instanceType;
        this.kernel = builder.kernel;
        this.ramdisk = builder.ramdisk;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.userData = builder.userData;
        this.value = builder.value;
    }

    /**
     * <p>
     * Specifies whether source/destination checking is enabled. A value of <code>true</code> means that checking is
     * enabled, and <code>false</code> means checking is disabled. This value must be <code>false</code> for a NAT
     * instance to perform NAT.
     * </p>
     * 
     * @return Specifies whether source/destination checking is enabled. A value of <code>true</code> means that
     *         checking is enabled, and <code>false</code> means checking is disabled. This value must be
     *         <code>false</code> for a NAT instance to perform NAT.
     */
    public Boolean sourceDestCheck() {
        return sourceDestCheck;
    }

    /**
     * <p>
     * The name of the attribute.
     * </p>
     * 
     * @return The name of the attribute.
     * @see InstanceAttributeName
     */
    public String attribute() {
        return attribute;
    }

    /**
     * <p>
     * Modifies the <code>DeleteOnTermination</code> attribute for volumes that are currently attached. The volume must
     * be owned by the caller. If no value is specified for <code>DeleteOnTermination</code>, the default is
     * <code>true</code> and the volume is deleted when the instance is terminated.
     * </p>
     * <p>
     * To add instance store volumes to an Amazon EBS-backed instance, you must add them when you launch the instance.
     * For more information, see <a href=
     * "http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM"
     * >Updating the Block Device Mapping when Launching an Instance</a> in the <i>Amazon Elastic Compute Cloud User
     * Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Modifies the <code>DeleteOnTermination</code> attribute for volumes that are currently attached. The
     *         volume must be owned by the caller. If no value is specified for <code>DeleteOnTermination</code>, the
     *         default is <code>true</code> and the volume is deleted when the instance is terminated.</p>
     *         <p>
     *         To add instance store volumes to an Amazon EBS-backed instance, you must add them when you launch the
     *         instance. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM"
     *         >Updating the Block Device Mapping when Launching an Instance</a> in the <i>Amazon Elastic Compute Cloud
     *         User Guide</i>.
     */
    public List<InstanceBlockDeviceMappingSpecification> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * If the value is <code>true</code>, you can't terminate the instance using the Amazon EC2 console, CLI, or API;
     * otherwise, you can. You cannot use this paramater for Spot Instances.
     * </p>
     * 
     * @return If the value is <code>true</code>, you can't terminate the instance using the Amazon EC2 console, CLI, or
     *         API; otherwise, you can. You cannot use this paramater for Spot Instances.
     */
    public Boolean disableApiTermination() {
        return disableApiTermination;
    }

    /**
     * <p>
     * Specifies whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to
     * Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't
     * available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
     * </p>
     * 
     * @return Specifies whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput
     *         to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This
     *         optimization isn't available with all instance types. Additional usage charges apply when using an EBS
     *         Optimized instance.
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * Set to <code>true</code> to enable enhanced networking with ENA for the instance.
     * </p>
     * <p>
     * This option is supported only for HVM instances. Specifying this option with a PV instance can make it
     * unreachable.
     * </p>
     * 
     * @return Set to <code>true</code> to enable enhanced networking with ENA for the instance.</p>
     *         <p>
     *         This option is supported only for HVM instances. Specifying this option with a PV instance can make it
     *         unreachable.
     */
    public Boolean enaSupport() {
        return enaSupport;
    }

    /**
     * <p>
     * [EC2-VPC] Changes the security groups of the instance. You must specify at least one security group, even if it's
     * just the default security group for the VPC. You must specify the security group ID, not the security group name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return [EC2-VPC] Changes the security groups of the instance. You must specify at least one security group, even
     *         if it's just the default security group for the VPC. You must specify the security group ID, not the
     *         security group name.
     */
    public List<String> groups() {
        return groups;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Specifies whether an instance stops or terminates when you initiate shutdown from the instance (using the
     * operating system command for system shutdown).
     * </p>
     * 
     * @return Specifies whether an instance stops or terminates when you initiate shutdown from the instance (using the
     *         operating system command for system shutdown).
     */
    public String instanceInitiatedShutdownBehavior() {
        return instanceInitiatedShutdownBehavior;
    }

    /**
     * <p>
     * Changes the instance type to the specified value. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a>. If the instance
     * type is not valid, the error returned is <code>InvalidInstanceAttributeValue</code>.
     * </p>
     * 
     * @return Changes the instance type to the specified value. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a>. If the
     *         instance type is not valid, the error returned is <code>InvalidInstanceAttributeValue</code>.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * Changes the instance's kernel to the specified value. We recommend that you use PV-GRUB instead of kernels and
     * RAM disks. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.
     * </p>
     * 
     * @return Changes the instance's kernel to the specified value. We recommend that you use PV-GRUB instead of
     *         kernels and RAM disks. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.
     */
    public String kernel() {
        return kernel;
    }

    /**
     * <p>
     * Changes the instance's RAM disk to the specified value. We recommend that you use PV-GRUB instead of kernels and
     * RAM disks. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.
     * </p>
     * 
     * @return Changes the instance's RAM disk to the specified value. We recommend that you use PV-GRUB instead of
     *         kernels and RAM disks. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.
     */
    public String ramdisk() {
        return ramdisk;
    }

    /**
     * <p>
     * Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function interface for the
     * instance.
     * </p>
     * <p>
     * There is no way to disable enhanced networking with the Intel 82599 Virtual Function interface at this time.
     * </p>
     * <p>
     * This option is supported only for HVM instances. Specifying this option with a PV instance can make it
     * unreachable.
     * </p>
     * 
     * @return Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function interface
     *         for the instance.</p>
     *         <p>
     *         There is no way to disable enhanced networking with the Intel 82599 Virtual Function interface at this
     *         time.
     *         </p>
     *         <p>
     *         This option is supported only for HVM instances. Specifying this option with a PV instance can make it
     *         unreachable.
     */
    public String sriovNetSupport() {
        return sriovNetSupport;
    }

    /**
     * <p>
     * Changes the instance's user data to the specified value. If you are using an AWS SDK or command line tool,
     * Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide
     * Base64-encoded text.
     * </p>
     * 
     * @return Changes the instance's user data to the specified value. If you are using an AWS SDK or command line
     *         tool, Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must
     *         provide Base64-encoded text.
     */
    public String userData() {
        return userData;
    }

    /**
     * <p>
     * A new value for the attribute. Use only with the <code>kernel</code>, <code>ramdisk</code>, <code>userData</code>, <code>disableApiTermination</code>, or <code>instanceInitiatedShutdownBehavior</code> attribute.
     * </p>
     * 
     * @return A new value for the attribute. Use only with the <code>kernel</code>, <code>ramdisk</code>,
     *         <code>userData</code>, <code>disableApiTermination</code>, or
     *         <code>instanceInitiatedShutdownBehavior</code> attribute.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((sourceDestCheck() == null) ? 0 : sourceDestCheck().hashCode());
        hashCode = 31 * hashCode + ((attribute() == null) ? 0 : attribute().hashCode());
        hashCode = 31 * hashCode + ((blockDeviceMappings() == null) ? 0 : blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + ((disableApiTermination() == null) ? 0 : disableApiTermination().hashCode());
        hashCode = 31 * hashCode + ((ebsOptimized() == null) ? 0 : ebsOptimized().hashCode());
        hashCode = 31 * hashCode + ((enaSupport() == null) ? 0 : enaSupport().hashCode());
        hashCode = 31 * hashCode + ((groups() == null) ? 0 : groups().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode
                + ((instanceInitiatedShutdownBehavior() == null) ? 0 : instanceInitiatedShutdownBehavior().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((kernel() == null) ? 0 : kernel().hashCode());
        hashCode = 31 * hashCode + ((ramdisk() == null) ? 0 : ramdisk().hashCode());
        hashCode = 31 * hashCode + ((sriovNetSupport() == null) ? 0 : sriovNetSupport().hashCode());
        hashCode = 31 * hashCode + ((userData() == null) ? 0 : userData().hashCode());
        hashCode = 31 * hashCode + ((value() == null) ? 0 : value().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceAttributeRequest)) {
            return false;
        }
        ModifyInstanceAttributeRequest other = (ModifyInstanceAttributeRequest) obj;
        if (other.sourceDestCheck() == null ^ this.sourceDestCheck() == null) {
            return false;
        }
        if (other.sourceDestCheck() != null && !other.sourceDestCheck().equals(this.sourceDestCheck())) {
            return false;
        }
        if (other.attribute() == null ^ this.attribute() == null) {
            return false;
        }
        if (other.attribute() != null && !other.attribute().equals(this.attribute())) {
            return false;
        }
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.disableApiTermination() == null ^ this.disableApiTermination() == null) {
            return false;
        }
        if (other.disableApiTermination() != null && !other.disableApiTermination().equals(this.disableApiTermination())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.enaSupport() == null ^ this.enaSupport() == null) {
            return false;
        }
        if (other.enaSupport() != null && !other.enaSupport().equals(this.enaSupport())) {
            return false;
        }
        if (other.groups() == null ^ this.groups() == null) {
            return false;
        }
        if (other.groups() != null && !other.groups().equals(this.groups())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.instanceInitiatedShutdownBehavior() == null ^ this.instanceInitiatedShutdownBehavior() == null) {
            return false;
        }
        if (other.instanceInitiatedShutdownBehavior() != null
                && !other.instanceInitiatedShutdownBehavior().equals(this.instanceInitiatedShutdownBehavior())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.kernel() == null ^ this.kernel() == null) {
            return false;
        }
        if (other.kernel() != null && !other.kernel().equals(this.kernel())) {
            return false;
        }
        if (other.ramdisk() == null ^ this.ramdisk() == null) {
            return false;
        }
        if (other.ramdisk() != null && !other.ramdisk().equals(this.ramdisk())) {
            return false;
        }
        if (other.sriovNetSupport() == null ^ this.sriovNetSupport() == null) {
            return false;
        }
        if (other.sriovNetSupport() != null && !other.sriovNetSupport().equals(this.sriovNetSupport())) {
            return false;
        }
        if (other.userData() == null ^ this.userData() == null) {
            return false;
        }
        if (other.userData() != null && !other.userData().equals(this.userData())) {
            return false;
        }
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (sourceDestCheck() != null) {
            sb.append("SourceDestCheck: ").append(sourceDestCheck()).append(",");
        }
        if (attribute() != null) {
            sb.append("Attribute: ").append(attribute()).append(",");
        }
        if (blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(blockDeviceMappings()).append(",");
        }
        if (disableApiTermination() != null) {
            sb.append("DisableApiTermination: ").append(disableApiTermination()).append(",");
        }
        if (ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(ebsOptimized()).append(",");
        }
        if (enaSupport() != null) {
            sb.append("EnaSupport: ").append(enaSupport()).append(",");
        }
        if (groups() != null) {
            sb.append("Groups: ").append(groups()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (instanceInitiatedShutdownBehavior() != null) {
            sb.append("InstanceInitiatedShutdownBehavior: ").append(instanceInitiatedShutdownBehavior()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (kernel() != null) {
            sb.append("Kernel: ").append(kernel()).append(",");
        }
        if (ramdisk() != null) {
            sb.append("Ramdisk: ").append(ramdisk()).append(",");
        }
        if (sriovNetSupport() != null) {
            sb.append("SriovNetSupport: ").append(sriovNetSupport()).append(",");
        }
        if (userData() != null) {
            sb.append("UserData: ").append(userData()).append(",");
        }
        if (value() != null) {
            sb.append("Value: ").append(value()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ModifyInstanceAttributeRequest> {
        /**
         * <p>
         * Specifies whether source/destination checking is enabled. A value of <code>true</code> means that checking is
         * enabled, and <code>false</code> means checking is disabled. This value must be <code>false</code> for a NAT
         * instance to perform NAT.
         * </p>
         * 
         * @param sourceDestCheck
         *        Specifies whether source/destination checking is enabled. A value of <code>true</code> means that
         *        checking is enabled, and <code>false</code> means checking is disabled. This value must be
         *        <code>false</code> for a NAT instance to perform NAT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(Boolean sourceDestCheck);

        /**
         * <p>
         * The name of the attribute.
         * </p>
         * 
         * @param attribute
         *        The name of the attribute.
         * @see InstanceAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The name of the attribute.
         * </p>
         * 
         * @param attribute
         *        The name of the attribute.
         * @see InstanceAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAttributeName
         */
        Builder attribute(InstanceAttributeName attribute);

        /**
         * <p>
         * Modifies the <code>DeleteOnTermination</code> attribute for volumes that are currently attached. The volume
         * must be owned by the caller. If no value is specified for <code>DeleteOnTermination</code>, the default is
         * <code>true</code> and the volume is deleted when the instance is terminated.
         * </p>
         * <p>
         * To add instance store volumes to an Amazon EBS-backed instance, you must add them when you launch the
         * instance. For more information, see <a href=
         * "http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM"
         * >Updating the Block Device Mapping when Launching an Instance</a> in the <i>Amazon Elastic Compute Cloud User
         * Guide</i>.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Modifies the <code>DeleteOnTermination</code> attribute for volumes that are currently attached. The
         *        volume must be owned by the caller. If no value is specified for <code>DeleteOnTermination</code>, the
         *        default is <code>true</code> and the volume is deleted when the instance is terminated.</p>
         *        <p>
         *        To add instance store volumes to an Amazon EBS-backed instance, you must add them when you launch the
         *        instance. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM"
         *        >Updating the Block Device Mapping when Launching an Instance</a> in the <i>Amazon Elastic Compute
         *        Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<InstanceBlockDeviceMappingSpecification> blockDeviceMappings);

        /**
         * <p>
         * Modifies the <code>DeleteOnTermination</code> attribute for volumes that are currently attached. The volume
         * must be owned by the caller. If no value is specified for <code>DeleteOnTermination</code>, the default is
         * <code>true</code> and the volume is deleted when the instance is terminated.
         * </p>
         * <p>
         * To add instance store volumes to an Amazon EBS-backed instance, you must add them when you launch the
         * instance. For more information, see <a href=
         * "http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM"
         * >Updating the Block Device Mapping when Launching an Instance</a> in the <i>Amazon Elastic Compute Cloud User
         * Guide</i>.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Modifies the <code>DeleteOnTermination</code> attribute for volumes that are currently attached. The
         *        volume must be owned by the caller. If no value is specified for <code>DeleteOnTermination</code>, the
         *        default is <code>true</code> and the volume is deleted when the instance is terminated.</p>
         *        <p>
         *        To add instance store volumes to an Amazon EBS-backed instance, you must add them when you launch the
         *        instance. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM"
         *        >Updating the Block Device Mapping when Launching an Instance</a> in the <i>Amazon Elastic Compute
         *        Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(InstanceBlockDeviceMappingSpecification... blockDeviceMappings);

        /**
         * <p>
         * If the value is <code>true</code>, you can't terminate the instance using the Amazon EC2 console, CLI, or
         * API; otherwise, you can. You cannot use this paramater for Spot Instances.
         * </p>
         * 
         * @param disableApiTermination
         *        If the value is <code>true</code>, you can't terminate the instance using the Amazon EC2 console, CLI,
         *        or API; otherwise, you can. You cannot use this paramater for Spot Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableApiTermination(Boolean disableApiTermination);

        /**
         * <p>
         * Specifies whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to
         * Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization
         * isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
         * </p>
         * 
         * @param ebsOptimized
         *        Specifies whether the instance is optimized for EBS I/O. This optimization provides dedicated
         *        throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance.
         *        This optimization isn't available with all instance types. Additional usage charges apply when using
         *        an EBS Optimized instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * Set to <code>true</code> to enable enhanced networking with ENA for the instance.
         * </p>
         * <p>
         * This option is supported only for HVM instances. Specifying this option with a PV instance can make it
         * unreachable.
         * </p>
         * 
         * @param enaSupport
         *        Set to <code>true</code> to enable enhanced networking with ENA for the instance.</p>
         *        <p>
         *        This option is supported only for HVM instances. Specifying this option with a PV instance can make it
         *        unreachable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSupport(Boolean enaSupport);

        /**
         * <p>
         * [EC2-VPC] Changes the security groups of the instance. You must specify at least one security group, even if
         * it's just the default security group for the VPC. You must specify the security group ID, not the security
         * group name.
         * </p>
         * 
         * @param groups
         *        [EC2-VPC] Changes the security groups of the instance. You must specify at least one security group,
         *        even if it's just the default security group for the VPC. You must specify the security group ID, not
         *        the security group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String> groups);

        /**
         * <p>
         * [EC2-VPC] Changes the security groups of the instance. You must specify at least one security group, even if
         * it's just the default security group for the VPC. You must specify the security group ID, not the security
         * group name.
         * </p>
         * 
         * @param groups
         *        [EC2-VPC] Changes the security groups of the instance. You must specify at least one security group,
         *        even if it's just the default security group for the VPC. You must specify the security group ID, not
         *        the security group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String... groups);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Specifies whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * 
         * @param instanceInitiatedShutdownBehavior
         *        Specifies whether an instance stops or terminates when you initiate shutdown from the instance (using
         *        the operating system command for system shutdown).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior);

        /**
         * <p>
         * Changes the instance type to the specified value. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a>. If the
         * instance type is not valid, the error returned is <code>InvalidInstanceAttributeValue</code>.
         * </p>
         * 
         * @param instanceType
         *        Changes the instance type to the specified value. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a>. If
         *        the instance type is not valid, the error returned is <code>InvalidInstanceAttributeValue</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * Changes the instance's kernel to the specified value. We recommend that you use PV-GRUB instead of kernels
         * and RAM disks. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.
         * </p>
         * 
         * @param kernel
         *        Changes the instance's kernel to the specified value. We recommend that you use PV-GRUB instead of
         *        kernels and RAM disks. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernel(String kernel);

        /**
         * <p>
         * Changes the instance's RAM disk to the specified value. We recommend that you use PV-GRUB instead of kernels
         * and RAM disks. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.
         * </p>
         * 
         * @param ramdisk
         *        Changes the instance's RAM disk to the specified value. We recommend that you use PV-GRUB instead of
         *        kernels and RAM disks. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdisk(String ramdisk);

        /**
         * <p>
         * Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function interface for
         * the instance.
         * </p>
         * <p>
         * There is no way to disable enhanced networking with the Intel 82599 Virtual Function interface at this time.
         * </p>
         * <p>
         * This option is supported only for HVM instances. Specifying this option with a PV instance can make it
         * unreachable.
         * </p>
         * 
         * @param sriovNetSupport
         *        Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function
         *        interface for the instance.</p>
         *        <p>
         *        There is no way to disable enhanced networking with the Intel 82599 Virtual Function interface at this
         *        time.
         *        </p>
         *        <p>
         *        This option is supported only for HVM instances. Specifying this option with a PV instance can make it
         *        unreachable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sriovNetSupport(String sriovNetSupport);

        /**
         * <p>
         * Changes the instance's user data to the specified value. If you are using an AWS SDK or command line tool,
         * Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide
         * Base64-encoded text.
         * </p>
         * 
         * @param userData
         *        Changes the instance's user data to the specified value. If you are using an AWS SDK or command line
         *        tool, Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must
         *        provide Base64-encoded text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * A new value for the attribute. Use only with the <code>kernel</code>, <code>ramdisk</code>,
         * <code>userData</code>, <code>disableApiTermination</code>, or <code>instanceInitiatedShutdownBehavior</code>
         * attribute.
         * </p>
         * 
         * @param value
         *        A new value for the attribute. Use only with the <code>kernel</code>, <code>ramdisk</code>,
         *        <code>userData</code>, <code>disableApiTermination</code>, or
         *        <code>instanceInitiatedShutdownBehavior</code> attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean sourceDestCheck;

        private String attribute;

        private List<InstanceBlockDeviceMappingSpecification> blockDeviceMappings;

        private Boolean disableApiTermination;

        private Boolean ebsOptimized;

        private Boolean enaSupport;

        private List<String> groups;

        private String instanceId;

        private String instanceInitiatedShutdownBehavior;

        private String instanceType;

        private String kernel;

        private String ramdisk;

        private String sriovNetSupport;

        private String userData;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceAttributeRequest model) {
            setSourceDestCheck(model.sourceDestCheck);
            setAttribute(model.attribute);
            setBlockDeviceMappings(model.blockDeviceMappings);
            setDisableApiTermination(model.disableApiTermination);
            setEbsOptimized(model.ebsOptimized);
            setEnaSupport(model.enaSupport);
            setGroups(model.groups);
            setInstanceId(model.instanceId);
            setInstanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            setInstanceType(model.instanceType);
            setKernel(model.kernel);
            setRamdisk(model.ramdisk);
            setSriovNetSupport(model.sriovNetSupport);
            setUserData(model.userData);
            setValue(model.value);
        }

        public final Boolean getSourceDestCheck() {
            return sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(InstanceAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final void setAttribute(InstanceAttributeName attribute) {
            this.attribute(attribute.toString());
        }

        public final Collection<InstanceBlockDeviceMappingSpecification> getBlockDeviceMappings() {
            return blockDeviceMappings;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMappingSpecification> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingSpecificationListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMappingSpecification... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMappingSpecification> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingSpecificationListCopier.copy(blockDeviceMappings);
        }

        @SafeVarargs
        public final void setBlockDeviceMappings(InstanceBlockDeviceMappingSpecification... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
        }

        public final Boolean getDisableApiTermination() {
            return disableApiTermination;
        }

        @Override
        public final Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final Boolean getEnaSupport() {
            return enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        public final Collection<String> getGroups() {
            return groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = GroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = GroupIdStringListCopier.copy(groups);
        }

        @SafeVarargs
        public final void setGroups(String... groups) {
            groups(Arrays.asList(groups));
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernel() {
            return kernel;
        }

        @Override
        public final Builder kernel(String kernel) {
            this.kernel = kernel;
            return this;
        }

        public final void setKernel(String kernel) {
            this.kernel = kernel;
        }

        public final String getRamdisk() {
            return ramdisk;
        }

        @Override
        public final Builder ramdisk(String ramdisk) {
            this.ramdisk = ramdisk;
            return this;
        }

        public final void setRamdisk(String ramdisk) {
            this.ramdisk = ramdisk;
        }

        public final String getSriovNetSupport() {
            return sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        public final String getUserData() {
            return userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public ModifyInstanceAttributeRequest build() {
            return new ModifyInstanceAttributeRequest(this);
        }
    }
}
