/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifyVpcEndpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyVpcEndpointRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ModifyVpcEndpointRequest.Builder, ModifyVpcEndpointRequest> {
    private final List<String> addRouteTableIds;

    private final String policyDocument;

    private final List<String> removeRouteTableIds;

    private final Boolean resetPolicy;

    private final String vpcEndpointId;

    private ModifyVpcEndpointRequest(BuilderImpl builder) {
        this.addRouteTableIds = builder.addRouteTableIds;
        this.policyDocument = builder.policyDocument;
        this.removeRouteTableIds = builder.removeRouteTableIds;
        this.resetPolicy = builder.resetPolicy;
        this.vpcEndpointId = builder.vpcEndpointId;
    }

    /**
     * <p>
     * One or more route tables IDs to associate with the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more route tables IDs to associate with the endpoint.
     */
    public List<String> addRouteTableIds() {
        return addRouteTableIds;
    }

    /**
     * <p>
     * A policy document to attach to the endpoint. The policy must be in valid JSON format.
     * </p>
     * 
     * @return A policy document to attach to the endpoint. The policy must be in valid JSON format.
     */
    public String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * One or more route table IDs to disassociate from the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more route table IDs to disassociate from the endpoint.
     */
    public List<String> removeRouteTableIds() {
        return removeRouteTableIds;
    }

    /**
     * <p>
     * Specify <code>true</code> to reset the policy document to the default policy. The default policy allows access to
     * the service.
     * </p>
     * 
     * @return Specify <code>true</code> to reset the policy document to the default policy. The default policy allows
     *         access to the service.
     */
    public Boolean resetPolicy() {
        return resetPolicy;
    }

    /**
     * <p>
     * The ID of the endpoint.
     * </p>
     * 
     * @return The ID of the endpoint.
     */
    public String vpcEndpointId() {
        return vpcEndpointId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((addRouteTableIds() == null) ? 0 : addRouteTableIds().hashCode());
        hashCode = 31 * hashCode + ((policyDocument() == null) ? 0 : policyDocument().hashCode());
        hashCode = 31 * hashCode + ((removeRouteTableIds() == null) ? 0 : removeRouteTableIds().hashCode());
        hashCode = 31 * hashCode + ((resetPolicy() == null) ? 0 : resetPolicy().hashCode());
        hashCode = 31 * hashCode + ((vpcEndpointId() == null) ? 0 : vpcEndpointId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointRequest)) {
            return false;
        }
        ModifyVpcEndpointRequest other = (ModifyVpcEndpointRequest) obj;
        if (other.addRouteTableIds() == null ^ this.addRouteTableIds() == null) {
            return false;
        }
        if (other.addRouteTableIds() != null && !other.addRouteTableIds().equals(this.addRouteTableIds())) {
            return false;
        }
        if (other.policyDocument() == null ^ this.policyDocument() == null) {
            return false;
        }
        if (other.policyDocument() != null && !other.policyDocument().equals(this.policyDocument())) {
            return false;
        }
        if (other.removeRouteTableIds() == null ^ this.removeRouteTableIds() == null) {
            return false;
        }
        if (other.removeRouteTableIds() != null && !other.removeRouteTableIds().equals(this.removeRouteTableIds())) {
            return false;
        }
        if (other.resetPolicy() == null ^ this.resetPolicy() == null) {
            return false;
        }
        if (other.resetPolicy() != null && !other.resetPolicy().equals(this.resetPolicy())) {
            return false;
        }
        if (other.vpcEndpointId() == null ^ this.vpcEndpointId() == null) {
            return false;
        }
        if (other.vpcEndpointId() != null && !other.vpcEndpointId().equals(this.vpcEndpointId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (addRouteTableIds() != null) {
            sb.append("AddRouteTableIds: ").append(addRouteTableIds()).append(",");
        }
        if (policyDocument() != null) {
            sb.append("PolicyDocument: ").append(policyDocument()).append(",");
        }
        if (removeRouteTableIds() != null) {
            sb.append("RemoveRouteTableIds: ").append(removeRouteTableIds()).append(",");
        }
        if (resetPolicy() != null) {
            sb.append("ResetPolicy: ").append(resetPolicy()).append(",");
        }
        if (vpcEndpointId() != null) {
            sb.append("VpcEndpointId: ").append(vpcEndpointId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ModifyVpcEndpointRequest> {
        /**
         * <p>
         * One or more route tables IDs to associate with the endpoint.
         * </p>
         * 
         * @param addRouteTableIds
         *        One or more route tables IDs to associate with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addRouteTableIds(Collection<String> addRouteTableIds);

        /**
         * <p>
         * One or more route tables IDs to associate with the endpoint.
         * </p>
         * 
         * @param addRouteTableIds
         *        One or more route tables IDs to associate with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addRouteTableIds(String... addRouteTableIds);

        /**
         * <p>
         * A policy document to attach to the endpoint. The policy must be in valid JSON format.
         * </p>
         * 
         * @param policyDocument
         *        A policy document to attach to the endpoint. The policy must be in valid JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * One or more route table IDs to disassociate from the endpoint.
         * </p>
         * 
         * @param removeRouteTableIds
         *        One or more route table IDs to disassociate from the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeRouteTableIds(Collection<String> removeRouteTableIds);

        /**
         * <p>
         * One or more route table IDs to disassociate from the endpoint.
         * </p>
         * 
         * @param removeRouteTableIds
         *        One or more route table IDs to disassociate from the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeRouteTableIds(String... removeRouteTableIds);

        /**
         * <p>
         * Specify <code>true</code> to reset the policy document to the default policy. The default policy allows
         * access to the service.
         * </p>
         * 
         * @param resetPolicy
         *        Specify <code>true</code> to reset the policy document to the default policy. The default policy
         *        allows access to the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resetPolicy(Boolean resetPolicy);

        /**
         * <p>
         * The ID of the endpoint.
         * </p>
         * 
         * @param vpcEndpointId
         *        The ID of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> addRouteTableIds;

        private String policyDocument;

        private List<String> removeRouteTableIds;

        private Boolean resetPolicy;

        private String vpcEndpointId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointRequest model) {
            setAddRouteTableIds(model.addRouteTableIds);
            setPolicyDocument(model.policyDocument);
            setRemoveRouteTableIds(model.removeRouteTableIds);
            setResetPolicy(model.resetPolicy);
            setVpcEndpointId(model.vpcEndpointId);
        }

        public final Collection<String> getAddRouteTableIds() {
            return addRouteTableIds;
        }

        @Override
        public final Builder addRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = ValueStringListCopier.copy(addRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addRouteTableIds(String... addRouteTableIds) {
            addRouteTableIds(Arrays.asList(addRouteTableIds));
            return this;
        }

        public final void setAddRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = ValueStringListCopier.copy(addRouteTableIds);
        }

        @SafeVarargs
        public final void setAddRouteTableIds(String... addRouteTableIds) {
            addRouteTableIds(Arrays.asList(addRouteTableIds));
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final Collection<String> getRemoveRouteTableIds() {
            return removeRouteTableIds;
        }

        @Override
        public final Builder removeRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = ValueStringListCopier.copy(removeRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeRouteTableIds(String... removeRouteTableIds) {
            removeRouteTableIds(Arrays.asList(removeRouteTableIds));
            return this;
        }

        public final void setRemoveRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = ValueStringListCopier.copy(removeRouteTableIds);
        }

        @SafeVarargs
        public final void setRemoveRouteTableIds(String... removeRouteTableIds) {
            removeRouteTableIds(Arrays.asList(removeRouteTableIds));
        }

        public final Boolean getResetPolicy() {
            return resetPolicy;
        }

        @Override
        public final Builder resetPolicy(Boolean resetPolicy) {
            this.resetPolicy = resetPolicy;
            return this;
        }

        public final void setResetPolicy(Boolean resetPolicy) {
            this.resetPolicy = resetPolicy;
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public ModifyVpcEndpointRequest build() {
            return new ModifyVpcEndpointRequest(this);
        }
    }
}
